// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#include "Settings_screen.h"




// *******************
// *** CONSTRUCTOR ***
// *******************
FS::Settings_screen::Settings_screen(Settings* sp) : settings_ptr(sp)
{
    // Set up the 'options' vector.
    for ( int i = 0; i < num_options; ++i )
    {
        FS_gfx::Image_name s0 = static_cast<FS_gfx::Image_name>
                ( sprite_texture_start + (i * 2) );
        FS_gfx::Image_name s1 = static_cast<FS_gfx::Image_name>
                ( sprite_texture_start + (i * 2) + 1 );
        int sy = sprite_y_start + (i * sprite_y_gap);
        int ty = sy + tick_y_offset;
        
        //std::cout << "s0=" << s0 << "; s1=" << s1 << "; sy=" << sy << "; ty=" << ty << "\n";
        Option o = { s0, s1, sy, ty };
        my_options.push_back(o);
    } // for

} // FS::Settings_screen::Settings_screen


// ******************
// *** DESTRUCTOR ***
// ******************
FS::Settings_screen::~Settings_screen()
{
    // nothing
            
} // FS::Settings_screen::~Settings_screen




// ************************
// *** MEMBER FUNCTIONS ***
// ************************

// **************************************************

void FS::Settings_screen::draw()
{
    // First draw the background. 
    gfx_ptr->draw_background( FS_gfx::SETTINGS_BG );

    // Iterate over all the options; draw ticks in right place and make sure current
    // option is in bold.
    // Need to know index of item in vector - this is why can't use for_each.
    for ( int i = 0; i < num_options; ++i )
    {
        draw_option(i);
    } // for 
     
    SDL_GL_SwapBuffers();

} // FS::Settings_screen::draw

// **************************************************

void FS::Settings_screen::reset()
{
    current_option = control;

    my_options[control].value = settings_ptr->is_joystick_selected();
    my_options[control].available = settings_ptr->is_joystick_available();
    my_options[sound].value = settings_ptr->is_sound();
    my_options[sound].available = settings_ptr->is_sound_available();

} // FS::Settings_screen::reset

// **************************************************

void FS::Settings_screen::draw_option(int i)
{
    // use this variable in following operations
    float alpha;   

    // lhs
    if ( i == current_option && my_options[i].available )
    {
        alpha = bold;
    }
    else
    {
        alpha = faded;
    } // if ... else

    //gfx_ptr->draw_texture_faded( my_options[i].sprite0, sprite0_x, my_options[i].sprite_y, alpha );
    gfx_ptr->draw_texture( my_options[i].sprite0, sprite0_x, my_options[i].sprite_y, 
            false, 0.0, true, alpha );

    if ( !my_options[i].available )
    {
        if ( i == current_option )
        {
            alpha = bold;
        }
        else
        {
            alpha = faded;
        } // if ... else

        gfx_ptr->draw_text_faded( FS_gfx::SMALL_FONT, sprite0_x, my_options[i].sprite_y, 
                "Unavailable", alpha );
    } // if

    // rhs
    if ( i == current_option )
    {
        alpha = bold;
    }
    else
    {
        alpha = faded;
    } // if ... else

    //gfx_ptr->draw_texture_faded( my_options[i].sprite1, sprite1_x, my_options[i].sprite_y, alpha );
    gfx_ptr->draw_texture( my_options[i].sprite1, sprite1_x, my_options[i].sprite_y, 
            false, 0.0, true, alpha );

    // tick
    int tick_x = ( (my_options[i].value) ? tick0_x : tick1_x );
    // use fade from previous operation (rhs)
    //gfx_ptr->draw_texture_faded( FS_gfx::TICK, tick_x, my_options[i].tick_y, alpha );
    gfx_ptr->draw_texture( FS_gfx::TICK, tick_x, my_options[i].tick_y, 
            false, 0.0, true, alpha );

} // FS::Settings_screen::draw_option

// **************************************************

bool FS::Settings_screen::update()
{
    // FIXME: make sure event list is empty if returning true.
    
    bool changed = false;
    bool quit = false;  // return this value
    
    User_input::Keyboard_Event ke;
    while ( input_ptr->next_event(ke) )
    {
        if ( ke == User_input::ESCAPE_PRESSED )  
        {
            // save settings!
            save();
            quit = true;
            break;  // 'short-circuit'
        }
        else if ( ke == User_input::UP_KEY_PRESSED )
        {
            --current_option;
            if (current_option < 0) 
            {
                current_option = num_options - 1;
            } // if
            changed = true;
        }
        else if ( ke == User_input::DOWN_KEY_PRESSED )
        {
            ++current_option;
            current_option %= num_options;
            changed = true;
        }
        else if ( ke == User_input::JUMP_KEY_PRESSED )
        {
            my_options[current_option].swap_value();
            changed = true;
        } // if ... else
    } // while
    
    if (changed)
    {
        draw();
    } // if
    
    return quit;
    
} // FS::Settings_screen::update

// **************************************************

void FS::Settings_screen::save()
{
    settings_ptr->set_joystick_selected( my_options[control].value );
    settings_ptr->set_sound( my_options[sound].value );

} // FS::Settings_screen::save

// **************************************************

