# Alert

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**communication_period** | Option<[**Vec<models::TimeRange>**](TimeRange.md)> | Time when the alert should be shown to the user. If missing, the alert will be shown as long as it appears in the feed. If multiple ranges are given, the alert will be shown during all of them.  | [optional]
**impact_period** | Option<[**Vec<models::TimeRange>**](TimeRange.md)> | Time when the services are affected by the disruption mentioned in the alert. | [optional]
**cause** | Option<[**models::AlertCause**](AlertCause.md)> |  | [optional]
**cause_detail** | Option<**String**> | Description of the cause of the alert that allows for agency-specific language; more specific than the Cause.  | [optional]
**effect** | Option<[**models::AlertEffect**](AlertEffect.md)> |  | [optional]
**effect_detail** | Option<**String**> | Description of the effect of the alert that allows for agency-specific language; more specific than the Effect.  | [optional]
**url** | Option<**String**> | The URL which provides additional information about the alert. | [optional]
**header_text** | **String** | Header for the alert. This plain-text string will be highlighted, for example in boldface.  | 
**description_text** | **String** | Description for the alert. This plain-text string will be formatted as the body of the alert (or shown on an explicit \"expand\" request by the user). The information in the description should add to the information of the header.  | 
**tts_header_text** | Option<**String**> | Text containing the alert's header to be used for text-to-speech implementations. This field is the text-to-speech version of header_text. It should contain the same information as headerText but formatted such that it can read as text-to-speech (for example, abbreviations removed, numbers spelled out, etc.)  | [optional]
**tts_description_text** | Option<**String**> | Text containing a description for the alert to be used for text-to-speech implementations. This field is the text-to-speech version of description_text. It should contain the same information as description_text but formatted such that it can be read as text-to-speech (for example, abbreviations removed, numbers spelled out, etc.)  | [optional]
**severity_level** | Option<[**models::AlertSeverityLevel**](AlertSeverityLevel.md)> | Severity of the alert. | [optional]
**image_url** | Option<**String**> | String containing an URL linking to an image. | [optional]
**image_media_type** | Option<**String**> | IANA media type as to specify the type of image to be displayed. The type must start with \"image/\"  | [optional]
**image_alternative_text** | Option<**String**> | Text describing the appearance of the linked image in the image field (e.g., in case the image can't be displayed or the user can't see the image for accessibility reasons). See the HTML spec for alt image text.  | [optional]

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


