/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;

public abstract class BuildInfoExtractorUtils {
    public static final Predicate<Object> BUILD_INFO_PREDICATE = new PrefixPredicate("buildInfo.");
    public static final Predicate<Object> BUILD_INFO_PROP_PREDICATE = new PrefixPredicate("buildInfo.property.");
    public static final Predicate<Object> ENV_PREDICATE = new PrefixPredicate("buildInfo.env.");
    public static final Predicate<Object> CLIENT_PREDICATE = new PrefixPredicate("artifactory.");
    public static final Predicate<Object> MATRIX_PARAM_PREDICATE = new PrefixPredicate("artifactory.deploy.");

    public static Properties mergePropertiesWithSystemAndPropertyFile(Properties existingProps) {
        return BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile(existingProps, null);
    }

    public static Properties mergePropertiesWithSystemAndPropertyFile(Properties existingProps, Log log) {
        Properties props = new Properties();
        BuildInfoExtractorUtils.addPropsFromCommandSystemProp(existingProps, log);
        String propsFilePath = BuildInfoExtractorUtils.getAdditionalPropertiesFile(existingProps, log);
        if (StringUtils.isNotBlank(propsFilePath)) {
            File propertiesFile = new File(propsFilePath);
            FileInputStream inputStream = null;
            try {
                if (propertiesFile.exists()) {
                    inputStream = new FileInputStream(propertiesFile);
                    props.load(inputStream);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to load build info properties from file: " + propertiesFile.getAbsolutePath(), e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
        props.putAll((Map<?, ?>)existingProps);
        props.putAll((Map<?, ?>)System.getProperties());
        return props;
    }

    public static Map<String, ?> filterStringEntries(Map<String, ?> map) {
        return CommonUtils.filterMapValues(map, value -> value instanceof String);
    }

    public static Properties filterDynamicProperties(Properties source, Predicate<Object> filter) {
        Properties properties = new Properties();
        if (source != null) {
            properties.putAll(CommonUtils.filterMapKeys(source, filter));
        }
        return properties;
    }

    public static Properties stripPrefixFromProperties(Properties source, String prefix) {
        Properties props = new Properties();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            props.put(StringUtils.removeStart(key, prefix), entry.getValue());
        }
        return props;
    }

    public static Properties getEnvProperties(Properties startProps, Log log) {
        IncludeExcludePatterns patterns = new IncludeExcludePatterns(startProps.getProperty("buildInfoConfig.envVarsIncludePatterns"), startProps.getProperty("buildInfoConfig.envVarsExcludePatterns"));
        Properties props = new Properties();
        for (Map.Entry<Object, Object> startEntry : startProps.entrySet()) {
            if (!StringUtils.startsWith((String)startEntry.getKey(), "buildInfo.env.")) continue;
            props.put(startEntry.getKey(), startEntry.getValue());
        }
        Map<String, String> envMap = System.getenv();
        for (Map.Entry entry : envMap.entrySet()) {
            String varKey = (String)entry.getKey();
            if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
            props.put("buildInfo.env." + (String)varKey, entry.getValue());
        }
        HashMap<Object, Object> sysProps = new HashMap<Object, Object>(System.getProperties());
        Map<String, String> map = CommonUtils.entriesOnlyOnLeftMap(sysProps, System.getenv());
        for (Map.Entry entry : map.entrySet()) {
            String varKey = (String)entry.getKey();
            if (PatternMatcher.pathConflicts(varKey, patterns)) continue;
            props.put(varKey, entry.getValue());
        }
        String propsFilePath = BuildInfoExtractorUtils.getAdditionalPropertiesFile(startProps, log);
        if (StringUtils.isNotBlank(propsFilePath)) {
            File file = new File(propsFilePath);
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                Properties propertiesFromFile = new Properties();
                propertiesFromFile.load(inputStream);
                props.putAll((Map<?, ?>)BuildInfoExtractorUtils.filterDynamicProperties(propertiesFromFile, ENV_PREDICATE));
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Unable to load build info properties from file: " + file.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(inputStream);
        }
        return props;
    }

    private static JsonFactory createJsonFactory() {
        JsonFactory jsonFactory = new JsonFactory();
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.setAnnotationIntrospector(new JacksonAnnotationIntrospector());
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        jsonFactory.setCodec(mapper);
        return jsonFactory;
    }

    public static String buildInfoToJsonString(Build buildInfo) throws IOException {
        JsonFactory jsonFactory = BuildInfoExtractorUtils.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject(buildInfo);
        String result = writer.getBuffer().toString();
        return result;
    }

    public static Build jsonStringToBuildInfo(String json) throws IOException {
        JsonFactory jsonFactory = BuildInfoExtractorUtils.createJsonFactory();
        JsonParser parser = jsonFactory.createParser(new StringReader(json));
        return jsonFactory.getCodec().readValue(parser, Build.class);
    }

    public static <T extends Serializable> String buildInfoToJsonString(T buildComponent) throws IOException {
        JsonFactory jsonFactory = BuildInfoExtractorUtils.createJsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(writer);
        jsonGenerator.useDefaultPrettyPrinter();
        jsonGenerator.writeObject(buildComponent);
        String result = writer.getBuffer().toString();
        return result;
    }

    public static <T extends Serializable> T jsonStringToGeneric(String json, Class<T> clazz) throws IOException {
        JsonFactory jsonFactory = BuildInfoExtractorUtils.createJsonFactory();
        JsonParser parser = jsonFactory.createParser(new StringReader(json));
        return (T)((Serializable)jsonFactory.getCodec().readValue(parser, clazz));
    }

    public static void saveBuildInfoToFile(Build build, File toFile) throws IOException {
        String buildInfoJson = BuildInfoExtractorUtils.buildInfoToJsonString(build);
        if (!toFile.getParentFile().exists()) {
            toFile.getParentFile().mkdirs();
        }
        if (!toFile.exists()) {
            toFile.createNewFile();
        }
        CommonUtils.writeByCharset(buildInfoJson, toFile, StandardCharsets.UTF_8);
    }

    private static String getAdditionalPropertiesFile(Properties additionalProps, Log log) {
        String key = "buildInfoConfig.propertiesFile";
        String filePath = System.getProperty(key);
        String propFoundPath = "System.getProperty(" + key + ")";
        if (StringUtils.isBlank(filePath) && additionalProps != null) {
            filePath = additionalProps.getProperty(key);
            propFoundPath = "additionalProps.getProperty(" + key + ")";
        }
        if (StringUtils.isBlank(filePath)) {
            filePath = additionalProps.getProperty("env." + key);
            if (StringUtils.isBlank(filePath)) {
                filePath = System.getenv(key);
                propFoundPath = "System.getenv(" + key + ")";
            } else {
                propFoundPath = "additionalProps.getProperty(env." + key + ")";
            }
        }
        if (StringUtils.isBlank(filePath)) {
            key = "BUILDINFO_PROPFILE";
            filePath = additionalProps.getProperty("env." + key);
            if (StringUtils.isBlank(filePath)) {
                filePath = System.getenv(key);
                propFoundPath = "System.getenv(" + key + ")";
            } else {
                propFoundPath = "additionalProps.getProperty(env." + key + ")";
            }
        }
        if (log != null) {
            if (StringUtils.isBlank(filePath)) {
                log.debug("[buildinfo] Not using buildInfo properties file for this build.");
            } else {
                log.debug("[buildinfo] Properties file '" + filePath + "' retrieved from '" + propFoundPath + "'");
            }
        }
        return filePath;
    }

    public static String getArtifactId(String moduleId, String artifactName) {
        return moduleId + ":" + artifactName;
    }

    public static String getTypeString(String type, String classifier, String extension) {
        String result = type;
        if ("jar".equals(type) && StringUtils.isNotBlank(classifier)) {
            result = classifier;
        }
        if (!("jar".equals(result) || "pom".equals(type) || "ivy".equals(type) || !StringUtils.isNotBlank(extension) || result.endsWith(extension))) {
            result = result + "-" + extension;
        }
        return result;
    }

    public static String getModuleIdString(String organisation, String name, String version) {
        return organisation + ':' + name + ':' + version;
    }

    private static void addPropsFromCommandSystemProp(Properties additionalProps, Log log) {
        String commandKey = "sun.java.command";
        String[] keys = new String[]{"buildInfoConfig.propertiesFile", "artifactory.publish.password"};
        String command = System.getProperty(commandKey);
        if (StringUtils.isNotBlank(command)) {
            String[] commandParts;
            for (String commandPart : commandParts = StringUtils.split(command, " ")) {
                for (String key : keys) {
                    if (!commandPart.startsWith("-D" + key)) continue;
                    additionalProps.put(key, StringUtils.split(commandPart, "=")[1].trim());
                    log.debug(String.format("Adding property %s from the command property: %s", key, commandKey));
                }
            }
        }
    }

    private static class PrefixPredicate
    implements Predicate<Object> {
        private String prefix;

        protected PrefixPredicate(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean test(Object o) {
            return o != null && ((String)o).startsWith(this.prefix);
        }
    }
}

