/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clipsrules.jni.examples.ide;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sf.clipsrules.jni.examples.ide.CLIPSIDE;
import net.sf.clipsrules.jni.examples.ide.DialogFrame;
import net.sf.clipsrules.jni.examples.ide.TextFrame;

public class FileMenu
extends JMenu
implements MenuListener {
    private CLIPSIDE ide;
    private PrinterJob job;
    private PageFormat format;
    private NewAction newAction;
    private OpenAction openAction;
    private CloseAction closeAction;
    private SaveAction saveAction;
    private SaveAsAction saveAsAction;
    private PageSetupAction pageSetupAction;
    private PrintAction printAction;
    private QuitAction quitAction;
    private JMenuItem jmiNew;
    private JMenuItem jmiOpen;
    private JMenuItem jmiClose;
    private JMenuItem jmiSave;
    private JMenuItem jmiSaveAs;
    private JMenuItem jmiPageSetup;
    private JMenuItem jmiPrint;
    private JMenuItem jmiQuitIDE;

    FileMenu(CLIPSIDE cLIPSIDE) {
        super("File");
        this.ide = cLIPSIDE;
        this.addMenuListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(78, 128);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(79, 128);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(87, 128);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(83, 128);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(83, 192);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(81, 128);
        this.newAction = new NewAction("New");
        this.openAction = new OpenAction("Open...");
        this.closeAction = new CloseAction("Close");
        this.saveAction = new SaveAction("Save");
        this.saveAsAction = new SaveAsAction("Save As...");
        this.pageSetupAction = new PageSetupAction("Page Setup...");
        this.printAction = new PrintAction("Print...");
        this.quitAction = new QuitAction("Quit CLIPS IDE");
        this.jmiNew = new JMenuItem(this.newAction);
        this.jmiNew.setAccelerator(keyStroke);
        this.add(this.jmiNew);
        this.jmiOpen = new JMenuItem(this.openAction);
        this.jmiOpen.setAccelerator(keyStroke2);
        this.add(this.jmiOpen);
        this.addSeparator();
        this.jmiClose = new JMenuItem(this.closeAction);
        this.jmiClose.setAccelerator(keyStroke3);
        this.add(this.jmiClose);
        this.jmiSave = new JMenuItem(this.saveAction);
        this.jmiSave.setAccelerator(keyStroke4);
        this.add(this.jmiSave);
        this.jmiSaveAs = new JMenuItem(this.saveAsAction);
        this.jmiSaveAs.setAccelerator(keyStroke5);
        this.add(this.jmiSaveAs);
        this.addSeparator();
        this.jmiPageSetup = new JMenuItem(this.pageSetupAction);
        this.add(this.jmiPageSetup);
        this.jmiPrint = new JMenuItem(this.printAction);
        this.add(this.jmiPrint);
        this.addSeparator();
        this.jmiQuitIDE = new JMenuItem(this.quitAction);
        this.jmiQuitIDE.setAccelerator(keyStroke6);
        this.add(this.jmiQuitIDE);
    }

    public void newTextFile(File file) {
        Font font = this.ide.getPreferences().getEditorFont();
        TextFrame textFrame = new TextFrame(this.ide, file, font);
        textFrame.addInternalFrameListener(this.ide);
        this.ide.getPlacer().placeInternalFrame(textFrame);
        this.ide.getDesktopPane().add(textFrame);
        textFrame.setVisible(true);
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(true);
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        JInternalFrame jInternalFrame = this.ide.getDesktopPane().getSelectedFrame();
        if (jInternalFrame == null || jInternalFrame.isIcon()) {
            this.jmiClose.setEnabled(false);
            this.jmiSave.setEnabled(false);
            this.jmiSaveAs.setEnabled(false);
            return;
        }
        if (jInternalFrame instanceof DialogFrame) {
            this.jmiClose.setEnabled(false);
            this.jmiSave.setEnabled(false);
            this.jmiSaveAs.setEnabled(false);
        } else if (jInternalFrame instanceof TextFrame) {
            TextFrame textFrame = (TextFrame)jInternalFrame;
            this.jmiClose.setEnabled(true);
            this.jmiSaveAs.setEnabled(true);
            if (textFrame.canSave()) {
                this.jmiSave.setEnabled(true);
            } else {
                this.jmiSave.setEnabled(false);
            }
        } else {
            this.jmiClose.setEnabled(true);
            this.jmiSave.setEnabled(false);
            this.jmiSaveAs.setEnabled(false);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            JMenuItem jMenuItem = this.getItem(i);
            if (jMenuItem == null) continue;
            jMenuItem.setEnabled(true);
        }
    }

    class QuitAction
    extends AbstractAction {
        public QuitAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WindowEvent windowEvent = new WindowEvent(FileMenu.this.ide, 201);
            FileMenu.this.ide.dispatchEvent(windowEvent);
        }
    }

    class PrintAction
    extends AbstractAction {
        public PrintAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileMenu.this.job = PrinterJob.getPrinterJob();
            if (FileMenu.this.job.printDialog()) {
                try {
                    FileMenu.this.job.print();
                }
                catch (PrinterException printerException) {
                    printerException.printStackTrace();
                }
            }
        }
    }

    class PageSetupAction
    extends AbstractAction {
        public PageSetupAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileMenu.this.job = PrinterJob.getPrinterJob();
            FileMenu.this.format = FileMenu.this.job.pageDialog(FileMenu.this.job.defaultPage());
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = FileMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame instanceof TextFrame) {
                TextFrame textFrame = (TextFrame)jInternalFrame;
                textFrame.saveAsTextFrame(FileMenu.this.ide.getPreferences());
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = FileMenu.this.ide.getDesktopPane().getSelectedFrame();
            if (jInternalFrame instanceof TextFrame) {
                TextFrame textFrame = (TextFrame)jInternalFrame;
                textFrame.saveTextFrame(FileMenu.this.ide.getPreferences());
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = FileMenu.this.ide.getDesktopPane().getSelectedFrame();
            jInternalFrame.doDefaultCloseAction();
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JFileChooser jFileChooser = new JFileChooser();
            File file = FileMenu.this.ide.getPreferences().getCurrentDirectory();
            if (file != null) {
                jFileChooser.setCurrentDirectory(file);
            }
            if ((n = jFileChooser.showOpenDialog(FileMenu.this.ide)) != 0) {
                return;
            }
            File file2 = jFileChooser.getSelectedFile();
            if (file2 == null) {
                return;
            }
            file = jFileChooser.getCurrentDirectory();
            FileMenu.this.ide.getPreferences().setCurrentDirectory(file);
            if (FileMenu.this.ide.getDialogWindow().setDirectory(file)) {
                FileMenu.this.ide.getPreferences().saveCurrentDirectory(file);
            }
            FileMenu.this.newTextFile(file2);
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileMenu.this.newTextFile(null);
        }
    }
}

