/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.k2;

import androidx.compose.compiler.plugins.kotlin.k2.ComposableFunctionCheckerKt;
import androidx.compose.compiler.plugins.kotlin.k2.ComposeErrors;
import androidx.compose.compiler.plugins.kotlin.k2.FirUtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Landroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "kotlin-compose-compiler-plugin"})
@SourceDebugExtension(value={"SMAP\nComposableFunctionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableFunctionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n53#2:105\n13#2:106\n38#2:110\n1761#3,3:107\n*S KotlinDebug\n*F\n+ 1 ComposableFunctionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/k2/ComposableFunctionChecker\n*L\n73#1:105\n78#1:106\n94#1:110\n79#1:107,3\n*E\n"})
public final class ComposableFunctionChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final ComposableFunctionChecker INSTANCE = new ComposableFunctionChecker();

    private ComposableFunctionChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        boolean isComposable = FirUtilsKt.hasComposableAnnotation((FirAnnotationContainer)declaration, context.getSession());
        List<FirFunctionSymbol<?>> overrides = FirUtilsKt.getDirectOverriddenFunctions(declaration, context);
        for (FirFunctionSymbol<?> override : overrides) {
            if (FirUtilsKt.isComposable((FirCallableSymbol)override, context.getSession()) == isComposable) continue;
            FirFunctionSymbol[] firFunctionSymbolArray = new FirFunctionSymbol[]{declaration.getSymbol(), override};
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory1)FirErrors.INSTANCE.getCONFLICTING_OVERLOADS(), (Object)CollectionsKt.listOf((Object[])firFunctionSymbolArray), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
        }
        FirFunctionSymbol firFunctionSymbol = ExpectActualAttributesKt.getSingleMatchedExpectForActualOrNull((FirFunctionSymbol)declaration.getSymbol());
        if (firFunctionSymbol != null) {
            FirFunctionSymbol expectDeclaration = firFunctionSymbol;
            boolean bl = false;
            if (FirUtilsKt.hasComposableAnnotation((FirBasedSymbol)expectDeclaration, context.getSession()) != isComposable) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getMISMATCHED_COMPOSABLE_IN_EXPECT_ACTUAL(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
        if (!isComposable) {
            return;
        }
        FirMemberDeclaration $this$isSuspend$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getCOMPOSABLE_SUSPEND_FUN(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
        FirMemberDeclaration $this$isOpen$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isOpen = false;
        if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) {
            boolean bl;
            block16: {
                Iterable $this$any$iv = overrides;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        FirFunctionSymbol it;
                        block15: {
                            it = (FirFunctionSymbol)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = it.getValueParameterSymbols();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    FirValueParameterSymbol it2 = (FirValueParameterSymbol)element$iv2;
                                    boolean bl4 = false;
                                    if (!it2.getHasDefaultValue()) continue;
                                    bl2 = true;
                                    break block15;
                                }
                                bl2 = false;
                            }
                        }
                        if (!(bl2 && ComposableFunctionCheckerKt.access$isMissingCompatMetadata(it))) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getDEPRECATED_OPEN_COMPOSABLE_DEFAULT_PARAMETER_VALUE(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
        }
        if (FirUtilsKt.isMain(declaration.getSymbol(), context.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getCOMPOSABLE_FUN_MAIN(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
        FirMemberDeclaration $this$isOperator$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator() && Intrinsics.areEqual((Object)FirDeclarationUtilKt.getNameOrSpecialName((FirMemberDeclaration)((FirMemberDeclaration)declaration)), (Object)OperatorNameConventions.SET_VALUE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)declaration.getSource()), (KtDiagnosticFactory0)ComposeErrors.INSTANCE.getCOMPOSE_INVALID_DELEGATE(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }
}

