/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import jrm.compressors.Archive;
import jrm.compressors.SevenZipArchive;
import jrm.profile.data.Container;
import jrm.profile.data.Entry;
import jrm.profile.fix.actions.EntryAction;
import jrm.ui.progress.ProgressHandler;

public class BackupEntry
extends EntryAction {
    public BackupEntry(Entry entry) {
        super(entry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doAction(FileSystem dstfs, ProgressHandler handler, int i, int max) {
        Path dstpath_crc = dstfs.getPath(this.entry.crc + '_' + this.entry.size, new String[0]);
        Path dstpath = dstfs.getPath(this.entry.sha1 != null ? this.entry.sha1 : (this.entry.md5 != null ? this.entry.md5 : this.entry.crc + '_' + this.entry.size), new String[0]);
        handler.setProgress(null, null, null, this.progress(i, max, String.format("Backup of %s", this.entry.getName())));
        Path srcpath = null;
        try {
            if (dstpath.getParent() != null) {
                Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
            }
            if (!dstpath.equals(dstpath_crc) && Files.exists(dstpath_crc, new LinkOption[0])) {
                Files.delete(dstpath_crc);
            }
            if (Files.exists(dstpath, new LinkOption[0])) {
                return true;
            }
            if (this.entry.parent.getType() == Container.Type.DIR) {
                srcpath = this.entry.parent.file.toPath().resolve(this.entry.file);
                Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            if (this.entry.parent.getType() == Container.Type.ZIP) {
                try (FileSystem srcfs = FileSystems.newFileSystem(this.entry.parent.file.toPath(), null);){
                    srcpath = srcfs.getPath(this.entry.file, new String[0]);
                    Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    boolean bl = true;
                    return bl;
                }
            }
            if (this.entry.parent.getType() != Container.Type.SEVENZIP) return false;
            try (SevenZipArchive srcarchive = new SevenZipArchive(this.entry.parent.file);){
                if (srcarchive.extract(this.entry.file) == null) return false;
                srcpath = new File(srcarchive.getTempDir(), this.entry.file).toPath();
                Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("add from " + this.entry.parent.file + "@" + srcpath + " to " + this.parent.container.file.getName() + "@" + dstpath + " failed");
        }
        return false;
    }

    @Override
    public boolean doAction(Archive archive, ProgressHandler handler, int i, int max) {
        return false;
    }

    @Override
    public boolean doAction(Path target, ProgressHandler handler, int i, int max) {
        return false;
    }

    public String toString() {
        return String.format("Backup of %s", this.entry);
    }
}

