/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * highscores.h contains the declarations to handle the high scores list.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/

#ifndef HIGHSCORES_H
#define HIGHSCORES_H

#include "SDL.h"
#include "SDL_gfxPrimitives.h"
#include "SDL_image.h"
#include <iostream>
#include <cstdlib>
#include <fstream>
#include <string>
#include <vector>
using namespace std;

#include "screen.h"
#include "button.h"
#include "BFont.h"
#include "miscellaneous.h"

// how many scores should be on the high scores list
#define NUMBER_OF_SCORES 10

// maximum length of names
#define NAME_MAX_LENGTH 20

// Spacing between names on the list.
#define LINE_SPACING 20

// Maximum characters in a name.
#define MAX_CHARACTERS 30

// The width-limit for a name (in pixels).
#define MAX_STR_WIDTH 115

/* Scores should be read-only; scores should be created from scratch rather
 * than modified. This is why no member functions are provided to modify _name
 * or _score. */
class highscore
{
public:
  highscore(string name,int score);
  string name() const;
  int score() const;
private:
  string _name;
  int _score;
};

// Stores all of the high scores.
extern vector<highscore> high_scores;

// Initialize high_scores.
void loadHighScores();

// Bring up the scores on the screen.
void displayHighScores(bool fadingOn);

// Puts the user's keyboard input into str.
void typestr(SDL_Event event,string & str,int & cursor,BFont_Info* font);

#endif
