package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryEdgeInstanceDeviceByDriver invokes the iot.QueryEdgeInstanceDeviceByDriver API synchronously
func (client *Client) QueryEdgeInstanceDeviceByDriver(request *QueryEdgeInstanceDeviceByDriverRequest) (response *QueryEdgeInstanceDeviceByDriverResponse, err error) {
	response = CreateQueryEdgeInstanceDeviceByDriverResponse()
	err = client.DoAction(request, response)
	return
}

// QueryEdgeInstanceDeviceByDriverWithChan invokes the iot.QueryEdgeInstanceDeviceByDriver API asynchronously
func (client *Client) QueryEdgeInstanceDeviceByDriverWithChan(request *QueryEdgeInstanceDeviceByDriverRequest) (<-chan *QueryEdgeInstanceDeviceByDriverResponse, <-chan error) {
	responseChan := make(chan *QueryEdgeInstanceDeviceByDriverResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryEdgeInstanceDeviceByDriver(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryEdgeInstanceDeviceByDriverWithCallback invokes the iot.QueryEdgeInstanceDeviceByDriver API asynchronously
func (client *Client) QueryEdgeInstanceDeviceByDriverWithCallback(request *QueryEdgeInstanceDeviceByDriverRequest, callback func(response *QueryEdgeInstanceDeviceByDriverResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryEdgeInstanceDeviceByDriverResponse
		var err error
		defer close(result)
		response, err = client.QueryEdgeInstanceDeviceByDriver(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryEdgeInstanceDeviceByDriverRequest is the request struct for api QueryEdgeInstanceDeviceByDriver
type QueryEdgeInstanceDeviceByDriverRequest struct {
	*requests.RpcRequest
	DriverId      string           `position:"Query" name:"DriverId"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage   requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId    string           `position:"Query" name:"InstanceId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	ChannelId     string           `position:"Query" name:"ChannelId"`
}

// QueryEdgeInstanceDeviceByDriverResponse is the response struct for api QueryEdgeInstanceDeviceByDriver
type QueryEdgeInstanceDeviceByDriverResponse struct {
	*responses.BaseResponse
	RequestId    string                                `json:"RequestId" xml:"RequestId"`
	Success      bool                                  `json:"Success" xml:"Success"`
	Code         string                                `json:"Code" xml:"Code"`
	ErrorMessage string                                `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQueryEdgeInstanceDeviceByDriver `json:"Data" xml:"Data"`
}

// CreateQueryEdgeInstanceDeviceByDriverRequest creates a request to invoke QueryEdgeInstanceDeviceByDriver API
func CreateQueryEdgeInstanceDeviceByDriverRequest() (request *QueryEdgeInstanceDeviceByDriverRequest) {
	request = &QueryEdgeInstanceDeviceByDriverRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QueryEdgeInstanceDeviceByDriver", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryEdgeInstanceDeviceByDriverResponse creates a response to parse from QueryEdgeInstanceDeviceByDriver response
func CreateQueryEdgeInstanceDeviceByDriverResponse() (response *QueryEdgeInstanceDeviceByDriverResponse) {
	response = &QueryEdgeInstanceDeviceByDriverResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
