package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFolder invokes the resourcemanager.GetFolder API synchronously
func (client *Client) GetFolder(request *GetFolderRequest) (response *GetFolderResponse, err error) {
	response = CreateGetFolderResponse()
	err = client.DoAction(request, response)
	return
}

// GetFolderWithChan invokes the resourcemanager.GetFolder API asynchronously
func (client *Client) GetFolderWithChan(request *GetFolderRequest) (<-chan *GetFolderResponse, <-chan error) {
	responseChan := make(chan *GetFolderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFolder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFolderWithCallback invokes the resourcemanager.GetFolder API asynchronously
func (client *Client) GetFolderWithCallback(request *GetFolderRequest, callback func(response *GetFolderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFolderResponse
		var err error
		defer close(result)
		response, err = client.GetFolder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFolderRequest is the request struct for api GetFolder
type GetFolderRequest struct {
	*requests.RpcRequest
	FolderId string `position:"Query" name:"FolderId"`
}

// GetFolderResponse is the response struct for api GetFolder
type GetFolderResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Folder    Folder `json:"Folder" xml:"Folder"`
}

// CreateGetFolderRequest creates a request to invoke GetFolder API
func CreateGetFolderRequest() (request *GetFolderRequest) {
	request = &GetFolderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "GetFolder", "", "")
	request.Method = requests.POST
	return
}

// CreateGetFolderResponse creates a response to parse from GetFolder response
func CreateGetFolderResponse() (response *GetFolderResponse) {
	response = &GetFolderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
