/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.h2.backup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Statement;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.InternalDatabaseConfig;
import org.jkiss.dbeaver.model.sql.backup.JDBCDatabaseBackupHandler;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public class JDBCDatabaseH2BackupHandler
implements JDBCDatabaseBackupHandler {
    private static final Log log = Log.getLog(JDBCDatabaseH2BackupHandler.class);

    public void doBackup(@NotNull Connection connection, int currentSchemaVersion, @NotNull InternalDatabaseConfig databaseConfig) throws DBException, IOException {
        Path workspace = DBWorkbench.getPlatform().getWorkspace().getAbsolutePath().resolve("backup");
        Path backupFile = workspace.resolve("backup_version_" + currentSchemaVersion + ".zip");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Statement statement = connection.createStatement();){
                if (Files.notExists(backupFile, new LinkOption[0])) {
                    Files.createDirectories(workspace, new FileAttribute[0]);
                    String backupCommand = "BACKUP TO '" + String.valueOf(backupFile) + "'";
                    statement.execute(backupCommand);
                    log.info((Object)("Reserve backup created to path: " + String.valueOf(workspace) + "backup"));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Files.deleteIfExists(backupFile);
            log.error((Object)("Create backup is failed: " + e.getMessage()));
            throw new DBException("Backup is failed: " + e.getMessage());
        }
    }
}

