/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreUIUtils;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreBackupAllSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreBackupAllWizard;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolWizardPageSettings;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreBackupAllWizardPageSettings
extends PostgreToolWizardPageSettings<PostgreBackupAllWizard> {
    private Combo encodingCombo;
    private Button metadataOnly;
    private Button globalsOnly;
    private Button rolesOnly;
    private Button tablespacesOnly;
    private Button noPrivilegesCheck;
    private Button noOwnerCheck;
    private Button addRolesPasswords;

    public PostgreBackupAllWizardPageSettings(PostgreBackupAllWizard wizard) {
        super(wizard, PostgreMessages.wizard_backup_all_page_setting_title_setting);
        this.setTitle(PostgreMessages.wizard_backup_all_page_setting_title);
        this.setDescription(PostgreMessages.wizard_backup_all_page_setting_title);
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SelectionListener changeListener = SelectionListener.widgetSelectedAdapter(e -> this.updateState());
        Group formatGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_all_page_setting_title_setting, (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_label_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)formatGroup, null);
        this.encodingCombo.addSelectionListener(changeListener);
        PostgreBackupAllSettings settings = (PostgreBackupAllSettings)((PostgreBackupAllWizard)this.wizard).getSettings();
        this.encodingCombo.setText(settings.getEncoding());
        this.metadataOnly = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_metadata, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_metadata_tip, (boolean)settings.isExportOnlyMetadata(), (int)2);
        this.metadataOnly.addSelectionListener(changeListener);
        this.globalsOnly = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_global, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_global_tip, (boolean)settings.isExportOnlyGlobals(), (int)2);
        this.globalsOnly.addSelectionListener(changeListener);
        this.rolesOnly = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_roles, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_roles_tip, (boolean)settings.isExportOnlyRoles(), (int)2);
        this.rolesOnly.addSelectionListener(changeListener);
        this.tablespacesOnly = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_tablespaces, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_only_tablespaces_tip, (boolean)settings.isExportOnlyTablespaces(), (int)2);
        this.tablespacesOnly.addSelectionListener(changeListener);
        this.noPrivilegesCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_no_privileges, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_no_privileges_tip, (boolean)settings.isNoPrivileges(), (int)2);
        this.noPrivilegesCheck.addSelectionListener(changeListener);
        this.noOwnerCheck = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_no_owner, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_no_owner_tip, (boolean)settings.isNoOwner(), (int)2);
        this.noOwnerCheck.addSelectionListener(changeListener);
        this.addRolesPasswords = UIUtils.createCheckbox((Composite)formatGroup, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_add_passwords, (String)PostgreMessages.wizard_backup_all_page_setting_checkbox_add_passwords_tip, (boolean)settings.isAddRolesPasswords(), (int)2);
        this.addRolesPasswords.addSelectionListener(changeListener);
        Group outputGroup = UIUtils.createControlGroup((Composite)composite, (String)PostgreMessages.wizard_backup_page_setting_group_output, (int)2, (int)768, (int)0);
        this.createOutputFolderInput((Composite)outputGroup, (AbstractImportExportSettings)settings);
        this.createExtraArgsInput((Composite)outputGroup);
        Composite extraGroup = UIUtils.createComposite((Composite)composite, (int)2);
        this.createSecurityGroup(extraGroup);
        PostgreUIUtils.addCompatibilityInfoLabelForForks(composite, this.wizard, null);
        this.setControl((Control)composite);
    }

    protected void updateState() {
        this.saveState();
        this.updatePageCompletion();
        this.getContainer().updateButtons();
    }

    public void saveState() {
        super.saveState();
        PostgreBackupAllSettings settings = (PostgreBackupAllSettings)((PostgreBackupAllWizard)this.wizard).getSettings();
        String fileName = this.outputFolderText.getText();
        settings.setOutputFolderPattern(CommonUtils.isEmpty((String)fileName) ? null : fileName);
        settings.setOutputFilePattern(this.outputFileText.getText());
        settings.setEncoding(this.encodingCombo.getText());
        settings.setExportOnlyMetadata(this.metadataOnly.getSelection());
        settings.setExportOnlyGlobals(this.globalsOnly.getSelection());
        settings.setExportOnlyRoles(this.rolesOnly.getSelection());
        settings.setExportOnlyTablespaces(this.tablespacesOnly.getSelection());
        settings.setNoPrivileges(this.noPrivilegesCheck.getSelection());
        settings.setNoOwner(this.noOwnerCheck.getSelection());
        settings.setAddRolesPasswords(this.addRolesPasswords.getSelection());
    }
}

