/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.patch;

import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.patch.HunkDiffNode;
import org.eclipse.compare.internal.patch.PatchDiffNode;
import org.eclipse.compare.internal.patch.PatchFileTypedElement;
import org.eclipse.compare.internal.patch.WorkspaceFileDiffResult;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;

public class PatchFileDiffNode
extends PatchDiffNode
implements IContentChangeListener {
    private final FileDiffResult result;

    public static PatchFileDiffNode createDiffNode(DiffNode parent, FileDiffResult result) {
        return new PatchFileDiffNode(result, (IDiffContainer)parent, PatchFileDiffNode.getKind(result), PatchFileDiffNode.getAncestorElement(result), PatchFileDiffNode.getLeftElement(result), PatchFileDiffNode.getRightElement(result));
    }

    public static int getKind(FileDiffResult result) {
        if (!result.hasMatches()) {
            return 0;
        }
        int fileDiffKind = result.getDiff().getDiffType(result.getConfiguration().isReversed());
        int kind = PatchFileDiffNode.convertFileDiffTypeToDifferencerType(fileDiffKind);
        return kind | 8;
    }

    private static int convertFileDiffTypeToDifferencerType(int fileDiffKind) {
        return switch (fileDiffKind) {
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            default -> 3;
        };
    }

    public static ITypedElement getRightElement(FileDiffResult result) {
        return new PatchFileTypedElement(result, true);
    }

    private static ITypedElement getLeftElement(FileDiffResult result) {
        return new PatchFileTypedElement(result, false);
    }

    public static ITypedElement getAncestorElement(FileDiffResult result) {
        return new PatchFileTypedElement(result, false);
    }

    public PatchFileDiffNode(FileDiffResult result, IDiffContainer parent, int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        super(result.getDiff(), parent, kind, ancestor, left, right);
        this.result = result;
    }

    public FileDiffResult getDiffResult() {
        return this.result;
    }

    @Override
    protected PatchConfiguration getConfiguration() {
        return this.result.getConfiguration();
    }

    @Override
    public void add(IDiffElement diff) {
        HunkDiffNode node;
        ITypedElement left;
        super.add(diff);
        if (diff instanceof HunkDiffNode && (left = (node = (HunkDiffNode)diff).getLeft()) instanceof IContentChangeNotifier) {
            IContentChangeNotifier notifier = (IContentChangeNotifier)((Object)left);
            notifier.addContentChangeListener(this);
        }
    }

    @Override
    public void contentChanged(IContentChangeNotifier source) {
        this.fireChange();
    }

    @Override
    public int getKind() {
        int kind = super.getKind();
        if (kind == 0 && this.getPatcher().hasCachedContents(this.getDiffResult().getDiff())) {
            return 11;
        }
        return kind;
    }

    public boolean fileExists() {
        IResource file = this.getResource();
        return file != null && file.isAccessible();
    }

    @Override
    public IResource getResource() {
        return ((WorkspaceFileDiffResult)this.getDiffResult()).getTargetFile();
    }
}

