/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.Action;
import com.jgoodies.application.ActionManager;
import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.ActionAnnotationUtils;
import com.jgoodies.application.internal.ActionMethods;
import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import java.awt.event.ActionEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;

public class DefaultActionManager
implements ActionManager {
    private static final String INVOCATION_FAILED_FORMAT = "Invocation of an annotated method failed.\nClass=%1$s\nObject=%2$s\nMethod=%3$s%4$s";

    @Override
    public ActionMap createActionMap(Object target, ResourceMap resourceMap) {
        ApplicationActionMap map = new ApplicationActionMap(this, target, resourceMap);
        Map<String, ActionMethods.MethodOrException> methods = ActionMethods.getInstance().getMethods(target.getClass());
        if (methods == null) {
            throw new Exceptions.ListenerMethodNotFoundException(String.format("No public method annotated with @Action found.\nTarget class=%1$s", target.getClass().getName()));
        }
        methods.forEach((id, methodOrException) -> {
            methodOrException.throwIfException();
            Method method = methodOrException.getMethod();
            Action annotation = method.getAnnotation(Action.class);
            map.addAction(method, (String)id, annotation);
        });
        return map;
    }

    protected javax.swing.Action createAction(Object target, Method method, String actionId) {
        return new DefaultApplicationAction(target, method);
    }

    public static final class ApplicationActionMap
    extends ActionMap {
        private final DefaultActionManager actionManager;
        private final Object target;
        private final ResourceMap targetResourceMap;
        private final ResourceMap customResourceMap;

        ApplicationActionMap(DefaultActionManager actionManager, Object target, ResourceMap customResourceMap) {
            this.actionManager = actionManager;
            this.target = target;
            this.targetResourceMap = Application.getResourceMap(target.getClass());
            this.customResourceMap = customResourceMap;
        }

        void addAction(Method method, String actionId, Action annotation) {
            javax.swing.Action action = this.actionManager.createAction(this.target, method, actionId);
            if (ActionAnnotationUtils.providesResources(annotation)) {
                ActionAnnotationUtils.configureAction(action, actionId, annotation, this.target, method);
            } else {
                boolean hasCustomResourceMap;
                Class<?> targetClass = this.target.getClass();
                Class<?> declaringClass = method.getDeclaringClass();
                boolean bl = hasCustomResourceMap = this.customResourceMap != null;
                ResourceMap resourceMap = hasCustomResourceMap ? this.customResourceMap : (declaringClass == targetClass ? this.targetResourceMap : Application.getResourceMap(declaringClass));
                ActionAnnotationUtils.configureAction(action, actionId, annotation, this.target, method, resourceMap, hasCustomResourceMap);
            }
            super.put(actionId, action);
        }

        @Override
        public javax.swing.Action get(Object key) {
            javax.swing.Action result = super.get(key);
            if (result == null) {
                this.failNotFound(key);
            }
            return result;
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Clearing an ApplicationActionMap is prohibited.");
        }

        @Override
        public void put(Object key, javax.swing.Action action) {
            throw new UnsupportedOperationException("Putting actions to an ApplicationActionMap is prohibited.");
        }

        @Override
        public void remove(Object key) {
            throw new UnsupportedOperationException("Removing actions from an ApplicationActionMap is prohibited.");
        }

        private void failNotFound(Object key) {
            String message = String.format("\nTarget class =%1$s\nAction id    =\"%2$s\"\nAvailable ids=%3$s", this.target.getClass().getName(), key, this.availableActionIds());
            throw new Exceptions.ActionNotFoundException(message);
        }

        private String availableActionIds() {
            return Stream.of(this.keys()).map(Object::toString).collect(Collectors.joining(", "));
        }
    }

    public static class DefaultApplicationAction
    extends AbstractAction {
        private final Object target;
        private final Method method;

        protected DefaultApplicationAction(Object target, Method method) {
            this.target = target;
            this.method = method;
        }

        protected Object getTarget() {
            return this.target;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Preconditions.checkState(this.isEnabled(), "You must not perform disabled Actions.\nTarget class=%1$s\nMethod name =%2$s", this.getTarget().getClass().getName(), this.getMethod().getName());
            DefaultApplicationAction.invokeMethod(this.getTarget(), this.getMethod(), evt);
        }

        private static Object invokeMethod(Object target, Method method, ActionEvent evt) {
            try {
                Object[] objectArray;
                if (method.getParameterTypes().length == 0) {
                    objectArray = null;
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = evt;
                }
                Object[] arguments = objectArray;
                return method.invoke(target, arguments);
            }
            catch (IllegalArgumentException e1) {
                throw new RuntimeException(DefaultApplicationAction.methodInvocationFailureString(target, method), e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(DefaultApplicationAction.methodInvocationFailureString(target, method), e1);
            }
            catch (InvocationTargetException e1) {
                Throwable cause = e1.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(DefaultApplicationAction.methodInvocationFailureString(target, method), cause);
            }
        }

        private static String methodInvocationFailureString(Object target, Method method) {
            Annotation[] annotations;
            Class<?> targetClass = target != null ? target.getClass() : null;
            StringBuilder builder = new StringBuilder();
            for (Annotation annotation : annotations = method.getDeclaredAnnotations()) {
                builder.append('@');
                builder.append(annotation.annotationType().getSimpleName());
                builder.append(' ');
            }
            return String.format(DefaultActionManager.INVOCATION_FAILED_FORMAT, targetClass, target, builder.toString(), method);
        }
    }
}

