/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.IndirectListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.collect.ArrayListModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class SelectionInList<E>
extends IndirectListModel<E>
implements ValueModel {
    public static final String PROPERTY_SELECTION = "selection";
    public static final String PROPERTY_SELECTION_EMPTY = "selectionEmpty";
    public static final String PROPERTY_SELECTION_HOLDER = "selectionHolder";
    public static final String PROPERTY_SELECTION_INDEX = "selectionIndex";
    public static final String PROPERTY_SELECTION_INDEX_HOLDER = "selectionIndexHolder";
    private static final int NO_SELECTION_INDEX = -1;
    private ValueModel selectionHolder;
    private ValueModel selectionIndexHolder;
    private final PropertyChangeListener selectionChangeHandler;
    private final PropertyChangeListener selectionIndexChangeHandler;
    private E oldSelection;
    private int oldSelectionIndex;
    private boolean clearSelectionOnListUpdates = true;

    public SelectionInList() {
        this(new ArrayListModel());
    }

    public SelectionInList(E[] listItems) {
        this(Arrays.asList(listItems));
    }

    public SelectionInList(E[] listItems, ValueModel selectionHolder) {
        this(Arrays.asList(listItems), selectionHolder);
    }

    public SelectionInList(E[] listItems, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        this(Arrays.asList(listItems), selectionHolder, selectionIndexHolder);
    }

    public SelectionInList(List<E> list) {
        this(new ValueHolder(list, true));
    }

    public SelectionInList(List<E> list, ValueModel selectionHolder) {
        this(new ValueHolder(list, true), selectionHolder);
    }

    public SelectionInList(List<E> list, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        this(new ValueHolder(list, true), selectionHolder, selectionIndexHolder);
    }

    public SelectionInList(ListModel<E> listModel) {
        this(new ValueHolder(listModel, true));
    }

    public SelectionInList(ListModel<E> listModel, ValueModel selectionHolder) {
        this(new ValueHolder(listModel, true), selectionHolder);
    }

    public SelectionInList(ListModel<E> listModel, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        this(new ValueHolder(listModel, true), selectionHolder, selectionIndexHolder);
    }

    public SelectionInList(ValueModel listHolder) {
        this(listHolder, (ValueModel)new ValueHolder(null, true));
    }

    public SelectionInList(ValueModel listHolder, ValueModel selectionHolder) {
        this(listHolder, selectionHolder, (ValueModel)new ValueHolder((Object)-1));
    }

    public SelectionInList(ValueModel listHolder, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        super(listHolder);
        this.selectionHolder = Preconditions.checkNotNull(selectionHolder, "The %s must not be null.", "selection holder");
        this.selectionIndexHolder = Preconditions.checkNotNull(selectionIndexHolder, "The %s must not be null.", "selection index holder");
        this.selectionChangeHandler = this::onSelectionChanged;
        this.selectionIndexChangeHandler = this::onSelectionIndexChanged;
        this.initializeSelectionIndex();
        this.selectionHolder.addValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
    }

    public void setListWithoutClearingSelection(List<E> newList) {
        this.clearSelectionOnListUpdates = false;
        try {
            this.getListHolder().setValue(newList);
        }
        finally {
            this.clearSelectionOnListUpdates = true;
        }
    }

    public void fireSelectedContentsChanged() {
        if (this.hasSelection()) {
            int selectionIndex = this.getSelectionIndex();
            this.fireContentsChanged(selectionIndex, selectionIndex);
        }
    }

    public E getSelection() {
        return this.getSafeElementAt(this.getSelectionIndex());
    }

    public void setSelection(E newSelection) {
        if (!this.isEmpty()) {
            this.setSelectionIndex(this.indexOf(newSelection));
        }
    }

    public boolean hasSelection() {
        return this.getSelectionIndex() != -1;
    }

    public boolean isSelectionEmpty() {
        return !this.hasSelection();
    }

    public void clearSelection() {
        this.setSelectionIndex(-1);
    }

    public int getSelectionIndex() {
        return (Integer)this.getSelectionIndexHolder().getValue();
    }

    public void setSelectionIndex(int newSelectionIndex) {
        int upperBound = this.getSize() - 1;
        if (newSelectionIndex < -1 || newSelectionIndex > upperBound) {
            throw new IndexOutOfBoundsException("The selection index " + newSelectionIndex + " must be in [-1, " + upperBound + "]");
        }
        this.oldSelectionIndex = this.getSelectionIndex();
        if (this.oldSelectionIndex == newSelectionIndex) {
            return;
        }
        this.getSelectionIndexHolder().setValue((Object)newSelectionIndex);
    }

    public ValueModel getSelectionHolder() {
        return this.selectionHolder;
    }

    public void setSelectionHolder(ValueModel newSelectionHolder) {
        Preconditions.checkNotNull(newSelectionHolder, "The %s must not be null.", "new selection holder");
        ValueModel oldSelectionHolder = this.getSelectionHolder();
        oldSelectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionHolder = newSelectionHolder;
        this.oldSelection = newSelectionHolder.getValue();
        newSelectionHolder.addValueChangeListener(this.selectionChangeHandler);
        this.firePropertyChange(PROPERTY_SELECTION_HOLDER, oldSelectionHolder, newSelectionHolder);
    }

    public ValueModel getSelectionIndexHolder() {
        return this.selectionIndexHolder;
    }

    public void setSelectionIndexHolder(ValueModel newSelectionIndexHolder) {
        Preconditions.checkNotNull(newSelectionIndexHolder, "The %s must not be null.", "new selection index holder");
        Preconditions.checkNotNull(newSelectionIndexHolder.getValue(), "The %s must not be null.", "value of the new selection index holder");
        ValueModel oldSelectionIndexHolder = this.getSelectionIndexHolder();
        if (Objects.equals(oldSelectionIndexHolder, newSelectionIndexHolder)) {
            return;
        }
        oldSelectionIndexHolder.removeValueChangeListener(this.selectionIndexChangeHandler);
        this.selectionIndexHolder = newSelectionIndexHolder;
        newSelectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
        this.oldSelectionIndex = this.getSelectionIndex();
        this.oldSelection = this.getSafeElementAt(this.oldSelectionIndex);
        this.firePropertyChange(PROPERTY_SELECTION_INDEX_HOLDER, oldSelectionIndexHolder, newSelectionIndexHolder);
    }

    public E getValue() {
        return this.getSelection();
    }

    @Override
    public void setValue(Object newValue) {
        this.setSelection(newValue);
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener l) {
        this.addPropertyChangeListener("value", l);
    }

    @Override
    public void removeValueChangeListener(PropertyChangeListener l) {
        this.removePropertyChangeListener("value", l);
    }

    void fireValueChange(Object oldValue, Object newValue) {
        this.firePropertyChange("value", oldValue, newValue);
    }

    @Override
    public void release() {
        super.release();
        this.selectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.removeValueChangeListener(this.selectionIndexChangeHandler);
        this.selectionHolder = null;
        this.selectionIndexHolder = null;
        this.oldSelection = null;
    }

    private E getSafeElementAt(int index) {
        return index < 0 || index >= this.getSize() ? null : (E)this.getElementAt(index);
    }

    private int indexOf(Object element) {
        return SelectionInList.indexOf(this.getListHolder().getValue(), element);
    }

    private static int indexOf(Object aList, Object element) {
        if (element == null || SelectionInList.getSize(aList) == 0) {
            return -1;
        }
        if (aList instanceof List) {
            return ((List)aList).indexOf(element);
        }
        ListModel listModel = (ListModel)aList;
        int size = listModel.getSize();
        for (int index = 0; index < size; ++index) {
            if (!element.equals(listModel.getElementAt(index))) continue;
            return index;
        }
        return -1;
    }

    private void initializeSelectionIndex() {
        Object selectionValue = this.selectionHolder.getValue();
        if (selectionValue != null) {
            this.setSelectionIndex(this.indexOf(selectionValue));
        }
        this.oldSelection = selectionValue;
        this.oldSelectionIndex = this.getSelectionIndex();
    }

    @Override
    protected ListDataListener createListDataChangeHandler() {
        return new ListDataChangeHandler();
    }

    @Override
    protected void updateList(Object oldList, int oldSize, Object newList) {
        Object oldSelectionHolderValue;
        boolean hadSelection = this.hasSelection();
        Object object = oldSelectionHolderValue = hadSelection ? this.getSelectionHolder().getValue() : null;
        if (hadSelection && this.clearSelectionOnListUpdates) {
            this.clearSelection();
        }
        super.updateList(oldList, oldSize, newList);
        if (hadSelection) {
            this.setSelectionIndex(SelectionInList.indexOf(newList, oldSelectionHolderValue));
        }
    }

    private void onSelectionChanged(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newSelection = evt.getNewValue();
        int newSelectionIndex = this.indexOf(newSelection);
        if (newSelectionIndex != this.oldSelectionIndex) {
            this.selectionIndexHolder.removeValueChangeListener(this.selectionIndexChangeHandler);
            this.selectionIndexHolder.setValue((Object)newSelectionIndex);
            this.selectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
        }
        int theOldSelectionIndex = this.oldSelectionIndex;
        this.oldSelectionIndex = newSelectionIndex;
        this.oldSelection = newSelection;
        this.firePropertyChange(PROPERTY_SELECTION_INDEX, theOldSelectionIndex, newSelectionIndex);
        this.firePropertyChange(PROPERTY_SELECTION_EMPTY, theOldSelectionIndex == -1, newSelectionIndex == -1);
        this.firePropertyChange(PROPERTY_SELECTION, oldValue, newSelection);
        this.fireValueChange(oldValue, newSelection);
    }

    private void onSelectionIndexChanged(PropertyChangeEvent evt) {
        E theOldSelection = this.oldSelection;
        int newSelectionIndex = this.getSelectionIndex();
        E newSelection = this.getSafeElementAt(newSelectionIndex);
        if (!Objects.equals(theOldSelection, newSelection)) {
            this.selectionHolder.removeValueChangeListener(this.selectionChangeHandler);
            this.selectionHolder.setValue(newSelection);
            this.selectionHolder.addValueChangeListener(this.selectionChangeHandler);
        }
        int theOldSelectionIndex = this.oldSelectionIndex;
        this.oldSelectionIndex = newSelectionIndex;
        this.oldSelection = newSelection;
        this.firePropertyChange(PROPERTY_SELECTION_INDEX, theOldSelectionIndex, newSelectionIndex);
        this.firePropertyChange(PROPERTY_SELECTION_EMPTY, theOldSelectionIndex == -1, newSelectionIndex == -1);
        this.firePropertyChange(PROPERTY_SELECTION, theOldSelection, newSelection);
        this.fireValueChange(theOldSelection, newSelection);
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent evt) {
            int index0 = evt.getIndex0();
            int index1 = evt.getIndex1();
            int index = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalAdded(index0, index1);
            if (index >= index0) {
                SelectionInList.this.setSelectionIndex(index + index1 - index0 + 1);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent evt) {
            int index0 = evt.getIndex0();
            int index1 = evt.getIndex1();
            int index = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalRemoved(index0, index1);
            if (index >= index0) {
                if (index <= index1) {
                    SelectionInList.this.setSelectionIndex(-1);
                } else {
                    SelectionInList.this.setSelectionIndex(index - (index1 - index0 + 1));
                }
            }
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            SelectionInList.this.fireContentsChanged(evt.getIndex0(), evt.getIndex1());
            this.updateSelectionContentsChanged(evt.getIndex0(), evt.getIndex1());
        }

        private void updateSelectionContentsChanged(int first, int last) {
            if (first < 0) {
                return;
            }
            int selectionIndex = SelectionInList.this.getSelectionIndex();
            if (first <= selectionIndex && selectionIndex <= last) {
                SelectionInList.this.getSelectionHolder().setValue(SelectionInList.this.getElementAt(selectionIndex));
            }
        }
    }
}

