/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.util;

import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.common.bean.BeanUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class ChangeTracker
extends Bean {
    public static final String PROPERTY_CHANGED = "changed";
    private final PropertyChangeListener updateHandler = this::onModelChanged;
    private boolean changed = false;

    public boolean isChanged() {
        return this.changed;
    }

    public void reset() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTY_CHANGED, oldValue, newValue);
    }

    public void observe(Object bean, String propertyName) {
        Preconditions.checkNotNull(bean, "The %s must not be null.", "bean");
        Preconditions.checkNotNull(propertyName, "The %s must not be null.", "property name");
        BeanUtils.addPropertyChangeListener(bean, propertyName, this.updateHandler);
    }

    public void observe(ValueModel valueModel) {
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "ValueModel");
        valueModel.addValueChangeListener(this.updateHandler);
    }

    public void retractInterestFor(Object bean, String propertyName) {
        Preconditions.checkNotNull(bean, "The %s must not be null.", "bean");
        Preconditions.checkNotNull(propertyName, "The %s must not be null.", "property name");
        BeanUtils.removePropertyChangeListener(bean, propertyName, this.updateHandler);
    }

    public void retractInterestFor(ValueModel valueModel) {
        Preconditions.checkNotNull(valueModel, "The %s must not be null.", "ValueModel");
        valueModel.removeValueChangeListener(this.updateHandler);
    }

    private void onModelChanged(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (!PROPERTY_CHANGED.equals(propertyName) || ((Boolean)evt.getNewValue()).booleanValue()) {
            this.setChanged(true);
        }
    }
}

