/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.base.Preconditions;
import java.beans.PropertyChangeEvent;

public abstract class AbstractVetoableValueModel
extends AbstractValueModel {
    private final ValueModel subject;

    protected AbstractVetoableValueModel(ValueModel subject) {
        this.subject = Preconditions.checkNotNull(subject, "The %s must not be null.", "subject");
        subject.addValueChangeListener(this::onSubjectValueChanged);
    }

    public abstract boolean proposedChange(Object var1, Object var2);

    @Override
    public final Object getValue() {
        return this.subject.getValue();
    }

    @Override
    public final void setValue(Object newValue) {
        Object oldValue = this.getValue();
        if (oldValue == newValue) {
            return;
        }
        if (this.proposedChange(oldValue, newValue)) {
            this.subject.setValue(newValue);
        }
    }

    private void onSubjectValueChanged(PropertyChangeEvent evt) {
        this.fireValueChange(evt.getOldValue(), evt.getNewValue(), true);
    }
}

