/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.basics.misc;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.basics.BasicDialogResources;
import com.jgoodies.dialogs.core.AspectRatio;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.PreferredWidth;
import com.jgoodies.dialogs.core.pane.StyledPane;
import com.jgoodies.dialogs.core.pane.StyledPaneBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import java.awt.Dialog;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;

public class AboutPanes {
    private static AboutPanes current;
    private ResourceMap resources;

    private AboutPanes() {
        this(Application.getResourceMap(BasicDialogResources.class));
    }

    private AboutPanes(ResourceMap resources) {
        this.resources = resources;
    }

    public static AboutPanes getCurrent() {
        if (current == null) {
            current = new AboutPanes();
        }
        return current;
    }

    public static void setCurrent(AboutPanes newInstance) {
        current = newInstance;
    }

    public void showDialog(EventObject evt, String optionalTitle, Icon optionalApplicationIcon, String optionalApplicationName, String detailsText) {
        StyledPane pane = this.buildPane(optionalApplicationIcon, optionalApplicationName, detailsText);
        pane.showDialog(evt, this.getStringWithFallback(optionalTitle, "AboutPanes.defaultTitle"), Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public StyledPane buildPane(Icon optionalApplicationIcon, String optionalApplicationName, String detailsText) {
        String applicationName = optionalApplicationName != null ? optionalApplicationName : this.getResources().getString("application.name", new Object[0]);
        return ((StyledPaneBuilder)((StyledPaneBuilder)((StyledPaneBuilder)((StyledPaneBuilder)new StyledPaneBuilder().content(this.buildContent(optionalApplicationIcon, applicationName, detailsText)).commitCommands(new Object[]{CommandValue.CLOSE})).marginContentTop(0)).preferredWidth(PreferredWidth.MEDIUM)).aspectRatio(AspectRatio.DEFAULT)).build();
    }

    protected JComponent buildContent(Icon optionalApplicationIcon, String applicationName, String detailsText) {
        boolean hasAppIcon = optionalApplicationIcon != null;
        JLabel iconLabel = hasAppIcon ? new JLabel(optionalApplicationIcon) : null;
        JGComponentFactory factory = JGComponentFactory.getCurrent();
        JLabel headerLabel = factory.createHeaderLabel(applicationName);
        headerLabel.setFont(headerLabel.getFont().deriveFont(1));
        JTextComponent textComponent = factory.createStaticText(detailsText, new Object[0]);
        return ((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)((FormBuilder)new FormBuilder().columns("pref, 6dlu, default:grow", new Object[0])).rows("8epx, pref, 1dlu, fill:pref:grow", new Object[0])).add(hasAppIcon, iconLabel).xywh(1, 1, 1, 4, "center, top")).add(headerLabel).xy(3, 2)).add(textComponent).xy(3, 4)).build();
    }

    protected final ResourceMap getResources() {
        if (this.resources == null) {
            this.resources = Application.getResourceMap(this.getClass());
        }
        return this.resources;
    }

    protected final String getStringWithFallback(String optionalString, String fallbackKey) {
        return optionalString != null ? optionalString : this.getResources().getString(fallbackKey, new Object[0]);
    }
}

