/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.statistic;

import java.util.Comparator;
import java.util.TreeSet;

final class LimitedTreeSet<T>
extends TreeSet<T> {
    private final int sizeLimit;

    LimitedTreeSet(int sizeLimit, Comparator<T> comparator) {
        super(comparator);
        this.sizeLimit = sizeLimit;
    }

    boolean addItem(T newItem) {
        if (this.size() < this.sizeLimit) {
            this.add(newItem);
            return true;
        }
        Object lastItem = this.last();
        if (this.comparator().compare(newItem, lastItem) >= 0) {
            return false;
        }
        this.remove(lastItem);
        this.add(newItem);
        return true;
    }
}

