// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/bigtable/admin/cluster/v1/bigtable_cluster_service.proto

package cluster

import (
	context "context"
	reflect "reflect"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

var File_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto protoreflect.FileDescriptor

var file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2f,
	0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2f, 0x76, 0x31, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x48, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74,
	0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x32, 0x89, 0x09, 0x0a, 0x16,
	0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x99, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x5a,
	0x6f, 0x6e, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x5a, 0x6f, 0x6e, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x23, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x7a, 0x6f, 0x6e,
	0x65, 0x73, 0x12, 0x9e, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x22, 0x30, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x12, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xb0, 0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x31, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x12, 0x29, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x64, 0x2f, 0x63, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x31, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x2b, 0x22, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3a, 0x01, 0x2a, 0x12, 0x9a,
	0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0x33, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x1a, 0x28,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x01, 0x2a, 0x12, 0x91, 0x01, 0x0a, 0x0d,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x2a, 0x28, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xa5, 0x01, 0x0a, 0x0f, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x39, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x7a, 0x6f, 0x6e, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75,
	0x6e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x8f, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x42, 0x1c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x2f, 0x76,
	0x31, 0x3b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_goTypes = []interface{}{
	(*ListZonesRequest)(nil),       // 0: google.bigtable.admin.cluster.v1.ListZonesRequest
	(*GetClusterRequest)(nil),      // 1: google.bigtable.admin.cluster.v1.GetClusterRequest
	(*ListClustersRequest)(nil),    // 2: google.bigtable.admin.cluster.v1.ListClustersRequest
	(*CreateClusterRequest)(nil),   // 3: google.bigtable.admin.cluster.v1.CreateClusterRequest
	(*Cluster)(nil),                // 4: google.bigtable.admin.cluster.v1.Cluster
	(*DeleteClusterRequest)(nil),   // 5: google.bigtable.admin.cluster.v1.DeleteClusterRequest
	(*UndeleteClusterRequest)(nil), // 6: google.bigtable.admin.cluster.v1.UndeleteClusterRequest
	(*ListZonesResponse)(nil),      // 7: google.bigtable.admin.cluster.v1.ListZonesResponse
	(*ListClustersResponse)(nil),   // 8: google.bigtable.admin.cluster.v1.ListClustersResponse
	(*emptypb.Empty)(nil),          // 9: google.protobuf.Empty
	(*longrunning.Operation)(nil),  // 10: google.longrunning.Operation
}
var file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_depIdxs = []int32{
	0,  // 0: google.bigtable.admin.cluster.v1.BigtableClusterService.ListZones:input_type -> google.bigtable.admin.cluster.v1.ListZonesRequest
	1,  // 1: google.bigtable.admin.cluster.v1.BigtableClusterService.GetCluster:input_type -> google.bigtable.admin.cluster.v1.GetClusterRequest
	2,  // 2: google.bigtable.admin.cluster.v1.BigtableClusterService.ListClusters:input_type -> google.bigtable.admin.cluster.v1.ListClustersRequest
	3,  // 3: google.bigtable.admin.cluster.v1.BigtableClusterService.CreateCluster:input_type -> google.bigtable.admin.cluster.v1.CreateClusterRequest
	4,  // 4: google.bigtable.admin.cluster.v1.BigtableClusterService.UpdateCluster:input_type -> google.bigtable.admin.cluster.v1.Cluster
	5,  // 5: google.bigtable.admin.cluster.v1.BigtableClusterService.DeleteCluster:input_type -> google.bigtable.admin.cluster.v1.DeleteClusterRequest
	6,  // 6: google.bigtable.admin.cluster.v1.BigtableClusterService.UndeleteCluster:input_type -> google.bigtable.admin.cluster.v1.UndeleteClusterRequest
	7,  // 7: google.bigtable.admin.cluster.v1.BigtableClusterService.ListZones:output_type -> google.bigtable.admin.cluster.v1.ListZonesResponse
	4,  // 8: google.bigtable.admin.cluster.v1.BigtableClusterService.GetCluster:output_type -> google.bigtable.admin.cluster.v1.Cluster
	8,  // 9: google.bigtable.admin.cluster.v1.BigtableClusterService.ListClusters:output_type -> google.bigtable.admin.cluster.v1.ListClustersResponse
	4,  // 10: google.bigtable.admin.cluster.v1.BigtableClusterService.CreateCluster:output_type -> google.bigtable.admin.cluster.v1.Cluster
	4,  // 11: google.bigtable.admin.cluster.v1.BigtableClusterService.UpdateCluster:output_type -> google.bigtable.admin.cluster.v1.Cluster
	9,  // 12: google.bigtable.admin.cluster.v1.BigtableClusterService.DeleteCluster:output_type -> google.protobuf.Empty
	10, // 13: google.bigtable.admin.cluster.v1.BigtableClusterService.UndeleteCluster:output_type -> google.longrunning.Operation
	7,  // [7:14] is the sub-list for method output_type
	0,  // [0:7] is the sub-list for method input_type
	0,  // [0:0] is the sub-list for extension type_name
	0,  // [0:0] is the sub-list for extension extendee
	0,  // [0:0] is the sub-list for field type_name
}

func init() { file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_init() }
func file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_init() {
	if File_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto != nil {
		return
	}
	file_google_bigtable_admin_cluster_v1_bigtable_cluster_data_proto_init()
	file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_messages_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   0,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_goTypes,
		DependencyIndexes: file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_depIdxs,
	}.Build()
	File_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto = out.File
	file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_rawDesc = nil
	file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_goTypes = nil
	file_google_bigtable_admin_cluster_v1_bigtable_cluster_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BigtableClusterServiceClient is the client API for BigtableClusterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigtableClusterServiceClient interface {
	// Lists the supported zones for the given project.
	ListZones(ctx context.Context, in *ListZonesRequest, opts ...grpc.CallOption) (*ListZonesResponse, error)
	// Gets information about a particular cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists all clusters in the given project, along with any zones for which
	// cluster information could not be retrieved.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Creates a cluster and begins preparing it to begin serving. The returned
	// cluster embeds as its "current_operation" a long-running operation which
	// can be used to track the progress of turning up the new cluster.
	// Immediately upon completion of this request:
	//  * The cluster will be readable via the API, with all requested attributes
	//    but no allocated resources.
	// Until completion of the embedded operation:
	//  * Cancelling the operation will render the cluster immediately unreadable
	//    via the API.
	//  * All other attempts to modify or delete the cluster will be rejected.
	// Upon completion of the embedded operation:
	//  * Billing for all successfully-allocated resources will begin (some types
	//    may have lower than the requested levels).
	//  * New tables can be created in the cluster.
	//  * The cluster's allocated resource levels will be readable via the API.
	// The embedded operation's "metadata" field type is
	// [CreateClusterMetadata][google.bigtable.admin.cluster.v1.CreateClusterMetadata]
	// The embedded operation's "response" field type is
	// [Cluster][google.bigtable.admin.cluster.v1.Cluster], if successful.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Updates a cluster, and begins allocating or releasing resources as
	// requested. The returned cluster embeds as its "current_operation" a
	// long-running operation which can be used to track the progress of updating
	// the cluster.
	// Immediately upon completion of this request:
	//  * For resource types where a decrease in the cluster's allocation has been
	//    requested, billing will be based on the newly-requested level.
	// Until completion of the embedded operation:
	//  * Cancelling the operation will set its metadata's "cancelled_at_time",
	//    and begin restoring resources to their pre-request values. The operation
	//    is guaranteed to succeed at undoing all resource changes, after which
	//    point it will terminate with a CANCELLED status.
	//  * All other attempts to modify or delete the cluster will be rejected.
	//  * Reading the cluster via the API will continue to give the pre-request
	//    resource levels.
	// Upon completion of the embedded operation:
	//  * Billing will begin for all successfully-allocated resources (some types
	//    may have lower than the requested levels).
	//  * All newly-reserved resources will be available for serving the cluster's
	//    tables.
	//  * The cluster's new resource levels will be readable via the API.
	// [UpdateClusterMetadata][google.bigtable.admin.cluster.v1.UpdateClusterMetadata]
	// The embedded operation's "response" field type is
	// [Cluster][google.bigtable.admin.cluster.v1.Cluster], if successful.
	UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*Cluster, error)
	// Marks a cluster and all of its tables for permanent deletion in 7 days.
	// Immediately upon completion of the request:
	//  * Billing will cease for all of the cluster's reserved resources.
	//  * The cluster's "delete_time" field will be set 7 days in the future.
	// Soon afterward:
	//  * All tables within the cluster will become unavailable.
	// Prior to the cluster's "delete_time":
	//  * The cluster can be recovered with a call to UndeleteCluster.
	//  * All other attempts to modify or delete the cluster will be rejected.
	// At the cluster's "delete_time":
	//  * The cluster and *all of its tables* will immediately and irrevocably
	//    disappear from the API, and their data will be permanently deleted.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Cancels the scheduled deletion of an cluster and begins preparing it to
	// resume serving. The returned operation will also be embedded as the
	// cluster's "current_operation".
	// Immediately upon completion of this request:
	//  * The cluster's "delete_time" field will be unset, protecting it from
	//    automatic deletion.
	// Until completion of the returned operation:
	//  * The operation cannot be cancelled.
	// Upon completion of the returned operation:
	//  * Billing for the cluster's resources will resume.
	//  * All tables within the cluster will be available.
	// [UndeleteClusterMetadata][google.bigtable.admin.cluster.v1.UndeleteClusterMetadata]
	// The embedded operation's "response" field type is
	// [Cluster][google.bigtable.admin.cluster.v1.Cluster], if successful.
	UndeleteCluster(ctx context.Context, in *UndeleteClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type bigtableClusterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBigtableClusterServiceClient(cc grpc.ClientConnInterface) BigtableClusterServiceClient {
	return &bigtableClusterServiceClient{cc}
}

func (c *bigtableClusterServiceClient) ListZones(ctx context.Context, in *ListZonesRequest, opts ...grpc.CallOption) (*ListZonesResponse, error) {
	out := new(ListZonesResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/ListZones", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClusterServiceClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClusterServiceClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClusterServiceClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClusterServiceClient) UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClusterServiceClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableClusterServiceClient) UndeleteCluster(ctx context.Context, in *UndeleteClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.cluster.v1.BigtableClusterService/UndeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableClusterServiceServer is the server API for BigtableClusterService service.
type BigtableClusterServiceServer interface {
	// Lists the supported zones for the given project.
	ListZones(context.Context, *ListZonesRequest) (*ListZonesResponse, error)
	// Gets information about a particular cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists all clusters in the given project, along with any zones for which
	// cluster information could not be retrieved.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Creates a cluster and begins preparing it to begin serving. The returned
	// cluster embeds as its "current_operation" a long-running operation which
	// can be used to track the progress of turning up the new cluster.
	// Immediately upon completion of this request:
	//  * The cluster will be readable via the API, with all requested attributes
	//    but no allocated resources.
	// Until completion of the embedded operation:
	//  * Cancelling the operation will render the cluster immediately unreadable
	//    via the API.
	//  * All other attempts to modify or delete the cluster will be rejected.
	// Upon completion of the embedded operation:
	//  * Billing for all successfully-allocated resources will begin (some types
	//    may have lower than the requested levels).
	//  * New tables can be created in the cluster.
	//  * The cluster's allocated resource levels will be readable via the API.
	// The embedded operation's "metadata" field type is
	// [CreateClusterMetadata][google.bigtable.admin.cluster.v1.CreateClusterMetadata]
	// The embedded operation's "response" field type is
	// [Cluster][google.bigtable.admin.cluster.v1.Cluster], if successful.
	CreateCluster(context.Context, *CreateClusterRequest) (*Cluster, error)
	// Updates a cluster, and begins allocating or releasing resources as
	// requested. The returned cluster embeds as its "current_operation" a
	// long-running operation which can be used to track the progress of updating
	// the cluster.
	// Immediately upon completion of this request:
	//  * For resource types where a decrease in the cluster's allocation has been
	//    requested, billing will be based on the newly-requested level.
	// Until completion of the embedded operation:
	//  * Cancelling the operation will set its metadata's "cancelled_at_time",
	//    and begin restoring resources to their pre-request values. The operation
	//    is guaranteed to succeed at undoing all resource changes, after which
	//    point it will terminate with a CANCELLED status.
	//  * All other attempts to modify or delete the cluster will be rejected.
	//  * Reading the cluster via the API will continue to give the pre-request
	//    resource levels.
	// Upon completion of the embedded operation:
	//  * Billing will begin for all successfully-allocated resources (some types
	//    may have lower than the requested levels).
	//  * All newly-reserved resources will be available for serving the cluster's
	//    tables.
	//  * The cluster's new resource levels will be readable via the API.
	// [UpdateClusterMetadata][google.bigtable.admin.cluster.v1.UpdateClusterMetadata]
	// The embedded operation's "response" field type is
	// [Cluster][google.bigtable.admin.cluster.v1.Cluster], if successful.
	UpdateCluster(context.Context, *Cluster) (*Cluster, error)
	// Marks a cluster and all of its tables for permanent deletion in 7 days.
	// Immediately upon completion of the request:
	//  * Billing will cease for all of the cluster's reserved resources.
	//  * The cluster's "delete_time" field will be set 7 days in the future.
	// Soon afterward:
	//  * All tables within the cluster will become unavailable.
	// Prior to the cluster's "delete_time":
	//  * The cluster can be recovered with a call to UndeleteCluster.
	//  * All other attempts to modify or delete the cluster will be rejected.
	// At the cluster's "delete_time":
	//  * The cluster and *all of its tables* will immediately and irrevocably
	//    disappear from the API, and their data will be permanently deleted.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*emptypb.Empty, error)
	// Cancels the scheduled deletion of an cluster and begins preparing it to
	// resume serving. The returned operation will also be embedded as the
	// cluster's "current_operation".
	// Immediately upon completion of this request:
	//  * The cluster's "delete_time" field will be unset, protecting it from
	//    automatic deletion.
	// Until completion of the returned operation:
	//  * The operation cannot be cancelled.
	// Upon completion of the returned operation:
	//  * Billing for the cluster's resources will resume.
	//  * All tables within the cluster will be available.
	// [UndeleteClusterMetadata][google.bigtable.admin.cluster.v1.UndeleteClusterMetadata]
	// The embedded operation's "response" field type is
	// [Cluster][google.bigtable.admin.cluster.v1.Cluster], if successful.
	UndeleteCluster(context.Context, *UndeleteClusterRequest) (*longrunning.Operation, error)
}

// UnimplementedBigtableClusterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedBigtableClusterServiceServer struct {
}

func (*UnimplementedBigtableClusterServiceServer) ListZones(context.Context, *ListZonesRequest) (*ListZonesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListZones not implemented")
}
func (*UnimplementedBigtableClusterServiceServer) GetCluster(context.Context, *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedBigtableClusterServiceServer) ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedBigtableClusterServiceServer) CreateCluster(context.Context, *CreateClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedBigtableClusterServiceServer) UpdateCluster(context.Context, *Cluster) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedBigtableClusterServiceServer) DeleteCluster(context.Context, *DeleteClusterRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedBigtableClusterServiceServer) UndeleteCluster(context.Context, *UndeleteClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteCluster not implemented")
}

func RegisterBigtableClusterServiceServer(s *grpc.Server, srv BigtableClusterServiceServer) {
	s.RegisterService(&_BigtableClusterService_serviceDesc, srv)
}

func _BigtableClusterService_ListZones_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListZonesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).ListZones(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/ListZones",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).ListZones(ctx, req.(*ListZonesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableClusterService_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableClusterService_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableClusterService_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableClusterService_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).UpdateCluster(ctx, req.(*Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableClusterService_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableClusterService_UndeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableClusterServiceServer).UndeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.cluster.v1.BigtableClusterService/UndeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableClusterServiceServer).UndeleteCluster(ctx, req.(*UndeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableClusterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.cluster.v1.BigtableClusterService",
	HandlerType: (*BigtableClusterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListZones",
			Handler:    _BigtableClusterService_ListZones_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _BigtableClusterService_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _BigtableClusterService_ListClusters_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _BigtableClusterService_CreateCluster_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _BigtableClusterService_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _BigtableClusterService_DeleteCluster_Handler,
		},
		{
			MethodName: "UndeleteCluster",
			Handler:    _BigtableClusterService_UndeleteCluster_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/cluster/v1/bigtable_cluster_service.proto",
}
