/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;
import org.jboss.cache.transaction.DummyTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheWrapper
implements CacheWrapper {
    private TreeCache tree;
    private Log log = LogFactory.getLog((String)"org.cachebench.cachewrappers.JBossCacheWrapper");

    @Override
    public void init(Map parameters) throws Exception {
        this.log.debug((Object)"Initializing the cache");
        this.tree = new TreeCache();
        PropertyConfigurator conf = new PropertyConfigurator();
        conf.configure((Object)this.tree, (String)parameters.get("config"));
    }

    @Override
    public void setUp() throws Exception {
        this.tree.createService();
        this.tree.startService();
    }

    @Override
    public void tearDown() throws Exception {
        this.tree.stopService();
        this.tree.destroyService();
    }

    @Override
    public void put(List<String> l, Object key, Object value) throws Exception {
        HashMap<Object, Object> map = new HashMap<Object, Object>(1);
        map.put(key, value);
        this.tree.put(key.toString(), map);
    }

    @Override
    public Object get(List<String> l, Object key) throws Exception {
        return this.tree.get(key.toString());
    }

    @Override
    public void empty() throws Exception {
        this.tree.remove("/");
    }

    @Override
    public int getNumMembers() {
        return this.tree.getMembers().size();
    }

    @Override
    public String getInfo() {
        return this.tree.printDetails();
    }

    @Override
    public Object getReplicatedData(List<String> l, String key) {
        return null;
    }

    public Transaction startTransaction() {
        try {
            DummyTransactionManager.getInstance().begin();
            return DummyTransactionManager.getInstance().getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endTransaction(boolean successful) {
        try {
            if (successful) {
                DummyTransactionManager.getInstance().commit();
            } else {
                DummyTransactionManager.getInstance().rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

