/*  job_analyzediagrams.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_ANALYZEDIAGRAMS_H_
#define JOB_ANALYZEDIAGRAMS_H_

#include "job.h"

namespace Reduze {

class Graph;
class Diagram;
class SectorGL;

/// Job to match diagrams to sectors via graphs
class AnalyzeDiagrams: public Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("analyze_diagrams");
		s.set_short_description("Analyzes diagrams from QGRAF.");
		s.set_long_description(""//
					"Analyzes diagrams from QGRAF.");
		s.add_option("qgraf_file", true, "string", ""//
					"Input file: QGRAF output (using style file for Reduze YAML"
					" format).");
		s.add_option("output_directory", true, "string", ""//
					"Output directory for the generated graphs.");
		/// \todo use positions instead of names to select (for consistency with compute_diagram_interferences)
		s.add_option("names", false, "sequence of strings", ""//
					"Input files: list of the names of the diagrams that are"
					" processed; empty means all.");
		s.add_option("top_level_diagrams_file", true, "string", ""//
					"Output file: A file containing a selection of"
					" diagrams which, as graphs, contain all other diagrams"
					" as subgraphs (in the sense of edge contraction).");
		//		s.add_option("minimize_graphs_by_twists", false, "boolean", ""//
		//					"Whether generated graphs should be minimized by twists.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}

	AnalyzeDiagrams() /*:*/
	/*minimize_graphs_by_twists_(true)*/{
		add_auto_options();
	}
	virtual ~AnalyzeDiagrams() {
	}

	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;

protected:
	size_t get_graphs_of_diagrams(std::map<int, std::list<std::pair<Graph,
			Diagram> > >& graphsbyloop) const;

	virtual void add_auto_options() {
		add_auto_io("qgraf_file", qgraf_filename_);
		add_auto_io("output_directory", output_directory_);
		add_auto_io("names", names_);
		add_auto_io("top_level_diagrams_file", top_level_diagrams_file_);
		//add_auto_io("minimize_graphs_by_twists", minimize_graphs_by_twists_);
	}

private:
	std::string qgraf_filename_; // input (YAML)
	std::set<std::string> names_; // input: list of the names of the diagrams that are processed; empty means all
	std::string output_directory_;
	std::string top_level_diagrams_file_;
	//bool minimize_graphs_by_twists_;
};

}

#endif /* JOB_ANALYZEDIAGRAMS_H_ */
