/*  job_computedifferentialequations.h
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#ifndef JOB_COMPUTEDIFFERENTIALEQUATIONS_H_
#define JOB_COMPUTEDIFFERENTIALEQUATIONS_H_

#include "job.h"
#include "int.h"
#include "ginac/ginac.h"

namespace Reduze {

/// Job to compute differential equations for master integrals
class ComputeDifferentialEquations: public Reduze::Job {
public:
	static YAMLSpec yaml_spec() {
		YAMLSpec s;
		s.set_keyword("compute_differential_equations");
		s.set_short_description(
				"Computes derivatives of integrals wrt invariants.");
		s.set_long_description(""//
					"Job to compute derivatives of integrals wrt all kinematic"
					" invariants {x_i}. Provides also the combination "
					" sum_i  x_i * massdim(x_i) * dI/dxi as a scaling check:"
					" after reduction, this expression should give"
					" I * massdim(I).");
		s.add_option("integrals_file", true, "string", ""//
					"Name of input file containing the integrals for which"
					" derivatives should be computed.");
		s.add_option("output_file", true, "string", "Output file name.");
		s.add_option("set_subsectors_to_zero", false, "boolean",
				    "Discards contributions from subsectors. Note that the "
				    " output will be wrong. This option is useful for "
				    " decoupling studies.");
		s.add_options(Job::yaml_spec());
		return s;
	}
	virtual YAMLSpec yaml_spec_link() const {
		return yaml_spec();
	}
	ComputeDifferentialEquations() : set_subsectors_to_zero_(false) {
		add_auto_options();
	}
	virtual ~ComputeDifferentialEquations() {
	}
	virtual void run_serial();
	virtual bool find_dependencies(const std::set<std::string>&,//
			std::list<std::string>&, std::list<std::string>&, std::list<Job*>&);
	virtual std::string get_description() const;
protected:
	virtual void add_auto_options() {
		add_auto_io("integrals_file", integrals_filename_);
		add_auto_io("output_file", output_filename_);
		add_auto_io("set_subsectors_to_zero", set_subsectors_to_zero_);
	}
	virtual void print_manual_options(YAML::Emitter& os) const;
	virtual void read_manual_options(const YAML::Node&);
private:
	std::string integrals_filename_;
	std::string output_filename_;
	bool set_subsectors_to_zero_;
};

}

#endif /* JOB_COMPUTEDIFFERENTIALEQUATIONS_H_ */
