/*  job_mergesectormappings.cpp
 *
 *  Copyright (C) 2010-2012 Andreas von Manteuffel
 *  Copyright (C) 2010-2012 Cedric Studerus
 *
 *  This file is part of the package Reduze 2.
 *  It is distributed under the GNU General Public License version 3
 *  (see the file GPL-3.0.txt or http://www.gnu.org/licenses/gpl-3.0.txt).
 */

#include "job_mergesectormappings.h"
#include "files.h"
#include "integralfamily.h"
#include "sectormappings.h"
#include "yamlutils.h"

using namespace std;

namespace Reduze {

namespace {
JobProxy<MergeSectorMappings> dummy;
}

bool MergeSectorMappings::find_dependencies(const set<string>& outothers, //
		list<string>& in, list<string>& out, list<Job*>& auxjobs) {
	list<string>::const_iterator f;
	for (f = input_files_.begin(); f != input_files_.end(); ++f)
		in.push_back(*f);
	out.push_back(output_file_);
	return true;
}

void MergeSectorMappings::init() {
	if (name_.empty() || input_files_.empty() || input_files_.front().empty()
			|| output_file_.empty())
		throw runtime_error("name, input files or output files undefined");
}

std::string MergeSectorMappings::get_description() const {
	return "merge sector mappings for " + name_;
}

void MergeSectorMappings::run_serial() {
	const IntegralFamily* fam = Files::instance()->integralfamily(name_);
	SectorMappings sm(fam);
	list<string>::const_iterator f;
	for (f = input_files_.begin(); f != input_files_.end(); ++f) {
		std::ifstream fin(f->c_str());
		if (!fin)
			throw missing_file_error(string("Can't open file ") + *f);
		YAML::Parser parser(fin);
		YAML::Node doc;
		parser.GetNextDocument(doc);
		sm.read(doc["sectormappings"]);
	}
	std::ofstream fout(output_file_.c_str());
	using namespace YAML;
	Emitter ye;
	ye << BeginMap << Key << "sectormappings" << Value << sm << EndMap;
	fout << ye.c_str() << "\n";
	fout.close();
}

} // namespace Reduze
