/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextReporter
extends TestListenerAdapter {
    private int m_verbose = 0;
    private String m_testName = null;

    public TextReporter(String testName, int verbose) {
        this.m_testName = testName;
        this.m_verbose = verbose;
    }

    @Override
    public void onFinish(ITestContext context) {
        if (this.m_verbose >= 2) {
            this.logResults();
        }
    }

    private ITestNGMethod[] resultsToMethods(List<ITestResult> results) {
        ITestNGMethod[] result = new ITestNGMethod[results.size()];
        int i = 0;
        for (ITestResult tr : results) {
            result[i++] = tr.getMethod();
        }
        return result;
    }

    private void logResults() {
        ITestResult tr;
        ITestResult o;
        Iterator<ITestResult> i$ = this.getPassedTests().iterator();
        while (i$.hasNext()) {
            tr = o = i$.next();
            this.logResult("PASSED", tr.getName(), tr.getMethod().getDescription());
        }
        i$ = this.getFailedTests().iterator();
        while (i$.hasNext()) {
            tr = o = i$.next();
            Throwable ex = tr.getThrowable();
            this.logResult("FAILED", tr.getName(), tr.getMethod().getDescription());
            if (ex == null || this.m_verbose < 2) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(baos);
            ex.printStackTrace(writer);
            writer.flush();
            writer.close();
            this.logResult("", baos.toString(), null);
        }
        i$ = this.getSkippedTests().iterator();
        while (i$.hasNext()) {
            tr = o = i$.next();
            this.logResult("SKIPPED", tr.getName(), tr.getMethod().getDescription());
        }
        ITestNGMethod[] ft = this.resultsToMethods(this.getFailedTests());
        String stats = "\n===============================================\n    " + this.m_testName + "\n" + "    Tests run: " + Utils.calculateInvokedMethodCount(this.getAllTestMethods()) + ", Failures: " + Utils.calculateInvokedMethodCount(ft) + ", Skips: " + Utils.calculateInvokedMethodCount(this.resultsToMethods(this.getSkippedTests())) + "\n===============================================\n";
        this.logResult("", stats, null);
    }

    private String getName() {
        return this.m_testName;
    }

    private void logResult(String status, String name, String description) {
        if (!"".equals(status)) {
            System.out.print(status + ": ");
        }
        System.out.println(name);
        if (!Utils.isStringEmpty(description)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length() + 2; ++i) {
                sb.append(" ");
            }
            sb.append(description);
            System.out.println(sb.toString());
        }
    }

    private void logResult(Throwable s) {
        System.out.println(s.getMessage());
    }

    public void ppp(String s) {
        System.out.println("[TextReporter " + this.getName() + "] " + s);
    }
}

