find_package(GSL REQUIRED)
find_package(MSCG QUIET)
if(MSGC_FOUND)
  set(DOWNLOAD_MSCG_DEFAULT OFF)
else()
  set(DOWNLOAD_MSCG_DEFAULT ON)
endif()
option(DOWNLOAD_MSCG "Download MSCG library instead of using an already installed one)" ${DOWNLOAD_MSCG_DEFAULT})
if(DOWNLOAD_MSCG)
  set(MSCG_URL "https://github.com/uchicago-voth/MSCG-release/archive/491270a73539e3f6951e76f7dbe84e258b3ebb45.tar.gz" CACHE STRING "URL for MSCG tarball")
  set(MSCG_MD5 "7ea50748fba5c3a372e0266bd31d2f11" CACHE STRING "MD5 checksum of MSCG tarball")
  mark_as_advanced(MSCG_URL)
  mark_as_advanced(MSCG_MD5)

  include(ExternalCMakeProject)
  ExternalCMakeProject(mscg ${MSCG_URL} ${MSCG_MD5} MSCG-release src/CMake "")

  # set include and link library
  target_include_directories(lammps PRIVATE "${CMAKE_BINARY_DIR}/_deps/mscg-src/src")
  target_link_libraries(lammps PRIVATE mscg)
else()
  find_package(MSCG)
  if(NOT MSCG_FOUND)
    message(FATAL_ERROR "MSCG not found, help CMake to find it by setting MSCG_LIBRARY and MSCG_INCLUDE_DIR, or set DOWNLOAD_MSCG=ON to download it")
  endif()
  target_link_libraries(lammps PRIVATE MSCG::MSCG)
endif()
target_link_libraries(lammps PRIVATE GSL::gsl ${LAPACK_LIBRARIES})
