/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JWindow;
import net.charabia.jsmoothgen.application.gui.Main;

public class HelpButton
extends JLabel {
    protected JWindow m_helpWindow = new JWindow(Main.MAIN);
    private final Icon ICON_HELP = new ImageIcon(this.getClass().getResource("/icons/stock_help-agent-16.png"));

    public HelpButton(String helptext) {
        this.setText("");
        this.setIcon(this.ICON_HELP);
        this.m_helpWindow.getContentPane().setBackground(Color.yellow);
        this.m_helpWindow.getContentPane().setLayout(new BorderLayout());
        JEditorPane jep = new JEditorPane("text/html", this.wrap(helptext));
        jep.setBackground(Color.yellow);
        jep.setEditable(false);
        this.m_helpWindow.getContentPane().add((Component)jep, "Center");
        jep.setBorder(BorderFactory.createEtchedBorder(1));
        this.m_helpWindow.pack();
        this.m_helpWindow.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                HelpButton.this.m_helpWindow.dispose();
            }

            public void mouseExited(MouseEvent e) {
                HelpButton.this.m_helpWindow.dispose();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                HelpButton.this.requestFocus();
                HelpButton.this.adjustLocation();
                HelpButton.this.m_helpWindow.setVisible(true);
            }

            public void mouseExited(MouseEvent e) {
                HelpButton.this.m_helpWindow.setVisible(false);
            }
        });
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.m_helpWindow.setVisible(false);
        }
    }

    public String wrap(String str) {
        StringBuffer sb = new StringBuffer();
        StringBuffer line = new StringBuffer();
        StringTokenizer stok = new StringTokenizer(str, " ", true);
        while (stok.hasMoreElements()) {
            boolean cut = false;
            String tok = stok.nextToken();
            line.append(tok);
            if (tok.indexOf("<br") >= 0 || tok.indexOf("<BR") >= 0 || tok.indexOf("<p>") >= 0 || tok.indexOf("<p/>") >= 0 || tok.indexOf("<P/>") >= 0 || tok.indexOf("<P/>") >= 0) {
                sb.append(line);
                line.setLength(0);
            }
            if (line.length() <= 80) continue;
            sb.append(line);
            sb.append("<br>\n");
            line.setLength(0);
        }
        sb.append(line);
        return sb.toString();
    }

    public void adjustLocation() {
        Point p = this.getLocationOnScreen();
        p.y += this.getHeight();
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        if (p.x + this.m_helpWindow.getWidth() > bounds.width) {
            p.x = bounds.width - this.m_helpWindow.getWidth();
        }
        if (p.x < bounds.x) {
            p.x = bounds.x;
        }
        this.m_helpWindow.setLocation(p.x, p.y);
    }
}

