#!/bin/sh

if [ "$1" = "--release" ]
then
   TMPDIR=`mktemp -dt check_dnssec.XXXXXX`
   NAME=`grep AC_INIT configure.ac | sed "s/^.*AC_INIT(\([^,]*\) *..*).*$/\1/"`
   VERSION=`grep AC_INIT configure.ac | sed "s/^.*AC_INIT([^,]*, \?\([^,]*\).*).*$/\1/"`
   ${SVN:-svn} export . ${TMPDIR}/${NAME}-${VERSION}

   cd ${TMPDIR}/${NAME}-${VERSION}
fi

mkdir -p build

# Produce config.h.in
echo "Creating config.h.in..."
rm config.h.in
${AUTOHEADER:-autoheader}

# Produce aclocal.m4
echo "Creating aclocal.m4..."
rm aclocal.m4
${ACLOCAL:-aclocal}

# Produce ./configure
echo "Creating configure..."
rm configure
${AUTOCONF:-autoconf}

# Produce Makefile.in
echo "Creating Makefile.in..."
rm Makefile.in
${AUTOMAKE:-automake} --add-missing --copy

# Cleaning up
echo "Cleaning up..."
rm -rf autom4te*.cache aclocal.m4


if [ "$1" = "--release" ]
then
   cd ${TMPDIR}
   tar cjf /tmp/${NAME}-${VERSION}.tar.bz ${NAME}-${VERSION}
   rm -rf ${TMPDIR}
else
   echo ""
   echo "You can run ./configure now."
   echo ""
fi
