package autogeneratedskip

import (
	"os"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

func TestFooExists(t *testing.T) {
	mockFile := "./mocks_testify_autogeneratedskip_test.go"
	mockContents, err := os.ReadFile(mockFile)
	require.NoError(t, err)

	assert.NotContains(t, string(mockContents), "func NewMockBar", "mock for type Bar was generated when it shouldn't have been because it's in an auto-generated file.")
	assert.Contains(t, string(mockContents), "func NewMockFoo")
}
