/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class FilterSet
extends DataType
implements Cloneable {
    public static final String DEFAULT_TOKEN_START = "@";
    public static final String DEFAULT_TOKEN_END = "@";
    private String startOfToken = "@";
    private String endOfToken = "@";
    private Vector filters = new Vector();
    private Vector passedTokens;
    private boolean duplicateToken = false;
    static /* synthetic */ Class class$org$apache$tools$ant$types$FilterSet;

    public FilterSet() {
    }

    protected FilterSet(FilterSet filterset) {
        this.filters = (Vector)filterset.getFilters().clone();
    }

    protected Vector getFilters() {
        if (this.isReference()) {
            return this.getRef().getFilters();
        }
        return this.filters;
    }

    protected FilterSet getRef() {
        return (FilterSet)this.getCheckedRef(class$org$apache$tools$ant$types$FilterSet == null ? (class$org$apache$tools$ant$types$FilterSet = FilterSet.class$("org.apache.tools.ant.types.FilterSet")) : class$org$apache$tools$ant$types$FilterSet, "filterset");
    }

    public Hashtable getFilterHash() {
        int filterSize = this.getFilters().size();
        Hashtable<String, String> filterHash = new Hashtable<String, String>(filterSize + 1);
        Enumeration e = this.getFilters().elements();
        while (e.hasMoreElements()) {
            Filter filter = (Filter)e.nextElement();
            filterHash.put(filter.getToken(), filter.getValue());
        }
        return filterHash;
    }

    public void setFiltersfile(File filtersFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.readFiltersFromFile(filtersFile);
    }

    public void setBeginToken(String startOfToken) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (startOfToken == null || "".equals(startOfToken)) {
            throw new BuildException("beginToken must not be empty");
        }
        this.startOfToken = startOfToken;
    }

    public String getBeginToken() {
        if (this.isReference()) {
            return this.getRef().getBeginToken();
        }
        return this.startOfToken;
    }

    public void setEndToken(String endOfToken) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (endOfToken == null || "".equals(endOfToken)) {
            throw new BuildException("endToken must not be empty");
        }
        this.endOfToken = endOfToken;
    }

    public String getEndToken() {
        if (this.isReference()) {
            return this.getRef().getEndToken();
        }
        return this.endOfToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFiltersFromFile(File filtersFile) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!filtersFile.exists()) {
            throw new BuildException("Could not read filters from file " + filtersFile + " as it doesn't exist.");
        }
        if (!filtersFile.isFile()) throw new BuildException("Must specify a file not a directory in the filtersfile attribute:" + filtersFile);
        this.log("Reading filters from " + filtersFile, 3);
        FileInputStream in = null;
        try {
            try {
                Properties props = new Properties();
                in = new FileInputStream(filtersFile);
                props.load(in);
                Enumeration<?> e = props.propertyNames();
                Vector filters = this.getFilters();
                while (e.hasMoreElements()) {
                    String strPropName = (String)e.nextElement();
                    String strValue = props.getProperty(strPropName);
                    filters.addElement(new Filter(strPropName, strValue));
                }
            }
            catch (Exception ex) {
                throw new BuildException("Could not read filters from file: " + filtersFile);
            }
            Object var9_9 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ioex) {}
        in.close();
        return;
    }

    public String replaceTokens(String line) {
        this.passedTokens = null;
        return this.iReplaceTokens(line);
    }

    private String iReplaceTokens(String line) {
        String beginToken = this.getBeginToken();
        String endToken = this.getEndToken();
        int index = line.indexOf(beginToken);
        if (index > -1) {
            Hashtable tokens = this.getFilterHash();
            try {
                int endIndex;
                StringBuffer b = new StringBuffer();
                int i = 0;
                String token = null;
                String value = null;
                while ((endIndex = line.indexOf(endToken, index + beginToken.length() + 1)) != -1) {
                    token = line.substring(index + beginToken.length(), endIndex);
                    b.append(line.substring(i, index));
                    if (tokens.containsKey(token)) {
                        value = (String)tokens.get(token);
                        if (!value.equals(token)) {
                            value = this.replaceTokens(value, token);
                        }
                        this.log("Replacing: " + beginToken + token + endToken + " -> " + value, 3);
                        b.append(value);
                        i = index + beginToken.length() + token.length() + endToken.length();
                    } else {
                        b.append(beginToken);
                        i = index + beginToken.length();
                    }
                    if ((index = line.indexOf(beginToken, i)) > -1) continue;
                }
                b.append(line.substring(i));
                return b.toString();
            }
            catch (StringIndexOutOfBoundsException e) {
                return line;
            }
        }
        return line;
    }

    private String replaceTokens(String line, String parent) throws BuildException {
        if (this.passedTokens == null) {
            this.passedTokens = new Vector();
        }
        if (this.passedTokens.contains(parent) && !this.duplicateToken) {
            this.duplicateToken = true;
            StringBuffer sb = new StringBuffer();
            sb.append("Infinite loop in tokens. Currently known tokens : ");
            sb.append(this.passedTokens);
            sb.append("\nProblem token : " + this.getBeginToken() + parent + this.getEndToken());
            sb.append(" called from " + this.getBeginToken() + this.passedTokens.lastElement());
            sb.append(this.getEndToken());
            System.out.println(sb.toString());
            return parent;
        }
        this.passedTokens.addElement(parent);
        String value = this.iReplaceTokens(line);
        if (value.indexOf(this.getBeginToken()) == -1 && !this.duplicateToken) {
            this.duplicateToken = false;
            this.passedTokens = null;
        } else if (this.duplicateToken && this.passedTokens.size() > 0) {
            value = (String)this.passedTokens.lastElement();
            this.passedTokens.removeElementAt(this.passedTokens.size() - 1);
            if (this.passedTokens.size() == 0) {
                value = this.getBeginToken() + value + this.getEndToken();
                this.duplicateToken = false;
            }
        }
        return value;
    }

    public void addFilter(Filter filter) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filters.addElement(filter);
    }

    public FiltersFile createFiltersfile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return new FiltersFile();
    }

    public void addFilter(String token, String value) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filters.addElement(new Filter(token, value));
    }

    public void addConfiguredFilterSet(FilterSet filterSet) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Enumeration e = filterSet.getFilters().elements();
        while (e.hasMoreElements()) {
            this.filters.addElement(e.nextElement());
        }
    }

    public boolean hasFilters() {
        return this.getFilters().size() > 0;
    }

    public Object clone() throws BuildException {
        if (this.isReference()) {
            return this.getRef().clone();
        }
        try {
            FilterSet fs = (FilterSet)super.clone();
            fs.filters = (Vector)this.getFilters().clone();
            fs.setProject(this.getProject());
            return fs;
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class FiltersFile {
        public void setFile(File file) {
            FilterSet.this.readFiltersFromFile(file);
        }
    }

    public static class Filter {
        String token;
        String value;

        public Filter(String token, String value) {
            this.token = token;
            this.value = value;
        }

        public Filter() {
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }
}

