/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.subsonic.booter.agent;

import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import net.sourceforge.subsonic.booter.agent.SubsonicFrame;
import net.sourceforge.subsonic.booter.agent.SubsonicListener;
import net.sourceforge.subsonic.booter.agent.TrayController;
import net.sourceforge.subsonic.booter.deployer.DeploymentStatus;
import net.sourceforge.subsonic.booter.deployer.SubsonicDeployerService;
import org.apache.commons.io.IOUtils;

public class SubsonicAgent {
    private final List<SubsonicListener> listeners = new ArrayList<SubsonicListener>();
    private final TrayController trayController;
    private SubsonicFrame frame;
    private final SubsonicDeployerService service;
    private static final int POLL_INTERVAL_DEPLOYMENT_INFO_SECONDS = 5;
    private static final int POLL_INTERVAL_SERVICE_STATUS_SECONDS = 5;
    private String url;
    private boolean serviceStatusPollingEnabled;
    private boolean elevated;

    public SubsonicAgent(SubsonicDeployerService service) {
        this.service = service;
        this.setLookAndFeel();
        this.trayController = new TrayController(this);
        this.startPolling();
    }

    public void setFrame(SubsonicFrame frame) {
        this.frame = frame;
    }

    private void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(new PlasticXPLookAndFeel());
        }
        catch (Throwable x) {
            System.err.println("Failed to set look-and-feel.\n" + x);
        }
    }

    private void startPolling() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    SubsonicAgent.this.notifyDeploymentInfo(SubsonicAgent.this.service.getDeploymentInfo());
                }
                catch (Throwable x) {
                    SubsonicAgent.this.notifyDeploymentInfo(null);
                }
            }
        };
        executor.scheduleWithFixedDelay(runnable, 0L, 5L, TimeUnit.SECONDS);
        runnable = new Runnable(){

            @Override
            public void run() {
                if (SubsonicAgent.this.serviceStatusPollingEnabled) {
                    try {
                        SubsonicAgent.this.notifyServiceStatus(SubsonicAgent.this.getServiceStatus());
                    }
                    catch (Throwable x) {
                        SubsonicAgent.this.notifyServiceStatus(null);
                    }
                }
            }
        };
        executor.scheduleWithFixedDelay(runnable, 0L, 5L, TimeUnit.SECONDS);
    }

    private String getServiceStatus() throws Exception {
        Process process = Runtime.getRuntime().exec("subsonic-service.exe -status");
        return IOUtils.toString(process.getInputStream());
    }

    public void setServiceStatusPollingEnabled(boolean enabled) {
        this.serviceStatusPollingEnabled = enabled;
    }

    public void startOrStopService(boolean start) {
        try {
            String cmd = "subsonic-service.exe " + (start ? "-start" : "-stop");
            System.err.println("Executing: " + cmd);
            Runtime.getRuntime().exec(cmd);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void checkElevation(String ... args) {
        if (this.isElevationNeeded() && !this.isElevated()) {
            try {
                ArrayList<String> command = new ArrayList<String>();
                command.add("cmd");
                command.add("/c");
                command.add("subsonic-agent-elevated.exe");
                command.addAll(Arrays.asList(args));
                ProcessBuilder builder = new ProcessBuilder(new String[0]);
                builder.command(command);
                System.err.println("Executing: " + command + " with current dir: " + System.getProperty("user.dir"));
                builder.start();
                System.exit(0);
            }
            catch (Exception x) {
                JOptionPane.showMessageDialog(this.frame, "Failed to elevate Subsonic Control Panel. " + x, "Error", 2);
                x.printStackTrace();
            }
        }
    }

    public void setElevated(boolean elevated) {
        this.elevated = elevated;
    }

    private boolean isElevated() {
        return this.elevated;
    }

    private boolean isElevationNeeded() {
        String osVersion = System.getProperty("os.version");
        try {
            int majorVersion = Integer.parseInt(osVersion.substring(0, osVersion.indexOf(".")));
            return majorVersion >= 6;
        }
        catch (Exception x) {
            System.err.println("Failed to resolve OS version from '" + osVersion + "'\n" + x);
            return false;
        }
    }

    public void addListener(SubsonicListener listener) {
        this.listeners.add(listener);
    }

    private void notifyDeploymentInfo(DeploymentStatus status) {
        if (status != null) {
            this.url = status.getURL();
        }
        for (SubsonicListener listener : this.listeners) {
            listener.notifyDeploymentStatus(status);
        }
    }

    private void notifyServiceStatus(String status) {
        for (SubsonicListener listener : this.listeners) {
            listener.notifyServiceStatus(status);
        }
    }

    public void showStatusPanel() {
        this.frame.showStatusPanel();
    }

    public void showSettingsPanel() {
        this.frame.showSettingsPanel();
    }

    public void showTrayIconMessage() {
        this.trayController.showMessage();
    }

    public void exit() {
        this.trayController.uninstallComponents();
        System.exit(0);
    }

    public void openBrowser() {
        try {
            Desktop.getDesktop().browse(new URI(this.url));
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }
}

