package logic

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessKeyType enumerates the values for access key type.
type AccessKeyType string

const (
	// NotSpecified ...
	NotSpecified AccessKeyType = "NotSpecified"
	// Primary ...
	Primary AccessKeyType = "Primary"
	// Secondary ...
	Secondary AccessKeyType = "Secondary"
)

// PossibleAccessKeyTypeValues returns an array of possible values for the AccessKeyType const type.
func PossibleAccessKeyTypeValues() []AccessKeyType {
	return []AccessKeyType{NotSpecified, Primary, Secondary}
}

// AgreementType enumerates the values for agreement type.
type AgreementType string

const (
	// AgreementTypeAS2 ...
	AgreementTypeAS2 AgreementType = "AS2"
	// AgreementTypeEdifact ...
	AgreementTypeEdifact AgreementType = "Edifact"
	// AgreementTypeNotSpecified ...
	AgreementTypeNotSpecified AgreementType = "NotSpecified"
	// AgreementTypeX12 ...
	AgreementTypeX12 AgreementType = "X12"
)

// PossibleAgreementTypeValues returns an array of possible values for the AgreementType const type.
func PossibleAgreementTypeValues() []AgreementType {
	return []AgreementType{AgreementTypeAS2, AgreementTypeEdifact, AgreementTypeNotSpecified, AgreementTypeX12}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DaysOfWeek enumerates the values for days of week.
type DaysOfWeek string

const (
	// DaysOfWeekFriday ...
	DaysOfWeekFriday DaysOfWeek = "Friday"
	// DaysOfWeekMonday ...
	DaysOfWeekMonday DaysOfWeek = "Monday"
	// DaysOfWeekSaturday ...
	DaysOfWeekSaturday DaysOfWeek = "Saturday"
	// DaysOfWeekSunday ...
	DaysOfWeekSunday DaysOfWeek = "Sunday"
	// DaysOfWeekThursday ...
	DaysOfWeekThursday DaysOfWeek = "Thursday"
	// DaysOfWeekTuesday ...
	DaysOfWeekTuesday DaysOfWeek = "Tuesday"
	// DaysOfWeekWednesday ...
	DaysOfWeekWednesday DaysOfWeek = "Wednesday"
)

// PossibleDaysOfWeekValues returns an array of possible values for the DaysOfWeek const type.
func PossibleDaysOfWeekValues() []DaysOfWeek {
	return []DaysOfWeek{DaysOfWeekFriday, DaysOfWeekMonday, DaysOfWeekSaturday, DaysOfWeekSunday, DaysOfWeekThursday, DaysOfWeekTuesday, DaysOfWeekWednesday}
}

// EdifactCharacterSet enumerates the values for edifact character set.
type EdifactCharacterSet string

const (
	// EdifactCharacterSetKECA ...
	EdifactCharacterSetKECA EdifactCharacterSet = "KECA"
	// EdifactCharacterSetNotSpecified ...
	EdifactCharacterSetNotSpecified EdifactCharacterSet = "NotSpecified"
	// EdifactCharacterSetUNOA ...
	EdifactCharacterSetUNOA EdifactCharacterSet = "UNOA"
	// EdifactCharacterSetUNOB ...
	EdifactCharacterSetUNOB EdifactCharacterSet = "UNOB"
	// EdifactCharacterSetUNOC ...
	EdifactCharacterSetUNOC EdifactCharacterSet = "UNOC"
	// EdifactCharacterSetUNOD ...
	EdifactCharacterSetUNOD EdifactCharacterSet = "UNOD"
	// EdifactCharacterSetUNOE ...
	EdifactCharacterSetUNOE EdifactCharacterSet = "UNOE"
	// EdifactCharacterSetUNOF ...
	EdifactCharacterSetUNOF EdifactCharacterSet = "UNOF"
	// EdifactCharacterSetUNOG ...
	EdifactCharacterSetUNOG EdifactCharacterSet = "UNOG"
	// EdifactCharacterSetUNOH ...
	EdifactCharacterSetUNOH EdifactCharacterSet = "UNOH"
	// EdifactCharacterSetUNOI ...
	EdifactCharacterSetUNOI EdifactCharacterSet = "UNOI"
	// EdifactCharacterSetUNOJ ...
	EdifactCharacterSetUNOJ EdifactCharacterSet = "UNOJ"
	// EdifactCharacterSetUNOK ...
	EdifactCharacterSetUNOK EdifactCharacterSet = "UNOK"
	// EdifactCharacterSetUNOX ...
	EdifactCharacterSetUNOX EdifactCharacterSet = "UNOX"
	// EdifactCharacterSetUNOY ...
	EdifactCharacterSetUNOY EdifactCharacterSet = "UNOY"
)

// PossibleEdifactCharacterSetValues returns an array of possible values for the EdifactCharacterSet const type.
func PossibleEdifactCharacterSetValues() []EdifactCharacterSet {
	return []EdifactCharacterSet{EdifactCharacterSetKECA, EdifactCharacterSetNotSpecified, EdifactCharacterSetUNOA, EdifactCharacterSetUNOB, EdifactCharacterSetUNOC, EdifactCharacterSetUNOD, EdifactCharacterSetUNOE, EdifactCharacterSetUNOF, EdifactCharacterSetUNOG, EdifactCharacterSetUNOH, EdifactCharacterSetUNOI, EdifactCharacterSetUNOJ, EdifactCharacterSetUNOK, EdifactCharacterSetUNOX, EdifactCharacterSetUNOY}
}

// EdifactDecimalIndicator enumerates the values for edifact decimal indicator.
type EdifactDecimalIndicator string

const (
	// EdifactDecimalIndicatorComma ...
	EdifactDecimalIndicatorComma EdifactDecimalIndicator = "Comma"
	// EdifactDecimalIndicatorDecimal ...
	EdifactDecimalIndicatorDecimal EdifactDecimalIndicator = "Decimal"
	// EdifactDecimalIndicatorNotSpecified ...
	EdifactDecimalIndicatorNotSpecified EdifactDecimalIndicator = "NotSpecified"
)

// PossibleEdifactDecimalIndicatorValues returns an array of possible values for the EdifactDecimalIndicator const type.
func PossibleEdifactDecimalIndicatorValues() []EdifactDecimalIndicator {
	return []EdifactDecimalIndicator{EdifactDecimalIndicatorComma, EdifactDecimalIndicatorDecimal, EdifactDecimalIndicatorNotSpecified}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES128 ...
	EncryptionAlgorithmAES128 EncryptionAlgorithm = "AES128"
	// EncryptionAlgorithmAES192 ...
	EncryptionAlgorithmAES192 EncryptionAlgorithm = "AES192"
	// EncryptionAlgorithmAES256 ...
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmDES3 ...
	EncryptionAlgorithmDES3 EncryptionAlgorithm = "DES3"
	// EncryptionAlgorithmNone ...
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmNotSpecified ...
	EncryptionAlgorithmNotSpecified EncryptionAlgorithm = "NotSpecified"
	// EncryptionAlgorithmRC2 ...
	EncryptionAlgorithmRC2 EncryptionAlgorithm = "RC2"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{EncryptionAlgorithmAES128, EncryptionAlgorithmAES192, EncryptionAlgorithmAES256, EncryptionAlgorithmDES3, EncryptionAlgorithmNone, EncryptionAlgorithmNotSpecified, EncryptionAlgorithmRC2}
}

// EventLevel enumerates the values for event level.
type EventLevel string

const (
	// Critical ...
	Critical EventLevel = "Critical"
	// Error ...
	Error EventLevel = "Error"
	// Informational ...
	Informational EventLevel = "Informational"
	// LogAlways ...
	LogAlways EventLevel = "LogAlways"
	// Verbose ...
	Verbose EventLevel = "Verbose"
	// Warning ...
	Warning EventLevel = "Warning"
)

// PossibleEventLevelValues returns an array of possible values for the EventLevel const type.
func PossibleEventLevelValues() []EventLevel {
	return []EventLevel{Critical, Error, Informational, LogAlways, Verbose, Warning}
}

// HashingAlgorithm enumerates the values for hashing algorithm.
type HashingAlgorithm string

const (
	// HashingAlgorithmMD5 ...
	HashingAlgorithmMD5 HashingAlgorithm = "MD5"
	// HashingAlgorithmNone ...
	HashingAlgorithmNone HashingAlgorithm = "None"
	// HashingAlgorithmNotSpecified ...
	HashingAlgorithmNotSpecified HashingAlgorithm = "NotSpecified"
	// HashingAlgorithmSHA1 ...
	HashingAlgorithmSHA1 HashingAlgorithm = "SHA1"
	// HashingAlgorithmSHA2256 ...
	HashingAlgorithmSHA2256 HashingAlgorithm = "SHA2256"
	// HashingAlgorithmSHA2384 ...
	HashingAlgorithmSHA2384 HashingAlgorithm = "SHA2384"
	// HashingAlgorithmSHA2512 ...
	HashingAlgorithmSHA2512 HashingAlgorithm = "SHA2512"
)

// PossibleHashingAlgorithmValues returns an array of possible values for the HashingAlgorithm const type.
func PossibleHashingAlgorithmValues() []HashingAlgorithm {
	return []HashingAlgorithm{HashingAlgorithmMD5, HashingAlgorithmNone, HashingAlgorithmNotSpecified, HashingAlgorithmSHA1, HashingAlgorithmSHA2256, HashingAlgorithmSHA2384, HashingAlgorithmSHA2512}
}

// IntegrationAccountSkuName enumerates the values for integration account sku name.
type IntegrationAccountSkuName string

const (
	// IntegrationAccountSkuNameFree ...
	IntegrationAccountSkuNameFree IntegrationAccountSkuName = "Free"
	// IntegrationAccountSkuNameNotSpecified ...
	IntegrationAccountSkuNameNotSpecified IntegrationAccountSkuName = "NotSpecified"
	// IntegrationAccountSkuNameStandard ...
	IntegrationAccountSkuNameStandard IntegrationAccountSkuName = "Standard"
)

// PossibleIntegrationAccountSkuNameValues returns an array of possible values for the IntegrationAccountSkuName const type.
func PossibleIntegrationAccountSkuNameValues() []IntegrationAccountSkuName {
	return []IntegrationAccountSkuName{IntegrationAccountSkuNameFree, IntegrationAccountSkuNameNotSpecified, IntegrationAccountSkuNameStandard}
}

// KeyType enumerates the values for key type.
type KeyType string

const (
	// KeyTypeNotSpecified ...
	KeyTypeNotSpecified KeyType = "NotSpecified"
	// KeyTypePrimary ...
	KeyTypePrimary KeyType = "Primary"
	// KeyTypeSecondary ...
	KeyTypeSecondary KeyType = "Secondary"
)

// PossibleKeyTypeValues returns an array of possible values for the KeyType const type.
func PossibleKeyTypeValues() []KeyType {
	return []KeyType{KeyTypeNotSpecified, KeyTypePrimary, KeyTypeSecondary}
}

// MapType enumerates the values for map type.
type MapType string

const (
	// MapTypeNotSpecified ...
	MapTypeNotSpecified MapType = "NotSpecified"
	// MapTypeXslt ...
	MapTypeXslt MapType = "Xslt"
)

// PossibleMapTypeValues returns an array of possible values for the MapType const type.
func PossibleMapTypeValues() []MapType {
	return []MapType{MapTypeNotSpecified, MapTypeXslt}
}

// MessageEncoding enumerates the values for message encoding.
type MessageEncoding string

const (
	// MessageEncodingBase64 ...
	MessageEncodingBase64 MessageEncoding = "Base64"
	// MessageEncodingEightBit ...
	MessageEncodingEightBit MessageEncoding = "EightBit"
	// MessageEncodingNotSpecified ...
	MessageEncodingNotSpecified MessageEncoding = "NotSpecified"
	// MessageEncodingQuotedPrintable ...
	MessageEncodingQuotedPrintable MessageEncoding = "QuotedPrintable"
)

// PossibleMessageEncodingValues returns an array of possible values for the MessageEncoding const type.
func PossibleMessageEncodingValues() []MessageEncoding {
	return []MessageEncoding{MessageEncodingBase64, MessageEncodingEightBit, MessageEncodingNotSpecified, MessageEncodingQuotedPrintable}
}

// MessageFilterType enumerates the values for message filter type.
type MessageFilterType string

const (
	// MessageFilterTypeExclude ...
	MessageFilterTypeExclude MessageFilterType = "Exclude"
	// MessageFilterTypeInclude ...
	MessageFilterTypeInclude MessageFilterType = "Include"
	// MessageFilterTypeNotSpecified ...
	MessageFilterTypeNotSpecified MessageFilterType = "NotSpecified"
)

// PossibleMessageFilterTypeValues returns an array of possible values for the MessageFilterType const type.
func PossibleMessageFilterTypeValues() []MessageFilterType {
	return []MessageFilterType{MessageFilterTypeExclude, MessageFilterTypeInclude, MessageFilterTypeNotSpecified}
}

// ParameterType enumerates the values for parameter type.
type ParameterType string

const (
	// ParameterTypeArray ...
	ParameterTypeArray ParameterType = "Array"
	// ParameterTypeBool ...
	ParameterTypeBool ParameterType = "Bool"
	// ParameterTypeFloat ...
	ParameterTypeFloat ParameterType = "Float"
	// ParameterTypeInt ...
	ParameterTypeInt ParameterType = "Int"
	// ParameterTypeNotSpecified ...
	ParameterTypeNotSpecified ParameterType = "NotSpecified"
	// ParameterTypeObject ...
	ParameterTypeObject ParameterType = "Object"
	// ParameterTypeSecureObject ...
	ParameterTypeSecureObject ParameterType = "SecureObject"
	// ParameterTypeSecureString ...
	ParameterTypeSecureString ParameterType = "SecureString"
	// ParameterTypeString ...
	ParameterTypeString ParameterType = "String"
)

// PossibleParameterTypeValues returns an array of possible values for the ParameterType const type.
func PossibleParameterTypeValues() []ParameterType {
	return []ParameterType{ParameterTypeArray, ParameterTypeBool, ParameterTypeFloat, ParameterTypeInt, ParameterTypeNotSpecified, ParameterTypeObject, ParameterTypeSecureObject, ParameterTypeSecureString, ParameterTypeString}
}

// PartnerType enumerates the values for partner type.
type PartnerType string

const (
	// PartnerTypeB2B ...
	PartnerTypeB2B PartnerType = "B2B"
	// PartnerTypeNotSpecified ...
	PartnerTypeNotSpecified PartnerType = "NotSpecified"
)

// PossiblePartnerTypeValues returns an array of possible values for the PartnerType const type.
func PossiblePartnerTypeValues() []PartnerType {
	return []PartnerType{PartnerTypeB2B, PartnerTypeNotSpecified}
}

// RecurrenceFrequency enumerates the values for recurrence frequency.
type RecurrenceFrequency string

const (
	// RecurrenceFrequencyDay ...
	RecurrenceFrequencyDay RecurrenceFrequency = "Day"
	// RecurrenceFrequencyHour ...
	RecurrenceFrequencyHour RecurrenceFrequency = "Hour"
	// RecurrenceFrequencyMinute ...
	RecurrenceFrequencyMinute RecurrenceFrequency = "Minute"
	// RecurrenceFrequencyMonth ...
	RecurrenceFrequencyMonth RecurrenceFrequency = "Month"
	// RecurrenceFrequencyNotSpecified ...
	RecurrenceFrequencyNotSpecified RecurrenceFrequency = "NotSpecified"
	// RecurrenceFrequencySecond ...
	RecurrenceFrequencySecond RecurrenceFrequency = "Second"
	// RecurrenceFrequencyWeek ...
	RecurrenceFrequencyWeek RecurrenceFrequency = "Week"
	// RecurrenceFrequencyYear ...
	RecurrenceFrequencyYear RecurrenceFrequency = "Year"
)

// PossibleRecurrenceFrequencyValues returns an array of possible values for the RecurrenceFrequency const type.
func PossibleRecurrenceFrequencyValues() []RecurrenceFrequency {
	return []RecurrenceFrequency{RecurrenceFrequencyDay, RecurrenceFrequencyHour, RecurrenceFrequencyMinute, RecurrenceFrequencyMonth, RecurrenceFrequencyNotSpecified, RecurrenceFrequencySecond, RecurrenceFrequencyWeek, RecurrenceFrequencyYear}
}

// RosettaNetActionType enumerates the values for rosetta net action type.
type RosettaNetActionType string

const (
	// RosettaNetActionTypeDoubleAction ...
	RosettaNetActionTypeDoubleAction RosettaNetActionType = "DoubleAction"
	// RosettaNetActionTypeNotSpecified ...
	RosettaNetActionTypeNotSpecified RosettaNetActionType = "NotSpecified"
	// RosettaNetActionTypeSingleAction ...
	RosettaNetActionTypeSingleAction RosettaNetActionType = "SingleAction"
)

// PossibleRosettaNetActionTypeValues returns an array of possible values for the RosettaNetActionType const type.
func PossibleRosettaNetActionTypeValues() []RosettaNetActionType {
	return []RosettaNetActionType{RosettaNetActionTypeDoubleAction, RosettaNetActionTypeNotSpecified, RosettaNetActionTypeSingleAction}
}

// RosettaNetPipActivityType enumerates the values for rosetta net pip activity type.
type RosettaNetPipActivityType string

const (
	// RosettaNetPipActivityTypeBusinessTransaction ...
	RosettaNetPipActivityTypeBusinessTransaction RosettaNetPipActivityType = "BusinessTransaction"
	// RosettaNetPipActivityTypeInformationDistribution ...
	RosettaNetPipActivityTypeInformationDistribution RosettaNetPipActivityType = "InformationDistribution"
	// RosettaNetPipActivityTypeNotification ...
	RosettaNetPipActivityTypeNotification RosettaNetPipActivityType = "Notification"
	// RosettaNetPipActivityTypeNotSpecified ...
	RosettaNetPipActivityTypeNotSpecified RosettaNetPipActivityType = "NotSpecified"
	// RosettaNetPipActivityTypeQueryResponse ...
	RosettaNetPipActivityTypeQueryResponse RosettaNetPipActivityType = "QueryResponse"
	// RosettaNetPipActivityTypeRequestConfirm ...
	RosettaNetPipActivityTypeRequestConfirm RosettaNetPipActivityType = "RequestConfirm"
	// RosettaNetPipActivityTypeRequestResponse ...
	RosettaNetPipActivityTypeRequestResponse RosettaNetPipActivityType = "RequestResponse"
)

// PossibleRosettaNetPipActivityTypeValues returns an array of possible values for the RosettaNetPipActivityType const type.
func PossibleRosettaNetPipActivityTypeValues() []RosettaNetPipActivityType {
	return []RosettaNetPipActivityType{RosettaNetPipActivityTypeBusinessTransaction, RosettaNetPipActivityTypeInformationDistribution, RosettaNetPipActivityTypeNotification, RosettaNetPipActivityTypeNotSpecified, RosettaNetPipActivityTypeQueryResponse, RosettaNetPipActivityTypeRequestConfirm, RosettaNetPipActivityTypeRequestResponse}
}

// RosettaNetPipConfidentialityScope enumerates the values for rosetta net pip confidentiality scope.
type RosettaNetPipConfidentialityScope string

const (
	// RosettaNetPipConfidentialityScopeNone ...
	RosettaNetPipConfidentialityScopeNone RosettaNetPipConfidentialityScope = "None"
	// RosettaNetPipConfidentialityScopeNotSpecified ...
	RosettaNetPipConfidentialityScopeNotSpecified RosettaNetPipConfidentialityScope = "NotSpecified"
	// RosettaNetPipConfidentialityScopePayload ...
	RosettaNetPipConfidentialityScopePayload RosettaNetPipConfidentialityScope = "Payload"
	// RosettaNetPipConfidentialityScopePayloadContainer ...
	RosettaNetPipConfidentialityScopePayloadContainer RosettaNetPipConfidentialityScope = "PayloadContainer"
)

// PossibleRosettaNetPipConfidentialityScopeValues returns an array of possible values for the RosettaNetPipConfidentialityScope const type.
func PossibleRosettaNetPipConfidentialityScopeValues() []RosettaNetPipConfidentialityScope {
	return []RosettaNetPipConfidentialityScope{RosettaNetPipConfidentialityScopeNone, RosettaNetPipConfidentialityScopeNotSpecified, RosettaNetPipConfidentialityScopePayload, RosettaNetPipConfidentialityScopePayloadContainer}
}

// RosettaNetPipRoleType enumerates the values for rosetta net pip role type.
type RosettaNetPipRoleType string

const (
	// RosettaNetPipRoleTypeEmployee ...
	RosettaNetPipRoleTypeEmployee RosettaNetPipRoleType = "Employee"
	// RosettaNetPipRoleTypeFunctional ...
	RosettaNetPipRoleTypeFunctional RosettaNetPipRoleType = "Functional"
	// RosettaNetPipRoleTypeNotSpecified ...
	RosettaNetPipRoleTypeNotSpecified RosettaNetPipRoleType = "NotSpecified"
	// RosettaNetPipRoleTypeOrganizational ...
	RosettaNetPipRoleTypeOrganizational RosettaNetPipRoleType = "Organizational"
)

// PossibleRosettaNetPipRoleTypeValues returns an array of possible values for the RosettaNetPipRoleType const type.
func PossibleRosettaNetPipRoleTypeValues() []RosettaNetPipRoleType {
	return []RosettaNetPipRoleType{RosettaNetPipRoleTypeEmployee, RosettaNetPipRoleTypeFunctional, RosettaNetPipRoleTypeNotSpecified, RosettaNetPipRoleTypeOrganizational}
}

// RosettaNetResponseType enumerates the values for rosetta net response type.
type RosettaNetResponseType string

const (
	// RosettaNetResponseTypeAsync ...
	RosettaNetResponseTypeAsync RosettaNetResponseType = "Async"
	// RosettaNetResponseTypeNotSpecified ...
	RosettaNetResponseTypeNotSpecified RosettaNetResponseType = "NotSpecified"
	// RosettaNetResponseTypeSync ...
	RosettaNetResponseTypeSync RosettaNetResponseType = "Sync"
)

// PossibleRosettaNetResponseTypeValues returns an array of possible values for the RosettaNetResponseType const type.
func PossibleRosettaNetResponseTypeValues() []RosettaNetResponseType {
	return []RosettaNetResponseType{RosettaNetResponseTypeAsync, RosettaNetResponseTypeNotSpecified, RosettaNetResponseTypeSync}
}

// SchemaType enumerates the values for schema type.
type SchemaType string

const (
	// SchemaTypeNotSpecified ...
	SchemaTypeNotSpecified SchemaType = "NotSpecified"
	// SchemaTypeXML ...
	SchemaTypeXML SchemaType = "Xml"
)

// PossibleSchemaTypeValues returns an array of possible values for the SchemaType const type.
func PossibleSchemaTypeValues() []SchemaType {
	return []SchemaType{SchemaTypeNotSpecified, SchemaTypeXML}
}

// SegmentTerminatorSuffix enumerates the values for segment terminator suffix.
type SegmentTerminatorSuffix string

const (
	// SegmentTerminatorSuffixCR ...
	SegmentTerminatorSuffixCR SegmentTerminatorSuffix = "CR"
	// SegmentTerminatorSuffixCRLF ...
	SegmentTerminatorSuffixCRLF SegmentTerminatorSuffix = "CRLF"
	// SegmentTerminatorSuffixLF ...
	SegmentTerminatorSuffixLF SegmentTerminatorSuffix = "LF"
	// SegmentTerminatorSuffixNone ...
	SegmentTerminatorSuffixNone SegmentTerminatorSuffix = "None"
	// SegmentTerminatorSuffixNotSpecified ...
	SegmentTerminatorSuffixNotSpecified SegmentTerminatorSuffix = "NotSpecified"
)

// PossibleSegmentTerminatorSuffixValues returns an array of possible values for the SegmentTerminatorSuffix const type.
func PossibleSegmentTerminatorSuffixValues() []SegmentTerminatorSuffix {
	return []SegmentTerminatorSuffix{SegmentTerminatorSuffixCR, SegmentTerminatorSuffixCRLF, SegmentTerminatorSuffixLF, SegmentTerminatorSuffixNone, SegmentTerminatorSuffixNotSpecified}
}

// SigningAlgorithm enumerates the values for signing algorithm.
type SigningAlgorithm string

const (
	// SigningAlgorithmDefault ...
	SigningAlgorithmDefault SigningAlgorithm = "Default"
	// SigningAlgorithmNotSpecified ...
	SigningAlgorithmNotSpecified SigningAlgorithm = "NotSpecified"
	// SigningAlgorithmSHA1 ...
	SigningAlgorithmSHA1 SigningAlgorithm = "SHA1"
	// SigningAlgorithmSHA2256 ...
	SigningAlgorithmSHA2256 SigningAlgorithm = "SHA2256"
	// SigningAlgorithmSHA2384 ...
	SigningAlgorithmSHA2384 SigningAlgorithm = "SHA2384"
	// SigningAlgorithmSHA2512 ...
	SigningAlgorithmSHA2512 SigningAlgorithm = "SHA2512"
)

// PossibleSigningAlgorithmValues returns an array of possible values for the SigningAlgorithm const type.
func PossibleSigningAlgorithmValues() []SigningAlgorithm {
	return []SigningAlgorithm{SigningAlgorithmDefault, SigningAlgorithmNotSpecified, SigningAlgorithmSHA1, SigningAlgorithmSHA2256, SigningAlgorithmSHA2384, SigningAlgorithmSHA2512}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// SkuNameBasic ...
	SkuNameBasic SkuName = "Basic"
	// SkuNameFree ...
	SkuNameFree SkuName = "Free"
	// SkuNameNotSpecified ...
	SkuNameNotSpecified SkuName = "NotSpecified"
	// SkuNamePremium ...
	SkuNamePremium SkuName = "Premium"
	// SkuNameShared ...
	SkuNameShared SkuName = "Shared"
	// SkuNameStandard ...
	SkuNameStandard SkuName = "Standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{SkuNameBasic, SkuNameFree, SkuNameNotSpecified, SkuNamePremium, SkuNameShared, SkuNameStandard}
}

// TrackEventsOperationOptions enumerates the values for track events operation options.
type TrackEventsOperationOptions string

const (
	// DisableSourceInfoEnrich ...
	DisableSourceInfoEnrich TrackEventsOperationOptions = "DisableSourceInfoEnrich"
	// None ...
	None TrackEventsOperationOptions = "None"
)

// PossibleTrackEventsOperationOptionsValues returns an array of possible values for the TrackEventsOperationOptions const type.
func PossibleTrackEventsOperationOptionsValues() []TrackEventsOperationOptions {
	return []TrackEventsOperationOptions{DisableSourceInfoEnrich, None}
}

// TrackingRecordType enumerates the values for tracking record type.
type TrackingRecordType string

const (
	// TrackingRecordTypeAS2MDN ...
	TrackingRecordTypeAS2MDN TrackingRecordType = "AS2MDN"
	// TrackingRecordTypeAS2Message ...
	TrackingRecordTypeAS2Message TrackingRecordType = "AS2Message"
	// TrackingRecordTypeCustom ...
	TrackingRecordTypeCustom TrackingRecordType = "Custom"
	// TrackingRecordTypeEdifactFunctionalGroup ...
	TrackingRecordTypeEdifactFunctionalGroup TrackingRecordType = "EdifactFunctionalGroup"
	// TrackingRecordTypeEdifactFunctionalGroupAcknowledgment ...
	TrackingRecordTypeEdifactFunctionalGroupAcknowledgment TrackingRecordType = "EdifactFunctionalGroupAcknowledgment"
	// TrackingRecordTypeEdifactInterchange ...
	TrackingRecordTypeEdifactInterchange TrackingRecordType = "EdifactInterchange"
	// TrackingRecordTypeEdifactInterchangeAcknowledgment ...
	TrackingRecordTypeEdifactInterchangeAcknowledgment TrackingRecordType = "EdifactInterchangeAcknowledgment"
	// TrackingRecordTypeEdifactTransactionSet ...
	TrackingRecordTypeEdifactTransactionSet TrackingRecordType = "EdifactTransactionSet"
	// TrackingRecordTypeEdifactTransactionSetAcknowledgment ...
	TrackingRecordTypeEdifactTransactionSetAcknowledgment TrackingRecordType = "EdifactTransactionSetAcknowledgment"
	// TrackingRecordTypeNotSpecified ...
	TrackingRecordTypeNotSpecified TrackingRecordType = "NotSpecified"
	// TrackingRecordTypeX12FunctionalGroup ...
	TrackingRecordTypeX12FunctionalGroup TrackingRecordType = "X12FunctionalGroup"
	// TrackingRecordTypeX12FunctionalGroupAcknowledgment ...
	TrackingRecordTypeX12FunctionalGroupAcknowledgment TrackingRecordType = "X12FunctionalGroupAcknowledgment"
	// TrackingRecordTypeX12Interchange ...
	TrackingRecordTypeX12Interchange TrackingRecordType = "X12Interchange"
	// TrackingRecordTypeX12InterchangeAcknowledgment ...
	TrackingRecordTypeX12InterchangeAcknowledgment TrackingRecordType = "X12InterchangeAcknowledgment"
	// TrackingRecordTypeX12TransactionSet ...
	TrackingRecordTypeX12TransactionSet TrackingRecordType = "X12TransactionSet"
	// TrackingRecordTypeX12TransactionSetAcknowledgment ...
	TrackingRecordTypeX12TransactionSetAcknowledgment TrackingRecordType = "X12TransactionSetAcknowledgment"
)

// PossibleTrackingRecordTypeValues returns an array of possible values for the TrackingRecordType const type.
func PossibleTrackingRecordTypeValues() []TrackingRecordType {
	return []TrackingRecordType{TrackingRecordTypeAS2MDN, TrackingRecordTypeAS2Message, TrackingRecordTypeCustom, TrackingRecordTypeEdifactFunctionalGroup, TrackingRecordTypeEdifactFunctionalGroupAcknowledgment, TrackingRecordTypeEdifactInterchange, TrackingRecordTypeEdifactInterchangeAcknowledgment, TrackingRecordTypeEdifactTransactionSet, TrackingRecordTypeEdifactTransactionSetAcknowledgment, TrackingRecordTypeNotSpecified, TrackingRecordTypeX12FunctionalGroup, TrackingRecordTypeX12FunctionalGroupAcknowledgment, TrackingRecordTypeX12Interchange, TrackingRecordTypeX12InterchangeAcknowledgment, TrackingRecordTypeX12TransactionSet, TrackingRecordTypeX12TransactionSetAcknowledgment}
}

// TrailingSeparatorPolicy enumerates the values for trailing separator policy.
type TrailingSeparatorPolicy string

const (
	// TrailingSeparatorPolicyMandatory ...
	TrailingSeparatorPolicyMandatory TrailingSeparatorPolicy = "Mandatory"
	// TrailingSeparatorPolicyNotAllowed ...
	TrailingSeparatorPolicyNotAllowed TrailingSeparatorPolicy = "NotAllowed"
	// TrailingSeparatorPolicyNotSpecified ...
	TrailingSeparatorPolicyNotSpecified TrailingSeparatorPolicy = "NotSpecified"
	// TrailingSeparatorPolicyOptional ...
	TrailingSeparatorPolicyOptional TrailingSeparatorPolicy = "Optional"
)

// PossibleTrailingSeparatorPolicyValues returns an array of possible values for the TrailingSeparatorPolicy const type.
func PossibleTrailingSeparatorPolicyValues() []TrailingSeparatorPolicy {
	return []TrailingSeparatorPolicy{TrailingSeparatorPolicyMandatory, TrailingSeparatorPolicyNotAllowed, TrailingSeparatorPolicyNotSpecified, TrailingSeparatorPolicyOptional}
}

// UsageIndicator enumerates the values for usage indicator.
type UsageIndicator string

const (
	// UsageIndicatorInformation ...
	UsageIndicatorInformation UsageIndicator = "Information"
	// UsageIndicatorNotSpecified ...
	UsageIndicatorNotSpecified UsageIndicator = "NotSpecified"
	// UsageIndicatorProduction ...
	UsageIndicatorProduction UsageIndicator = "Production"
	// UsageIndicatorTest ...
	UsageIndicatorTest UsageIndicator = "Test"
)

// PossibleUsageIndicatorValues returns an array of possible values for the UsageIndicator const type.
func PossibleUsageIndicatorValues() []UsageIndicator {
	return []UsageIndicator{UsageIndicatorInformation, UsageIndicatorNotSpecified, UsageIndicatorProduction, UsageIndicatorTest}
}

// WorkflowProvisioningState enumerates the values for workflow provisioning state.
type WorkflowProvisioningState string

const (
	// WorkflowProvisioningStateAccepted ...
	WorkflowProvisioningStateAccepted WorkflowProvisioningState = "Accepted"
	// WorkflowProvisioningStateCanceled ...
	WorkflowProvisioningStateCanceled WorkflowProvisioningState = "Canceled"
	// WorkflowProvisioningStateCompleted ...
	WorkflowProvisioningStateCompleted WorkflowProvisioningState = "Completed"
	// WorkflowProvisioningStateCreated ...
	WorkflowProvisioningStateCreated WorkflowProvisioningState = "Created"
	// WorkflowProvisioningStateCreating ...
	WorkflowProvisioningStateCreating WorkflowProvisioningState = "Creating"
	// WorkflowProvisioningStateDeleted ...
	WorkflowProvisioningStateDeleted WorkflowProvisioningState = "Deleted"
	// WorkflowProvisioningStateDeleting ...
	WorkflowProvisioningStateDeleting WorkflowProvisioningState = "Deleting"
	// WorkflowProvisioningStateFailed ...
	WorkflowProvisioningStateFailed WorkflowProvisioningState = "Failed"
	// WorkflowProvisioningStateMoving ...
	WorkflowProvisioningStateMoving WorkflowProvisioningState = "Moving"
	// WorkflowProvisioningStateNotSpecified ...
	WorkflowProvisioningStateNotSpecified WorkflowProvisioningState = "NotSpecified"
	// WorkflowProvisioningStateReady ...
	WorkflowProvisioningStateReady WorkflowProvisioningState = "Ready"
	// WorkflowProvisioningStateRegistered ...
	WorkflowProvisioningStateRegistered WorkflowProvisioningState = "Registered"
	// WorkflowProvisioningStateRegistering ...
	WorkflowProvisioningStateRegistering WorkflowProvisioningState = "Registering"
	// WorkflowProvisioningStateRunning ...
	WorkflowProvisioningStateRunning WorkflowProvisioningState = "Running"
	// WorkflowProvisioningStateSucceeded ...
	WorkflowProvisioningStateSucceeded WorkflowProvisioningState = "Succeeded"
	// WorkflowProvisioningStateUnregistered ...
	WorkflowProvisioningStateUnregistered WorkflowProvisioningState = "Unregistered"
	// WorkflowProvisioningStateUnregistering ...
	WorkflowProvisioningStateUnregistering WorkflowProvisioningState = "Unregistering"
	// WorkflowProvisioningStateUpdating ...
	WorkflowProvisioningStateUpdating WorkflowProvisioningState = "Updating"
)

// PossibleWorkflowProvisioningStateValues returns an array of possible values for the WorkflowProvisioningState const type.
func PossibleWorkflowProvisioningStateValues() []WorkflowProvisioningState {
	return []WorkflowProvisioningState{WorkflowProvisioningStateAccepted, WorkflowProvisioningStateCanceled, WorkflowProvisioningStateCompleted, WorkflowProvisioningStateCreated, WorkflowProvisioningStateCreating, WorkflowProvisioningStateDeleted, WorkflowProvisioningStateDeleting, WorkflowProvisioningStateFailed, WorkflowProvisioningStateMoving, WorkflowProvisioningStateNotSpecified, WorkflowProvisioningStateReady, WorkflowProvisioningStateRegistered, WorkflowProvisioningStateRegistering, WorkflowProvisioningStateRunning, WorkflowProvisioningStateSucceeded, WorkflowProvisioningStateUnregistered, WorkflowProvisioningStateUnregistering, WorkflowProvisioningStateUpdating}
}

// WorkflowState enumerates the values for workflow state.
type WorkflowState string

const (
	// WorkflowStateCompleted ...
	WorkflowStateCompleted WorkflowState = "Completed"
	// WorkflowStateDeleted ...
	WorkflowStateDeleted WorkflowState = "Deleted"
	// WorkflowStateDisabled ...
	WorkflowStateDisabled WorkflowState = "Disabled"
	// WorkflowStateEnabled ...
	WorkflowStateEnabled WorkflowState = "Enabled"
	// WorkflowStateNotSpecified ...
	WorkflowStateNotSpecified WorkflowState = "NotSpecified"
	// WorkflowStateSuspended ...
	WorkflowStateSuspended WorkflowState = "Suspended"
)

// PossibleWorkflowStateValues returns an array of possible values for the WorkflowState const type.
func PossibleWorkflowStateValues() []WorkflowState {
	return []WorkflowState{WorkflowStateCompleted, WorkflowStateDeleted, WorkflowStateDisabled, WorkflowStateEnabled, WorkflowStateNotSpecified, WorkflowStateSuspended}
}

// WorkflowStatus enumerates the values for workflow status.
type WorkflowStatus string

const (
	// WorkflowStatusAborted ...
	WorkflowStatusAborted WorkflowStatus = "Aborted"
	// WorkflowStatusCancelled ...
	WorkflowStatusCancelled WorkflowStatus = "Cancelled"
	// WorkflowStatusFailed ...
	WorkflowStatusFailed WorkflowStatus = "Failed"
	// WorkflowStatusFaulted ...
	WorkflowStatusFaulted WorkflowStatus = "Faulted"
	// WorkflowStatusIgnored ...
	WorkflowStatusIgnored WorkflowStatus = "Ignored"
	// WorkflowStatusNotSpecified ...
	WorkflowStatusNotSpecified WorkflowStatus = "NotSpecified"
	// WorkflowStatusPaused ...
	WorkflowStatusPaused WorkflowStatus = "Paused"
	// WorkflowStatusRunning ...
	WorkflowStatusRunning WorkflowStatus = "Running"
	// WorkflowStatusSkipped ...
	WorkflowStatusSkipped WorkflowStatus = "Skipped"
	// WorkflowStatusSucceeded ...
	WorkflowStatusSucceeded WorkflowStatus = "Succeeded"
	// WorkflowStatusSuspended ...
	WorkflowStatusSuspended WorkflowStatus = "Suspended"
	// WorkflowStatusTimedOut ...
	WorkflowStatusTimedOut WorkflowStatus = "TimedOut"
	// WorkflowStatusWaiting ...
	WorkflowStatusWaiting WorkflowStatus = "Waiting"
)

// PossibleWorkflowStatusValues returns an array of possible values for the WorkflowStatus const type.
func PossibleWorkflowStatusValues() []WorkflowStatus {
	return []WorkflowStatus{WorkflowStatusAborted, WorkflowStatusCancelled, WorkflowStatusFailed, WorkflowStatusFaulted, WorkflowStatusIgnored, WorkflowStatusNotSpecified, WorkflowStatusPaused, WorkflowStatusRunning, WorkflowStatusSkipped, WorkflowStatusSucceeded, WorkflowStatusSuspended, WorkflowStatusTimedOut, WorkflowStatusWaiting}
}

// WorkflowTriggerProvisioningState enumerates the values for workflow trigger provisioning state.
type WorkflowTriggerProvisioningState string

const (
	// WorkflowTriggerProvisioningStateAccepted ...
	WorkflowTriggerProvisioningStateAccepted WorkflowTriggerProvisioningState = "Accepted"
	// WorkflowTriggerProvisioningStateCanceled ...
	WorkflowTriggerProvisioningStateCanceled WorkflowTriggerProvisioningState = "Canceled"
	// WorkflowTriggerProvisioningStateCompleted ...
	WorkflowTriggerProvisioningStateCompleted WorkflowTriggerProvisioningState = "Completed"
	// WorkflowTriggerProvisioningStateCreated ...
	WorkflowTriggerProvisioningStateCreated WorkflowTriggerProvisioningState = "Created"
	// WorkflowTriggerProvisioningStateCreating ...
	WorkflowTriggerProvisioningStateCreating WorkflowTriggerProvisioningState = "Creating"
	// WorkflowTriggerProvisioningStateDeleted ...
	WorkflowTriggerProvisioningStateDeleted WorkflowTriggerProvisioningState = "Deleted"
	// WorkflowTriggerProvisioningStateDeleting ...
	WorkflowTriggerProvisioningStateDeleting WorkflowTriggerProvisioningState = "Deleting"
	// WorkflowTriggerProvisioningStateFailed ...
	WorkflowTriggerProvisioningStateFailed WorkflowTriggerProvisioningState = "Failed"
	// WorkflowTriggerProvisioningStateMoving ...
	WorkflowTriggerProvisioningStateMoving WorkflowTriggerProvisioningState = "Moving"
	// WorkflowTriggerProvisioningStateNotSpecified ...
	WorkflowTriggerProvisioningStateNotSpecified WorkflowTriggerProvisioningState = "NotSpecified"
	// WorkflowTriggerProvisioningStateReady ...
	WorkflowTriggerProvisioningStateReady WorkflowTriggerProvisioningState = "Ready"
	// WorkflowTriggerProvisioningStateRegistered ...
	WorkflowTriggerProvisioningStateRegistered WorkflowTriggerProvisioningState = "Registered"
	// WorkflowTriggerProvisioningStateRegistering ...
	WorkflowTriggerProvisioningStateRegistering WorkflowTriggerProvisioningState = "Registering"
	// WorkflowTriggerProvisioningStateRunning ...
	WorkflowTriggerProvisioningStateRunning WorkflowTriggerProvisioningState = "Running"
	// WorkflowTriggerProvisioningStateSucceeded ...
	WorkflowTriggerProvisioningStateSucceeded WorkflowTriggerProvisioningState = "Succeeded"
	// WorkflowTriggerProvisioningStateUnregistered ...
	WorkflowTriggerProvisioningStateUnregistered WorkflowTriggerProvisioningState = "Unregistered"
	// WorkflowTriggerProvisioningStateUnregistering ...
	WorkflowTriggerProvisioningStateUnregistering WorkflowTriggerProvisioningState = "Unregistering"
	// WorkflowTriggerProvisioningStateUpdating ...
	WorkflowTriggerProvisioningStateUpdating WorkflowTriggerProvisioningState = "Updating"
)

// PossibleWorkflowTriggerProvisioningStateValues returns an array of possible values for the WorkflowTriggerProvisioningState const type.
func PossibleWorkflowTriggerProvisioningStateValues() []WorkflowTriggerProvisioningState {
	return []WorkflowTriggerProvisioningState{WorkflowTriggerProvisioningStateAccepted, WorkflowTriggerProvisioningStateCanceled, WorkflowTriggerProvisioningStateCompleted, WorkflowTriggerProvisioningStateCreated, WorkflowTriggerProvisioningStateCreating, WorkflowTriggerProvisioningStateDeleted, WorkflowTriggerProvisioningStateDeleting, WorkflowTriggerProvisioningStateFailed, WorkflowTriggerProvisioningStateMoving, WorkflowTriggerProvisioningStateNotSpecified, WorkflowTriggerProvisioningStateReady, WorkflowTriggerProvisioningStateRegistered, WorkflowTriggerProvisioningStateRegistering, WorkflowTriggerProvisioningStateRunning, WorkflowTriggerProvisioningStateSucceeded, WorkflowTriggerProvisioningStateUnregistered, WorkflowTriggerProvisioningStateUnregistering, WorkflowTriggerProvisioningStateUpdating}
}

// X12CharacterSet enumerates the values for x12 character set.
type X12CharacterSet string

const (
	// X12CharacterSetBasic ...
	X12CharacterSetBasic X12CharacterSet = "Basic"
	// X12CharacterSetExtended ...
	X12CharacterSetExtended X12CharacterSet = "Extended"
	// X12CharacterSetNotSpecified ...
	X12CharacterSetNotSpecified X12CharacterSet = "NotSpecified"
	// X12CharacterSetUTF8 ...
	X12CharacterSetUTF8 X12CharacterSet = "UTF8"
)

// PossibleX12CharacterSetValues returns an array of possible values for the X12CharacterSet const type.
func PossibleX12CharacterSetValues() []X12CharacterSet {
	return []X12CharacterSet{X12CharacterSetBasic, X12CharacterSetExtended, X12CharacterSetNotSpecified, X12CharacterSetUTF8}
}

// X12DateFormat enumerates the values for x12 date format.
type X12DateFormat string

const (
	// X12DateFormatCCYYMMDD ...
	X12DateFormatCCYYMMDD X12DateFormat = "CCYYMMDD"
	// X12DateFormatNotSpecified ...
	X12DateFormatNotSpecified X12DateFormat = "NotSpecified"
	// X12DateFormatYYMMDD ...
	X12DateFormatYYMMDD X12DateFormat = "YYMMDD"
)

// PossibleX12DateFormatValues returns an array of possible values for the X12DateFormat const type.
func PossibleX12DateFormatValues() []X12DateFormat {
	return []X12DateFormat{X12DateFormatCCYYMMDD, X12DateFormatNotSpecified, X12DateFormatYYMMDD}
}

// X12TimeFormat enumerates the values for x12 time format.
type X12TimeFormat string

const (
	// X12TimeFormatHHMM ...
	X12TimeFormatHHMM X12TimeFormat = "HHMM"
	// X12TimeFormatHHMMSS ...
	X12TimeFormatHHMMSS X12TimeFormat = "HHMMSS"
	// X12TimeFormatHHMMSSd ...
	X12TimeFormatHHMMSSd X12TimeFormat = "HHMMSSd"
	// X12TimeFormatHHMMSSdd ...
	X12TimeFormatHHMMSSdd X12TimeFormat = "HHMMSSdd"
	// X12TimeFormatNotSpecified ...
	X12TimeFormatNotSpecified X12TimeFormat = "NotSpecified"
)

// PossibleX12TimeFormatValues returns an array of possible values for the X12TimeFormat const type.
func PossibleX12TimeFormatValues() []X12TimeFormat {
	return []X12TimeFormat{X12TimeFormatHHMM, X12TimeFormatHHMMSS, X12TimeFormatHHMMSSd, X12TimeFormatHHMMSSdd, X12TimeFormatNotSpecified}
}
