/*
 * Decompiled with CFR 0.152.
 */
package driftwood.gui;

import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class ExpSlider
extends JSlider {
    private double minVal;
    private double maxVal;
    private int steps;
    private double q;

    public ExpSlider(double d, double d2, int n) {
        super(0, n, n / 2);
        this.minVal = d;
        this.maxVal = d2;
        this.steps = n;
        this.q = (double)n / Math.log(d2 / d);
    }

    public double getDouble() {
        return this.getDouble(this.getValue());
    }

    protected double getDouble(int n) {
        if (n == 0) {
            return this.minVal;
        }
        if (n == this.steps) {
            return this.maxVal;
        }
        return this.minVal * Math.exp((double)n / this.q);
    }

    public void setDouble(double d) {
        if (d < this.minVal) {
            d = this.minVal;
        } else if (d > this.maxVal) {
            d = this.maxVal;
        }
        int n = (int)Math.round(this.q * Math.log(d / this.minVal));
        if (n < 0) {
            n = 0;
        } else if (n > this.steps) {
            n = this.steps;
        }
        this.setValue(n);
    }

    public void setLabels(int n, NumberFormat numberFormat) {
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        if (n < 2) {
            hashtable.put(new Integer(this.steps / 2), new JLabel(numberFormat.format(this.getDouble(this.steps / 2))));
        } else {
            for (double d = 0.0; d < (double)n; d += 1.0) {
                int n2 = (int)Math.round(d / (double)(n - 1) * (double)this.steps);
                hashtable.put(new Integer(n2), new JLabel(numberFormat.format(this.getDouble(n2))));
            }
        }
        this.setLabelTable(hashtable);
        this.setPaintLabels(true);
    }
}

