/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.gui.SuffixFileFilter;
import driftwood.moldb2.CoordinateFile;
import driftwood.util.SoftLog;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import molikin.Quickin;
import molikin.logic.Logic;
import molikin.logic.RibbonLogic;

public class Cmdliner {
    int kinNumber = 1;
    SuffixFileFilter pdbFilter;
    SuffixFileFilter cifFilter;
    SuffixFileFilter allFilter;
    ArrayList<File> filesToOpen;
    ArrayList<Logic> logics;
    int numModels = -1;

    public Cmdliner() {
        this.buildFileChooser();
    }

    private void buildFileChooser() {
        this.allFilter = new SuffixFileFilter("PDB and mmCIF files");
        this.allFilter.addSuffix(".pdb");
        this.allFilter.addSuffix(".xyz");
        this.allFilter.addSuffix(".ent");
        this.allFilter.addSuffix(".cif");
        this.allFilter.addSuffix(".mmcif");
        this.allFilter.addSuffix(".pdb.gz");
        this.allFilter.addSuffix(".xyz.gz");
        this.allFilter.addSuffix(".ent.gz");
        this.allFilter.addSuffix(".cif.gz");
        this.allFilter.addSuffix(".mmcif.gz");
        this.pdbFilter = new SuffixFileFilter("Protein Data Bank (PDB) files");
        this.pdbFilter.addSuffix(".pdb");
        this.pdbFilter.addSuffix(".xyz");
        this.pdbFilter.addSuffix(".ent");
        this.pdbFilter.addSuffix(".pdb.gz");
        this.pdbFilter.addSuffix(".xyz.gz");
        this.pdbFilter.addSuffix(".ent.gz");
        this.cifFilter = new SuffixFileFilter("mmCIF files");
        this.cifFilter.addSuffix(".cif");
        this.cifFilter.addSuffix(".mmcif");
        this.cifFilter.addSuffix(".cif.gz");
        this.cifFilter.addSuffix(".mmcif.gz");
    }

    public void onOpenFiles() {
        for (File file : this.filesToOpen) {
            try {
                Logic[] logicArray;
                CoordinateFile coordinateFile = null;
                coordinateFile = this.cifFilter.accept(file) ? Quickin.readCIF(file) : Quickin.readPDB(file);
                if (coordinateFile == null) continue;
                if (this.logics != null && this.logics.size() > 0) {
                    logicArray = new Logic[this.logics.size()];
                    int n = 0;
                    for (Logic logic : this.logics) {
                        if (logic instanceof RibbonLogic) {
                            ((RibbonLogic)logic).secondaryStructure = coordinateFile.getSecondaryStructure();
                        }
                        logicArray[n] = logic;
                        ++n;
                    }
                } else {
                    logicArray = new Logic[]{Quickin.getLotsLogic(), Quickin.getRibbonLogic()};
                    ((RibbonLogic)logicArray[1]).secondaryStructure = coordinateFile.getSecondaryStructure();
                }
                this.buildKinemage(coordinateFile, logicArray);
            }
            catch (IOException iOException) {
                System.err.println("An I/O error occurred while loading the file:\n" + iOException.getMessage());
                iOException.printStackTrace(SoftLog.err);
            }
        }
    }

    void buildKinemage(CoordinateFile coordinateFile, Logic logic) {
        this.buildKinemage(coordinateFile, new Logic[]{logic});
    }

    void buildKinemage(CoordinateFile coordinateFile, Logic[] logicArray) {
        System.out.println("@kinemage " + this.kinNumber++);
        System.out.println("@onewidth");
        PrintWriter printWriter = new PrintWriter(System.out);
        if (this.numModels == -1) {
            Quickin.printKinemage(printWriter, coordinateFile, logicArray);
        } else {
            Quickin.printKinemage(printWriter, coordinateFile, logicArray, this.numModels);
        }
        printWriter.flush();
        printWriter.close();
        coordinateFile = null;
    }

    public static void main(String[] stringArray) {
        new Cmdliner().Main(stringArray);
    }

    public void Main(String[] stringArray) {
        this.parseArguments(stringArray);
        this.onOpenFiles();
    }

    void parseArguments(String[] stringArray) {
        this.filesToOpen = new ArrayList();
        this.logics = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.equals("-h") || string.equals("-help")) {
                    SoftLog.err.println("Help not available. Sorry!");
                    System.exit(0);
                    continue;
                }
                if (string.equals("-l") || string.equals("-lots")) {
                    this.logics.add(Quickin.getLotsLogic());
                    continue;
                }
                if (string.equals("-r") || string.equals("-ribbons")) {
                    this.logics.add(Quickin.getRibbonLogic());
                    continue;
                }
                if (string.equals("-single")) {
                    this.numModels = 1;
                    continue;
                }
                System.err.println("*** Unrecognized option: " + string);
                continue;
            }
            this.filesToOpen.add(new File(string));
        }
    }
}

