/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.ModelingTool;
import chiropraxis.kingtools.PeptideTwister2;
import chiropraxis.kingtools.Remodeler;
import chiropraxis.mc.CaRotation;
import chiropraxis.rotarama.Ramachandran;
import chiropraxis.rotarama.TauByPhiPsi;
import driftwood.gui.AngleDial;
import driftwood.gui.ReflectiveAction;
import driftwood.gui.TablePane;
import driftwood.moldb2.AminoAcid;
import driftwood.moldb2.Atom;
import driftwood.moldb2.AtomException;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.ModelState;
import driftwood.moldb2.Residue;
import driftwood.moldb2.ResidueException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import king.ToolBox;
import king.core.AHE;
import king.core.KList;
import king.core.KPalette;
import king.core.KPoint;
import king.points.BallPoint;

public class HingeTool
extends ModelingTool
implements Remodeler,
ChangeListener {
    static final DecimalFormat df1 = new DecimalFormat("+0.0;-0.0");
    static final DecimalFormat df0 = new DecimalFormat("0");
    static final Color normalColor = new Color(0.0f, 0.0f, 0.0f);
    static final Color alertColor = new Color(0.6f, 0.0f, 0.0f);
    Residue anchor1 = null;
    Residue anchor2 = null;
    PeptideTwister2 twister = null;
    KList anchorList = new KList("ball");
    Ramachandran rama = null;
    TauByPhiPsi tauscorer = null;
    JPanel tabwrapper;
    JTabbedPane tabpane;
    TablePane toolpane;
    AngleDial hingeDial;
    JLabel[] headerLabels;
    JLabel[] res1Labels;
    JLabel[] res2Labels;
    JCheckBox cbIdealizeSC;

    public HingeTool(ToolBox toolBox) {
        super(toolBox);
        this.buildGUI();
    }

    private void buildGUI() {
        this.hingeDial = new AngleDial();
        this.hingeDial.addChangeListener(this);
        JButton jButton = new JButton(new ReflectiveAction("Release", null, this, "onReleaseResidues"));
        this.headerLabels = new JLabel[]{new JLabel("Residue"), new JLabel("Tau dev"), new JLabel("Karplus"), new JLabel("Ramachdrn"), new JLabel("phi,psi")};
        this.res1Labels = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
        this.res2Labels = new JLabel[]{new JLabel(), new JLabel(), new JLabel(), new JLabel(), new JLabel()};
        this.cbIdealizeSC = new JCheckBox(new ReflectiveAction("Idealize end sidechains", null, this, "onToggleIdealSC"));
        this.cbIdealizeSC.setSelected(true);
        this.toolpane = new TablePane();
        this.toolpane.startSubtable();
        this.toolpane.save().hfill(true).vfill(true).addCell(this.hingeDial).restore();
        this.toolpane.save().center().middle();
        this.toolpane.addCell(jButton);
        this.toolpane.restore();
        this.toolpane.newRow();
        this.toolpane.addCell(this.cbIdealizeSC, 2, 1);
        this.toolpane.newRow();
        this.toolpane.save().hfill(true).startSubtable(2, 1);
        this.toolpane.hfill(true).insets(1, 3, 1, 3);
        for (int i = 0; i < this.headerLabels.length; ++i) {
            this.toolpane.add(this.headerLabels[i]);
            this.toolpane.add(this.res1Labels[i]);
            this.toolpane.add(this.res2Labels[i]);
            this.toolpane.newRow();
        }
        this.toolpane.endSubtable().restore();
        this.toolpane.endSubtable();
        this.tabpane = new JTabbedPane();
        this.tabpane.addTab("Hinges", this.toolpane);
        this.tabwrapper = new JPanel(new BorderLayout());
        this.tabwrapper.add(this.tabpane);
    }

    protected void initDialog() {
        super.initDialog();
        this.buildMenus();
        this.dialog.pack();
    }

    private void buildMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenuBar.add(jMenu);
        jMenu.add(this.getHelpMenuItem());
        this.dialog.setJMenuBar(jMenuBar);
    }

    protected Container getToolPanel() {
        return this.tabwrapper;
    }

    public String getHelpAnchor() {
        return "#hinges-tool";
    }

    public String toString() {
        return "C-alpha hinges";
    }

    public void start() {
        super.start();
        try {
            this.rama = Ramachandran.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.tauscorer = TauByPhiPsi.getInstance();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.anchorList.setColor(KPalette.peach);
        this.modelman.onShowDialog(null);
        this.services.setID("Ctrl-click, option-click, or middle-click the two hinge endpoints");
        this.kCanvas.repaint();
    }

    public void c_click(int n, int n2, KPoint kPoint, MouseEvent mouseEvent) {
        if (kPoint == null || this.anchor1 != null && this.anchor2 != null) {
            this.onReleaseResidues(null);
        } else if (kPoint != null) {
            ModelState modelState = this.modelman.getMoltenState();
            Residue residue = this.getResidueNearest(this.modelman.getModel(), modelState, kPoint.getX(), kPoint.getY(), kPoint.getZ());
            if (this.anchor1 == null) {
                this.anchor1 = residue;
                this.markAnchor(residue, modelState);
                this.updateLabels();
            } else if (this.anchor2 == null) {
                this.anchor2 = residue;
                this.markAnchor(residue, modelState);
                this.grabResidues();
            }
        }
    }

    void markAnchor(Residue residue, ModelState modelState) {
        Atom atom = residue.getAtom(" CA ");
        if (atom == null) {
            return;
        }
        try {
            AtomState atomState = modelState.get(atom);
            BallPoint ballPoint = new BallPoint("C-alpha axis endpoint");
            ballPoint.r0 = 0.3f;
            ballPoint.setX(atomState.getX());
            ballPoint.setY(atomState.getY());
            ballPoint.setZ(atomState.getZ());
            this.anchorList.add((AHE)ballPoint);
            this.kCanvas.repaint();
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
        }
    }

    public void wheel(int n, MouseEvent mouseEvent) {
        this.hingeDial.setDegrees(this.hingeDial.getDegrees() - (double)n);
    }

    public void c_wheel(int n, MouseEvent mouseEvent) {
        super.wheel(n, mouseEvent);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.modelman.requestStateRefresh();
        this.updateLabels();
        if (this.twister != null) {
            this.twister.updateLabels();
        }
        this.kCanvas.repaint();
    }

    public ModelState updateModelState(ModelState modelState) {
        try {
            Collection collection = CaRotation.makeMobileGroup(this.modelman.getModel(), this.anchor1, this.anchor2);
            ModelState modelState2 = CaRotation.makeConformation(collection, modelState, this.hingeDial.getDegrees(), this.cbIdealizeSC.isSelected());
            if (this.twister != null) {
                modelState2 = this.twister.updateConformation(modelState2);
            }
            return modelState2;
        }
        catch (AtomException atomException) {
            atomException.printStackTrace();
            return modelState;
        }
    }

    public void onToggleIdealSC(ActionEvent actionEvent) {
        this.stateChanged(null);
    }

    void updateLabels() {
        this.updateLabels(this.anchor1, this.res1Labels);
        this.updateLabels(this.anchor2, this.res2Labels);
    }

    /*
     * Unable to fully structure code
     */
    void updateLabels(Residue var1_1, JLabel[] var2_2) {
        for (var3_3 = 0; var3_3 < var2_2.length; ++var3_3) {
            var2_2[var3_3].setForeground(HingeTool.normalColor);
        }
        if (var1_1 == null) {
            for (var3_3 = 0; var3_3 < var2_2.length; ++var3_3) {
                var2_2[var3_3].setText("");
            }
        } else {
            var2_2[0].setText(var1_1.toString());
            var3_4 = this.modelman.getModel();
            var4_5 = this.modelman.getMoltenState();
            try {
                var5_6 = AminoAcid.getTauDeviation(var1_1, var4_5);
                var2_2[1].setText(HingeTool.df1.format(var5_6));
                if (Math.abs(var5_6) >= 3.0) {
                    var2_2[1].setForeground(HingeTool.alertColor);
                }
            }
            catch (AtomException var5_7) {
                var2_2[1].setText("-?-");
            }
            try {
                var5_6 = AminoAcid.getPhi(var3_4, var1_1, var4_5);
                var7_10 = AminoAcid.getPsi(var3_4, var1_1, var4_5);
                var2_2[4].setText(HingeTool.df0.format(var5_6) + " , " + HingeTool.df0.format(var7_10));
                if (this.rama == null) {
                    var2_2[3].setText("[no data]");
                } else if (this.rama.isOutlier(var3_4, var1_1, var4_5)) {
                    var2_2[3].setText("OUTLIER");
                    var2_2[3].setForeground(HingeTool.alertColor);
                } else if (this.rama.rawScore(var3_4, var1_1, var4_5) > 0.02) {
                    var2_2[3].setText("favored");
                } else {
                    var2_2[3].setText("allowed");
                }
                if (this.tauscorer == null) {
                    var2_2[2].setText("[no data]");
                }
                var9_11 = this.tauscorer.getTauDeviation(var3_4, var1_1, var4_5);
                var2_2[2].setText(HingeTool.df1.format(var9_11));
                if (!(Math.abs(var9_11) >= 3.0)) ** GOTO lbl52
                var2_2[2].setForeground(HingeTool.alertColor);
            }
            catch (AtomException var5_8) {
                var2_2[2].setText("-?-");
                var2_2[3].setText("[no phi,psi]");
                var2_2[4].setText("? , ?");
            }
            catch (ResidueException var5_9) {
                var2_2[2].setText("-?-");
                var2_2[3].setText("[no phi,psi]");
                var2_2[4].setText("? , ?");
            }
        }
lbl52:
        // 6 sources

        this.dialog.pack();
    }

    void grabResidues() {
        Object object;
        if (this.anchor1 == null || this.anchor2 == null) {
            return;
        }
        this.hingeDial.setDegrees(0.0);
        if (this.anchor1.compareTo(this.anchor2) > 0) {
            object = this.anchor1;
            this.anchor1 = this.anchor2;
            this.anchor2 = object;
        }
        try {
            object = CaRotation.makeMobileGroup(this.modelman.getModel(), this.anchor1, this.anchor2);
            this.modelman.registerTool(this, (Collection)object);
            this.twister = new PeptideTwister2(this, (Collection)object);
            Dimension dimension = this.twister.getPreferredSize();
            if (dimension.getWidth() <= 500.0) {
                this.tabpane.insertTab("Peptides", null, this.twister, null, 1);
            } else {
                JScrollPane jScrollPane = new JScrollPane(this.twister, 21, 30);
                dimension.setSize(500.0, dimension.getHeight() + 50.0);
                jScrollPane.setPreferredSize(dimension);
                this.tabpane.insertTab("Peptides", null, jScrollPane, null, 1);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this.kMain.getTopWindow(), this.anchor1 + " and " + this.anchor2 + "\nare not part of the same chain.\nPlease try again.", "Sorry!", 0);
            this.anchor2 = null;
            this.anchor1 = null;
            this.anchorList.clear();
        }
        this.stateChanged(null);
    }

    public void onReleaseResidues(ActionEvent actionEvent) {
        if (this.anchor1 == null || this.anchor2 == null) {
            this.anchor2 = null;
            this.anchor1 = null;
            this.anchorList.clear();
            this.updateLabels();
            this.kCanvas.repaint();
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.kMain.getTopWindow(), "Do you want to keep the changes\nyou've made to these residues?", "Keep changes?", 1, 3);
        if (n == 2) {
            return;
        }
        if (n == 0) {
            this.modelman.requestStateChange(this);
        } else {
            this.modelman.unregisterTool(this);
        }
        this.anchor2 = null;
        this.anchor1 = null;
        this.anchorList.clear();
        this.tabpane.removeTabAt(1);
        this.twister = null;
        this.updateLabels();
        this.kCanvas.repaint();
    }
}

