/*
 * Decompiled with CFR 0.152.
 */
package chiropraxis.kingtools;

import chiropraxis.kingtools.KingFoo;
import driftwood.moldb2.AtomState;
import driftwood.moldb2.Model;
import driftwood.moldb2.PdbReader;
import driftwood.r3.Triple;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;

public class KingFooCLI {
    InputStream pdbInput = null;
    boolean removeHets = true;
    Triple fooOrigen = null;
    double fooRadius = 1.0;
    double gridSpacing = 0.4;
    int steps = 10;
    int freeSteps = 3;
    boolean removeWetFoos = true;
    double wetFooRadius = 3.0;
    boolean makeDotSurface = true;
    double dotDensity = 16.0;

    public void Main() throws IOException {
        Model model = new PdbReader().read(this.pdbInput).getFirstModel();
        LinkedList linkedList = new LinkedList(model.getState().createCollapsed().getLocalStateMap().values());
        if (this.removeHets) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                AtomState atomState = (AtomState)iterator.next();
                if (!atomState.isHet()) continue;
                iterator.remove();
            }
        }
        long l = System.currentTimeMillis();
        KingFoo kingFoo = new KingFoo(linkedList, this.fooRadius, this.fooRadius / 1.0);
        kingFoo.placeFoosFCC(this.fooOrigen, this.gridSpacing, this.steps, this.freeSteps);
        l = System.currentTimeMillis() - l;
        System.err.println(kingFoo.getFoos().size() + " foos were placed successfully in " + l + " ms");
        if (this.removeWetFoos) {
            l = System.currentTimeMillis();
            kingFoo.removeWetFoos(this.wetFooRadius);
            l = System.currentTimeMillis() - l;
            System.err.println(kingFoo.getFoos().size() + " dry foos remaining after " + l + " ms");
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0###");
        System.out.println("@group {foo cavities}");
        System.out.println("@subgroup {foo cavities}");
        System.out.println("@balllist {foo balls} radius= " + decimalFormat.format(this.fooRadius) + " color= pink off nohighlight alpha= 1.0");
        Object object = kingFoo.getFoos().iterator();
        while (object.hasNext()) {
            System.out.println("{x} " + ((Triple)object.next()).format(decimalFormat));
        }
        if (this.makeDotSurface) {
            l = System.currentTimeMillis();
            object = kingFoo.surfaceFoos(this.dotDensity);
            l = System.currentTimeMillis() - l;
            System.err.println(object.size() + " dots placed in " + l + " ms");
            System.out.println("@dotlist {foo dots} color= gray width= 1");
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                System.out.println("{x} " + ((Triple)iterator.next()).format(decimalFormat));
            }
        }
    }

    public static void main(String[] stringArray) {
        KingFooCLI kingFooCLI = new KingFooCLI();
        try {
            kingFooCLI.parseArguments(stringArray);
            if (kingFooCLI.fooOrigen == null) {
                throw new IllegalArgumentException("Must specify -origen for foo.");
            }
            if (kingFooCLI.pdbInput == null) {
                kingFooCLI.pdbInput = System.in;
            }
            kingFooCLI.Main();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            kingFooCLI.showHelp(true);
            System.err.println();
            System.err.println("*** Error parsing arguments: " + exception.getMessage());
            System.exit(1);
        }
    }

    void parseArguments(String[] stringArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            String string3 = stringArray[i];
            if (!string3.startsWith("-") || !bl || string3.equals("-")) {
                this.interpretArg(string3);
                continue;
            }
            if (string3.equals("--")) {
                bl = false;
                continue;
            }
            int n = string3.indexOf(61);
            if (n != -1) {
                string2 = string3.substring(0, n);
                string = string3.substring(n + 1);
            } else {
                string2 = string3;
                string = null;
            }
            try {
                this.interpretFlag(string2, string);
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalArgumentException("'" + string3 + "' expects to be followed by a parameter");
            }
        }
    }

    void showHelp(boolean bl) {
        if (bl) {
            InputStream inputStream = this.getClass().getResourceAsStream("KingFooCLI.help");
            if (inputStream == null) {
                System.err.println("\n*** Unable to locate help information in 'KingFooCLI.help' ***\n");
            } else {
                try {
                    this.streamcopy(inputStream, System.out);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        System.err.println("chiropraxis.kingtools.KingFooCLI");
        System.err.println("Copyright (C) 2005 by Ian W. Davis. All rights reserved.");
    }

    void streamcopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[2048];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    void interpretArg(String string) {
        if (this.pdbInput == null) {
            try {
                this.pdbInput = new BufferedInputStream(new FileInputStream(string));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("IOEx: " + iOException.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Extra argument: " + string);
        }
    }

    void interpretFlag(String string, String string2) {
        if (string.equals("-help") || string.equals("-h")) {
            this.showHelp(true);
            System.exit(0);
        } else if (string.equals("-origen")) {
            String[] stringArray = string2.split("\\s*[, ]\\s*");
            try {
                this.fooOrigen = new Triple(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Correct usage: -ORIGEN=#.#,#.#,#.#");
            }
        } else if (string.equals("-steps")) {
            try {
                this.steps = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Correct usage: -STEPS=#");
            }
        } else if (!string.equals("-dummy_option") && !string.equals("-dummy_option")) {
            throw new IllegalArgumentException("'" + string + "' is not recognized as a valid flag");
        }
    }
}

