/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Generic install and uninstall functions
 *
 * Notes:
 *  - None
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 4.V.2020
 *
 * Author:
 *  - Mariusz Zaborski (https://oshogbo.vexillium.org/)
 *
 */

#ifndef P_LKRG_EXPLOIT_DETECTION_INSTALL_H
#define P_LKRG_EXPLOIT_DETECTION_INSTALL_H

int p_get_kprobe_maxactive(void);

int p_install_hook(struct kretprobe *kretprobe, char *state, int p_isra);
void p_uninstall_hook(struct kretprobe *kretprobe, char *state);

#define GENERATE_INSTALL_FUNC(name)                                                       \
   int p_install_##name##_hook(int p_isra) {                                              \
      return p_install_hook(&p_##name##_kretprobe, &p_##name##_kretprobe_state, p_isra);  \
   }                                                                                      \
                                                                                          \
   void p_uninstall_##name##_hook(void) {                                                 \
      return p_uninstall_hook(&p_##name##_kretprobe, &p_##name##_kretprobe_state);        \
   }

#endif
