/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class CappedSet<T>
extends ForwardingSet<T> {
    private final Set<T> delegate;
    private final int upperSize;

    private CappedSet(Set<T> delegate, int upperSize) {
        this.delegate = delegate;
        this.upperSize = upperSize;
    }

    public static <T> Set<T> create(int maxSize) {
        return new CappedSet(new HashSet(), maxSize);
    }

    @Override
    protected Set<T> delegate() {
        return this.delegate;
    }

    @Override
    public boolean add(T element) {
        if (this.delegate.size() >= this.upperSize) {
            Preconditions.checkState(this.delegate.contains(element), "collection is too large (%s >= %s)", this.delegate.size(), this.upperSize);
            return false;
        }
        return this.delegate.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.standardAddAll(collection);
    }
}

