/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.logging;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.CryptoUtil;
import org.signal.core.util.Hex;
import org.signal.core.util.logging.Scrubber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H\u0007J:\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00062 \u0010)\u001a\u001c\u0012\u0004\u0012\u00020+\u0012\b\u0012\u00060,j\u0002`-\u0012\u0004\u0012\u00020.0*j\u0002`/H\u0002J\f\u00100\u001a\u00020&*\u00020&H\u0002J\f\u00101\u001a\u00020&*\u00020&H\u0002J\f\u00102\u001a\u00020&*\u00020&H\u0002J\f\u00103\u001a\u00020&*\u00020&H\u0002J\f\u00104\u001a\u00020&*\u00020&H\u0002J\f\u00105\u001a\u00020&*\u00020&H\u0002J\f\u00106\u001a\u00020&*\u00020&H\u0002J\f\u00107\u001a\u00020&*\u00020&H\u0002J\f\u00108\u001a\u00020&*\u00020&H\u0002J\f\u00109\u001a\u00020&*\u00020&H\u0002J\f\u0010:\u001a\u00020&*\u00020&H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u0002R,\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006;"}, d2={"Lorg/signal/core/util/logging/Scrubber;", "", "()V", "CALL_LINK_CENSOR_SUFFIX", "", "CALL_LINK_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "CRUDE_EMAIL_PATTERN", "DOMAIN_CENSOR", "DOMAIN_PATTERN", "E164_PATTERN", "E164_ZERO_PATTERN", "EMAIL_CENSOR", "GROUP_ID_V1_PATTERN", "GROUP_ID_V2_PATTERN", "IPV4_CENSOR", "IPV4_PATTERN", "IPV6_CENSOR", "IPV6_PATTERN", "PNI_PATTERN", "TOP_100_TLDS", "", "UUID_CENSOR", "UUID_PATTERN", "identifierHmacKey", "", "getIdentifierHmacKey$annotations", "identifierHmacKeyProvider", "Lkotlin/Function0;", "getIdentifierHmacKeyProvider$annotations", "getIdentifierHmacKeyProvider", "()Lkotlin/jvm/functions/Function0;", "setIdentifierHmacKeyProvider", "(Lkotlin/jvm/functions/Function0;)V", "hash", "value", "scrub", "", "input", "pattern", "processMatch", "Lkotlin/Function2;", "Ljava/util/regex/Matcher;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "", "Lorg/signal/core/util/logging/MatchProcessor;", "scrubCallLinkKeys", "scrubDomains", "scrubE164", "scrubE164Zero", "scrubEmail", "scrubGroupsV1", "scrubGroupsV2", "scrubIpv4", "scrubIpv6", "scrubPnis", "scrubUuids", "core-util-jvm"})
public final class Scrubber {
    @NotNull
    public static final Scrubber INSTANCE = new Scrubber();
    private static final Pattern E164_PATTERN = Pattern.compile("(\\+|%2B)(\\d{7,15})");
    private static final Pattern E164_ZERO_PATTERN = Pattern.compile("\\b0(\\d{10})\\b");
    private static final Pattern CRUDE_EMAIL_PATTERN = Pattern.compile("\\b([^\\s/])([^\\s/]*@[^\\s]+)");
    @NotNull
    private static final String EMAIL_CENSOR = "...@...";
    private static final Pattern GROUP_ID_V1_PATTERN = Pattern.compile("(__textsecure_group__!)([^\\s]+)([^\\s]{3})");
    private static final Pattern GROUP_ID_V2_PATTERN = Pattern.compile("(__signal_group__v2__!)([^\\s]+)([^\\s]{3})");
    private static final Pattern UUID_PATTERN = Pattern.compile("(JOB::)?([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{9})([0-9a-f]{3})", 2);
    @NotNull
    private static final String UUID_CENSOR = "********-****-****-****-*********";
    private static final Pattern PNI_PATTERN = Pattern.compile("PNI:([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{9}[0-9a-f]{3})", 2);
    private static final Pattern IPV4_PATTERN = Pattern.compile("\\b(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b");
    @NotNull
    private static final String IPV4_CENSOR = "...ipv4...";
    private static final Pattern IPV6_PATTERN = Pattern.compile("([0-9a-fA-F]{0,4}:){3,7}([0-9a-fA-F]){0,4}");
    @NotNull
    private static final String IPV6_CENSOR = "...ipv6...";
    private static final Pattern DOMAIN_PATTERN = Pattern.compile("([a-z0-9]+\\.)+([a-z0-9\\-]*[a-z\\-][a-z0-9\\-]*)", 2);
    @NotNull
    private static final String DOMAIN_CENSOR = "***.";
    @NotNull
    private static final Set<String> TOP_100_TLDS;
    private static final Pattern CALL_LINK_PATTERN;
    @NotNull
    private static final String CALL_LINK_CENSOR_SUFFIX = "-XXXX-XXXX-XXXX-XXXX-XXXX-XXXX-XXXX";
    @NotNull
    private static volatile Function0<byte[]> identifierHmacKeyProvider;
    @Nullable
    private static volatile byte[] identifierHmacKey;

    private Scrubber() {
    }

    @NotNull
    public static final Function0<byte[]> getIdentifierHmacKeyProvider() {
        return identifierHmacKeyProvider;
    }

    public static final void setIdentifierHmacKeyProvider(@NotNull Function0<byte[]> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        identifierHmacKeyProvider = function0;
    }

    @JvmStatic
    public static /* synthetic */ void getIdentifierHmacKeyProvider$annotations() {
    }

    @JvmStatic
    private static /* synthetic */ void getIdentifierHmacKey$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final CharSequence scrub(@NotNull CharSequence input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return INSTANCE.scrubCallLinkKeys(INSTANCE.scrubIpv6(INSTANCE.scrubIpv4(INSTANCE.scrubDomains(INSTANCE.scrubUuids(INSTANCE.scrubPnis(INSTANCE.scrubGroupsV2(INSTANCE.scrubGroupsV1(INSTANCE.scrubEmail(INSTANCE.scrubE164Zero(INSTANCE.scrubE164(input)))))))))));
    }

    private final CharSequence scrubE164(CharSequence $this$scrubE164) {
        Pattern pattern = E164_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"E164_PATTERN");
        return this.scrub($this$scrubE164, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubE164.1.INSTANCE));
    }

    private final CharSequence scrubE164Zero(CharSequence $this$scrubE164Zero) {
        Pattern pattern = E164_ZERO_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"E164_ZERO_PATTERN");
        return this.scrub($this$scrubE164Zero, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubE164Zero.1.INSTANCE));
    }

    private final CharSequence scrubEmail(CharSequence $this$scrubEmail) {
        Pattern pattern = CRUDE_EMAIL_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"CRUDE_EMAIL_PATTERN");
        return this.scrub($this$scrubEmail, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubEmail.1.INSTANCE));
    }

    private final CharSequence scrubGroupsV1(CharSequence $this$scrubGroupsV1) {
        Pattern pattern = GROUP_ID_V1_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GROUP_ID_V1_PATTERN");
        return this.scrub($this$scrubGroupsV1, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubGroupsV1.1.INSTANCE));
    }

    private final CharSequence scrubGroupsV2(CharSequence $this$scrubGroupsV2) {
        Pattern pattern = GROUP_ID_V2_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"GROUP_ID_V2_PATTERN");
        return this.scrub($this$scrubGroupsV2, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubGroupsV2.1.INSTANCE));
    }

    private final CharSequence scrubPnis(CharSequence $this$scrubPnis) {
        Pattern pattern = PNI_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"PNI_PATTERN");
        return this.scrub($this$scrubPnis, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubPnis.1.INSTANCE));
    }

    private final CharSequence scrubUuids(CharSequence $this$scrubUuids) {
        Pattern pattern = UUID_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"UUID_PATTERN");
        return this.scrub($this$scrubUuids, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubUuids.1.INSTANCE));
    }

    private final CharSequence scrubDomains(CharSequence $this$scrubDomains) {
        Pattern pattern = DOMAIN_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"DOMAIN_PATTERN");
        return this.scrub($this$scrubDomains, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubDomains.1.INSTANCE));
    }

    private final CharSequence scrubIpv4(CharSequence $this$scrubIpv4) {
        Pattern pattern = IPV4_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"IPV4_PATTERN");
        return this.scrub($this$scrubIpv4, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubIpv4.1.INSTANCE));
    }

    private final CharSequence scrubIpv6(CharSequence $this$scrubIpv6) {
        Pattern pattern = IPV6_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"IPV6_PATTERN");
        return this.scrub($this$scrubIpv6, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubIpv6.1.INSTANCE));
    }

    private final CharSequence scrubCallLinkKeys(CharSequence $this$scrubCallLinkKeys) {
        Pattern pattern = CALL_LINK_PATTERN;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"CALL_LINK_PATTERN");
        return this.scrub($this$scrubCallLinkKeys, pattern, (Function2<? super Matcher, ? super StringBuilder, Unit>)((Function2)scrubCallLinkKeys.1.INSTANCE));
    }

    private final CharSequence scrub(CharSequence input, Pattern pattern, Function2<? super Matcher, ? super StringBuilder, Unit> processMatch) {
        CharSequence charSequence;
        StringBuilder output = new StringBuilder(input.length());
        Matcher matcher = pattern.matcher(input);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        int lastEndingPos = 0;
        while (matcher2.find()) {
            output.append(input, lastEndingPos, matcher2.start());
            processMatch.invoke((Object)matcher2, (Object)output);
            lastEndingPos = matcher2.end();
        }
        if (lastEndingPos == 0) {
            charSequence = input;
        } else {
            output.append(input, lastEndingPos, input.length());
            charSequence = output;
        }
        return charSequence;
    }

    private final String hash(String value) {
        if (identifierHmacKey == null) {
            identifierHmacKey = (byte[])identifierHmacKeyProvider.invoke();
        }
        if (identifierHmacKey == null) {
            return "<redacted>";
        }
        byte[] key = identifierHmacKey;
        String string = value;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hash = CryptoUtil.hmacSha256(key, byArray);
        String string2 = Hex.toStringCondensed(hash);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toStringCondensed(...)");
        return "<" + StringsKt.take((String)string2, (int)5) + ">";
    }

    public static final /* synthetic */ String access$hash(Scrubber $this, String value) {
        return $this.hash(value);
    }

    public static final /* synthetic */ Set access$getTOP_100_TLDS$p() {
        return TOP_100_TLDS;
    }

    static {
        Object[] objectArray = new String[]{"com", "net", "org", "jp", "de", "uk", "fr", "br", "it", "ru", "es", "me", "gov", "pl", "ca", "au", "cn", "co", "in", "nl", "edu", "info", "eu", "ch", "id", "at", "kr", "cz", "mx", "be", "tv", "se", "tr", "tw", "al", "ua", "ir", "vn", "cl", "sk", "ly", "cc", "to", "no", "fi", "us", "pt", "dk", "ar", "hu", "tk", "gr", "il", "news", "ro", "my", "biz", "ie", "za", "nz", "sg", "ee", "th", "io", "xyz", "pe", "bg", "hk", "lt", "link", "ph", "club", "si", "site", "mobi", "by", "cat", "wiki", "la", "ga", "xxx", "cf", "hr", "ng", "jobs", "online", "kz", "ug", "gq", "ae", "is", "lv", "pro", "fm", "tips", "ms", "sa", "app"};
        TOP_100_TLDS = SetsKt.setOf((Object[])objectArray);
        CALL_LINK_PATTERN = Pattern.compile("([bBcCdDfFgGhHkKmMnNpPqQrRsStTxXzZ]{4})(-[bBcCdDfFgGhHkKmMnNpPqQrRsStTxXzZ]{4}){7}");
        identifierHmacKeyProvider = identifierHmacKeyProvider.1.INSTANCE;
    }
}

