/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.svr;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.logging.Log;
import org.signal.libsignal.attest.AttestationFailedException;
import org.signal.libsignal.net.EnclaveAuth;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.NetworkException;
import org.signal.libsignal.net.Svr3;
import org.signal.libsignal.sgxsession.SgxCommunicationFailureException;
import org.signal.libsignal.svr.DataMissingException;
import org.signal.libsignal.svr.RestoreFailedException;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.kbs.PinHashUtil;
import org.whispersystems.signalservice.api.push.exceptions.NonSuccessfulResponseCodeException;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.api.svr.Svr3Credentials;
import org.whispersystems.signalservice.internal.push.AuthCredentials;
import org.whispersystems.signalservice.internal.push.ByteArrayDeserializerBase64;
import org.whispersystems.signalservice.internal.push.ByteArraySerializerBase64NoPadding;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.util.JsonUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0003 !\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\u0018\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\f\u0010\u001e\u001a\u00020\f*\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3;", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery;", "network", "Lorg/signal/libsignal/net/Network;", "pushServiceSocket", "Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;", "(Lorg/signal/libsignal/net/Network;Lorg/whispersystems/signalservice/internal/push/PushServiceSocket;)V", "svrVersion", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$SvrVersion;", "getSvrVersion", "()Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$SvrVersion;", "authorization", "Lorg/whispersystems/signalservice/internal/push/AuthCredentials;", "deleteData", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$DeleteResponse;", "restoreData", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$RestoreResponse;", "shareSet", "", "userPin", "", "restoreDataPostRegistration", "restoreDataPreRegistration", "resumePinChangeSession", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$PinChangeSession;", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "serializedChangeSession", "setPin", "toString", "toAuthCredential", "Lorg/whispersystems/signalservice/api/svr/Svr3Credentials;", "Companion", "Svr3PinChangeSession", "Svr3SessionData", "signal-service-java"})
public final class SecureValueRecoveryV3
implements SecureValueRecovery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Network network;
    @NotNull
    private final PushServiceSocket pushServiceSocket;
    @NotNull
    private final SecureValueRecovery.SvrVersion svrVersion;
    @NotNull
    private static final String TAG = Log.tag((KClass)Reflection.getOrCreateKotlinClass(SecureValueRecoveryV3.class));

    public SecureValueRecoveryV3(@NotNull Network network, @NotNull PushServiceSocket pushServiceSocket) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Intrinsics.checkNotNullParameter((Object)pushServiceSocket, (String)"pushServiceSocket");
        this.network = network;
        this.pushServiceSocket = pushServiceSocket;
        this.svrVersion = SecureValueRecovery.SvrVersion.SVR3;
    }

    @Override
    @NotNull
    public SecureValueRecovery.SvrVersion getSvrVersion() {
        return this.svrVersion;
    }

    @Override
    @NotNull
    public SecureValueRecovery.PinChangeSession setPin(@NotNull String userPin, @NotNull MasterKey masterKey) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        return new Svr3PinChangeSession(userPin, masterKey, null);
    }

    @Override
    @NotNull
    public SecureValueRecovery.PinChangeSession resumePinChangeSession(@NotNull String userPin, @NotNull MasterKey masterKey, @NotNull String serializedChangeSession) {
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
        Intrinsics.checkNotNullParameter((Object)serializedChangeSession, (String)"serializedChangeSession");
        Svr3SessionData svr3SessionData = JsonUtil.fromJson(serializedChangeSession, Svr3SessionData.class);
        Intrinsics.checkNotNullExpressionValue((Object)svr3SessionData, (String)"fromJson(...)");
        Svr3SessionData data = svr3SessionData;
        return Intrinsics.areEqual((Object)data.getUserPin(), (Object)userPin) && Intrinsics.areEqual((Object)data.getMasterKey(), (Object)masterKey) ? (SecureValueRecovery.PinChangeSession)new Svr3PinChangeSession(userPin, masterKey, data.getShareSet()) : (SecureValueRecovery.PinChangeSession)new Svr3PinChangeSession(userPin, masterKey, null);
    }

    @Override
    @NotNull
    public SecureValueRecovery.RestoreResponse restoreDataPreRegistration(@NotNull AuthCredentials authorization, @Nullable byte[] shareSet, @NotNull String userPin) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        return this.restoreData(authorization, shareSet, userPin);
    }

    @Override
    @NotNull
    public SecureValueRecovery.RestoreResponse restoreDataPostRegistration(@NotNull String userPin) {
        Svr3Credentials svr3Credentials;
        Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
        try {
            svr3Credentials = this.pushServiceSocket.getSvr3Authorization();
            Intrinsics.checkNotNull((Object)svr3Credentials);
        }
        catch (NonSuccessfulResponseCodeException e) {
            return new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        catch (IOException e) {
            return new SecureValueRecovery.RestoreResponse.NetworkError(e);
        }
        catch (Exception e) {
            return new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        Svr3Credentials authorization = svr3Credentials;
        return this.restoreData(this.toAuthCredential(authorization), authorization.getShareSet(), userPin);
    }

    @Override
    @NotNull
    public SecureValueRecovery.DeleteResponse deleteData() {
        SecureValueRecovery.DeleteResponse deleteResponse;
        Svr3Credentials svr3Credentials;
        try {
            svr3Credentials = this.pushServiceSocket.getSvr3Authorization();
            Intrinsics.checkNotNull((Object)svr3Credentials);
        }
        catch (NonSuccessfulResponseCodeException e) {
            return new SecureValueRecovery.DeleteResponse.ApplicationError(e);
        }
        catch (IOException e) {
            return new SecureValueRecovery.DeleteResponse.NetworkError(e);
        }
        catch (Exception e) {
            return new SecureValueRecovery.DeleteResponse.ApplicationError(e);
        }
        Svr3Credentials authorization = svr3Credentials;
        EnclaveAuth enclaveAuth = new EnclaveAuth(authorization.getUsername(), authorization.getPassword());
        try {
            this.network.svr3().remove(enclaveAuth).get();
            deleteResponse = SecureValueRecovery.DeleteResponse.Success.INSTANCE;
        }
        catch (ExecutionException e) {
            SecureValueRecovery.DeleteResponse deleteResponse2;
            Throwable cause = e.getCause();
            if (cause instanceof NetworkException) {
                deleteResponse2 = new SecureValueRecovery.DeleteResponse.NetworkError((IOException)cause);
            } else if (cause instanceof AttestationFailedException) {
                deleteResponse2 = new SecureValueRecovery.DeleteResponse.ApplicationError(cause);
            } else if (cause instanceof SgxCommunicationFailureException) {
                deleteResponse2 = new SecureValueRecovery.DeleteResponse.ApplicationError(cause);
            } else if (cause instanceof IOException) {
                deleteResponse2 = new SecureValueRecovery.DeleteResponse.NetworkError((IOException)cause);
            } else {
                Throwable throwable = cause;
                if (throwable == null) {
                    throwable = new RuntimeException("Unknown!");
                }
                deleteResponse2 = new SecureValueRecovery.DeleteResponse.ApplicationError(throwable);
            }
            deleteResponse = deleteResponse2;
        }
        catch (InterruptedException e) {
            deleteResponse = new SecureValueRecovery.DeleteResponse.ApplicationError(e);
        }
        catch (CancellationException e) {
            deleteResponse = new SecureValueRecovery.DeleteResponse.ApplicationError(e);
        }
        return deleteResponse;
    }

    @Override
    @NotNull
    public AuthCredentials authorization() throws IOException {
        Svr3Credentials svr3Credentials = this.pushServiceSocket.getSvr3Authorization();
        Intrinsics.checkNotNullExpressionValue((Object)svr3Credentials, (String)"getSvr3Authorization(...)");
        return this.toAuthCredential(svr3Credentials);
    }

    @NotNull
    public String toString() {
        return "SVR3";
    }

    private final SecureValueRecovery.RestoreResponse restoreData(AuthCredentials authorization, byte[] shareSet, String userPin) {
        SecureValueRecovery.RestoreResponse restoreResponse;
        if (shareSet == null) {
            Log.w((String)TAG, (String)"No share set provided! Assuming no data to restore.");
            return SecureValueRecovery.RestoreResponse.Missing.INSTANCE;
        }
        String normalizedPin = PinHashUtil.normalizeToString(userPin);
        EnclaveAuth enclaveAuth = new EnclaveAuth(authorization.username(), authorization.password());
        try {
            Svr3.RestoredSecret result2 = (Svr3.RestoredSecret)this.network.svr3().restore(normalizedPin, shareSet, enclaveAuth).get();
            MasterKey masterKey = new MasterKey(result2.value());
            restoreResponse = new SecureValueRecovery.RestoreResponse.Success(masterKey, authorization);
        }
        catch (ExecutionException e) {
            SecureValueRecovery.RestoreResponse restoreResponse2;
            Throwable cause = e.getCause();
            if (cause instanceof NetworkException) {
                restoreResponse2 = new SecureValueRecovery.RestoreResponse.NetworkError((IOException)cause);
            } else if (cause instanceof DataMissingException) {
                restoreResponse2 = SecureValueRecovery.RestoreResponse.Missing.INSTANCE;
            } else if (cause instanceof RestoreFailedException) {
                restoreResponse2 = new SecureValueRecovery.RestoreResponse.PinMismatch(((RestoreFailedException)cause).getTriesRemaining());
            } else if (cause instanceof AttestationFailedException) {
                restoreResponse2 = new SecureValueRecovery.RestoreResponse.ApplicationError(cause);
            } else if (cause instanceof SgxCommunicationFailureException) {
                restoreResponse2 = new SecureValueRecovery.RestoreResponse.ApplicationError(cause);
            } else if (cause instanceof IOException) {
                restoreResponse2 = new SecureValueRecovery.RestoreResponse.NetworkError((IOException)cause);
            } else {
                Throwable throwable = cause;
                if (throwable == null) {
                    throwable = new RuntimeException("Unknown!");
                }
                restoreResponse2 = new SecureValueRecovery.RestoreResponse.ApplicationError(throwable);
            }
            restoreResponse = restoreResponse2;
        }
        catch (InterruptedException e) {
            return new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        catch (CancellationException e) {
            return new SecureValueRecovery.RestoreResponse.ApplicationError(e);
        }
        return restoreResponse;
    }

    private final AuthCredentials toAuthCredential(Svr3Credentials $this$toAuthCredential) {
        AuthCredentials authCredentials = AuthCredentials.create($this$toAuthCredential.getUsername(), $this$toAuthCredential.getPassword());
        Intrinsics.checkNotNullExpressionValue((Object)authCredentials, (String)"create(...)");
        return authCredentials;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "signal-service-java"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3$Svr3PinChangeSession;", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$PinChangeSession;", "userPin", "", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "shareSet", "", "(Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3;Ljava/lang/String;Lorg/whispersystems/signalservice/api/kbs/MasterKey;[B)V", "execute", "Lorg/whispersystems/signalservice/api/svr/SecureValueRecovery$BackupResponse;", "serialize", "signal-service-java"})
    public final class Svr3PinChangeSession
    implements SecureValueRecovery.PinChangeSession {
        @NotNull
        private final String userPin;
        @NotNull
        private final MasterKey masterKey;
        @Nullable
        private byte[] shareSet;

        public Svr3PinChangeSession(@NotNull String userPin, @Nullable MasterKey masterKey, byte[] shareSet) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            this.userPin = userPin;
            this.masterKey = masterKey;
            this.shareSet = shareSet;
        }

        @Override
        @NotNull
        public SecureValueRecovery.BackupResponse execute() {
            Object object;
            try {
                object = SecureValueRecoveryV3.this.pushServiceSocket.getSvr3Authorization();
                Intrinsics.checkNotNull((Object)object);
            }
            catch (NonSuccessfulResponseCodeException e) {
                return new SecureValueRecovery.BackupResponse.ApplicationError(e);
            }
            catch (IOException e) {
                return new SecureValueRecovery.BackupResponse.NetworkError(e);
            }
            catch (Exception e) {
                return new SecureValueRecovery.BackupResponse.ApplicationError(e);
            }
            Svr3Credentials rawAuth = object;
            if (this.shareSet == null) {
                String normalizedPin = PinHashUtil.normalizeToString(this.userPin);
                EnclaveAuth enclaveAuth = new EnclaveAuth(rawAuth.getUsername(), rawAuth.getPassword());
                try {
                    this.shareSet = (byte[])SecureValueRecoveryV3.this.network.svr3().backup(this.masterKey.serialize(), normalizedPin, 10, enclaveAuth).get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof NetworkException) {
                        new SecureValueRecovery.BackupResponse.NetworkError((IOException)cause);
                    } else if (cause instanceof AttestationFailedException) {
                        new SecureValueRecovery.BackupResponse.ApplicationError(cause);
                    } else if (cause instanceof SgxCommunicationFailureException) {
                        new SecureValueRecovery.BackupResponse.ApplicationError(cause);
                    } else if (cause instanceof IOException) {
                        new SecureValueRecovery.BackupResponse.NetworkError((IOException)cause);
                    } else {
                        Throwable throwable = cause;
                        if (throwable == null) {
                            throwable = new RuntimeException("Unknown!");
                        }
                        new SecureValueRecovery.BackupResponse.ApplicationError(throwable);
                    }
                }
                catch (InterruptedException e) {
                    new SecureValueRecovery.BackupResponse.ApplicationError(e);
                }
                catch (CancellationException e) {
                    new SecureValueRecovery.BackupResponse.ApplicationError(e);
                }
            }
            try {
                SecureValueRecoveryV3.this.pushServiceSocket.setShareSet(this.shareSet);
                Svr3Credentials svr3Credentials = SecureValueRecoveryV3.this.pushServiceSocket.getSvr3Authorization();
                Intrinsics.checkNotNullExpressionValue((Object)svr3Credentials, (String)"getSvr3Authorization(...)");
                object = new SecureValueRecovery.BackupResponse.Success(this.masterKey, SecureValueRecoveryV3.this.toAuthCredential(svr3Credentials), SecureValueRecovery.SvrVersion.SVR3);
            }
            catch (NonSuccessfulResponseCodeException e) {
                object = new SecureValueRecovery.BackupResponse.ApplicationError(e);
            }
            catch (IOException e) {
                object = new SecureValueRecovery.BackupResponse.NetworkError(e);
            }
            catch (Exception e) {
                return new SecureValueRecovery.BackupResponse.ApplicationError(e);
            }
            return object;
        }

        @Override
        @NotNull
        public String serialize() {
            String string = JsonUtil.toJson(new Svr3SessionData(this.userPin, this.masterKey, this.shareSet));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            return string;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/whispersystems/signalservice/api/svr/SecureValueRecoveryV3$Svr3SessionData;", "", "userPin", "", "masterKey", "Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "shareSet", "", "(Ljava/lang/String;Lorg/whispersystems/signalservice/api/kbs/MasterKey;[B)V", "getMasterKey", "()Lorg/whispersystems/signalservice/api/kbs/MasterKey;", "getShareSet", "()[B", "getUserPin", "()Ljava/lang/String;", "signal-service-java"})
    public static final class Svr3SessionData {
        @NotNull
        private final String userPin;
        @NotNull
        private final MasterKey masterKey;
        @Nullable
        private final byte[] shareSet;

        public Svr3SessionData(@JsonProperty @NotNull String userPin, @JsonProperty @JsonSerialize(using=JsonUtil.MasterKeySerializer.class) @JsonDeserialize(using=JsonUtil.MasterKeyDeserializer.class) @NotNull MasterKey masterKey, @JsonProperty @JsonSerialize(using=ByteArraySerializerBase64NoPadding.class) @JsonDeserialize(using=ByteArrayDeserializerBase64.class) @Nullable byte[] shareSet) {
            Intrinsics.checkNotNullParameter((Object)userPin, (String)"userPin");
            Intrinsics.checkNotNullParameter((Object)masterKey, (String)"masterKey");
            this.userPin = userPin;
            this.masterKey = masterKey;
            this.shareSet = shareSet;
        }

        @NotNull
        public final String getUserPin() {
            return this.userPin;
        }

        @NotNull
        public final MasterKey getMasterKey() {
            return this.masterKey;
        }

        @Nullable
        public final byte[] getShareSet() {
            return this.shareSet;
        }
    }
}

