# This file generated by `mix dagger.gen`. Please DO NOT EDIT.
defmodule Dagger.GitModuleRef do
  @moduledoc "A reference to a module loaded from a git repo."
  use Dagger.QueryBuilder
  @type t() :: %__MODULE__{}
  defstruct [:selection, :client]

  (
    @doc "The URL from which the ref's git repo can be cloned from"
    @spec clone_url(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def clone_url(%__MODULE__{} = git_module_ref) do
      selection = select(git_module_ref.selection, "cloneURL")
      execute(selection, git_module_ref.client)
    end
  )

  (
    @doc ""
    @spec commit(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def commit(%__MODULE__{} = git_module_ref) do
      selection = select(git_module_ref.selection, "commit")
      execute(selection, git_module_ref.client)
    end
  )

  (
    @doc "The URL to the ref's git repo in a web browser"
    @spec html_url(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def html_url(%__MODULE__{} = git_module_ref) do
      selection = select(git_module_ref.selection, "htmlURL")
      execute(selection, git_module_ref.client)
    end
  )

  (
    @doc "A unique identifier for this GitModuleRef."
    @spec id(t()) :: {:ok, Dagger.GitModuleRefID.t()} | {:error, term()}
    def id(%__MODULE__{} = git_module_ref) do
      selection = select(git_module_ref.selection, "id")
      execute(selection, git_module_ref.client)
    end
  )

  (
    @doc ""
    @spec module_source_path(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def module_source_path(%__MODULE__{} = git_module_ref) do
      selection = select(git_module_ref.selection, "moduleSourcePath")
      execute(selection, git_module_ref.client)
    end
  )

  (
    @doc ""
    @spec version(t()) :: {:ok, Dagger.String.t()} | {:error, term()}
    def version(%__MODULE__{} = git_module_ref) do
      selection = select(git_module_ref.selection, "version")
      execute(selection, git_module_ref.client)
    end
  )
end
