/*
 * Decompiled with CFR 0.152.
 */
package plugin.converter;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.gui2.converter.event.TokenProcessEvent;
import pcgen.gui2.converter.event.TokenProcessorPlugin;

public class PreVisionInvertedConvertPlugin
implements TokenProcessorPlugin {
    public static final String SET_ANY = "Set unspecified values to ANY (identify as 'present')";
    public static final String SET_ZERO_ANY = "Set zero values to ANY (identify as 'present')";
    public static final String SET_ZERO_ONE = "Set zero values to 1 (identify as 'possessing distance')";

    public String process(TokenProcessEvent tpe) {
        String formula = tpe.getValue();
        int commaLoc = formula.indexOf(44);
        if (commaLoc == -1) {
            return "Prerequisite " + tpe.getKey() + " must have a count: " + formula;
        }
        if (commaLoc == formula.length() - 1) {
            return "Prerequisite " + tpe.getKey() + " can not have only a count: " + formula;
        }
        String num = formula.substring(0, commaLoc);
        String rest = formula.substring(commaLoc + 1);
        try {
            Integer.parseInt(num);
        }
        catch (NumberFormatException nfe) {
            return "'" + num + "' in " + tpe.getKey() + " is not a valid integer";
        }
        commaLoc = rest.indexOf(44);
        if (commaLoc == -1) {
            int equalLoc = rest.indexOf(61);
            if (equalLoc == -1) {
                tpe.append((CharSequence)this.getPrefix(tpe, num));
                tpe.append((CharSequence)rest);
                tpe.append((CharSequence)"=ANY");
            } else {
                this.processZero(formula, tpe, num, rest);
            }
        } else {
            String[] strings = rest.split(",");
            int withEquals = 0;
            boolean withoutEquals = false;
            boolean lastWithEquals = false;
            ArrayList<String> list = new ArrayList<String>();
            for (String tok : strings) {
                int equalLoc = tok.indexOf(61);
                if (equalLoc == -1) {
                    withoutEquals = true;
                    lastWithEquals = false;
                } else {
                    ++withEquals;
                    lastWithEquals = true;
                }
                list.add(tok);
            }
            if (withEquals == 1 && lastWithEquals) {
                String last = strings[strings.length - 1];
                int eqLoc = last.indexOf(61);
                String equal = last.substring(eqLoc + 1);
                tpe.append((CharSequence)this.getPrefix(tpe, num));
                tpe.append((CharSequence)StringUtil.join(list, (String)("=" + equal + ",")));
            } else if (withEquals > 0 && withoutEquals) {
                StringBuilder onebase = new StringBuilder();
                StringBuilder leftbase = new StringBuilder();
                StringBuilder rightbase = new StringBuilder();
                boolean needComma = false;
                Integer lastValue = null;
                for (int i = 0; i < strings.length; ++i) {
                    if (needComma) {
                        onebase.append(',');
                        leftbase.append(',');
                        rightbase.append(',');
                    }
                    needComma = true;
                    String tok = strings[i];
                    int equalLoc = tok.indexOf(61);
                    onebase.append(tok);
                    leftbase.append(tok);
                    rightbase.append(tok);
                    if (equalLoc == -1) {
                        onebase.append("=ANY");
                        leftbase.append('=');
                        if (lastValue == null) {
                            leftbase.append("ANY");
                        } else {
                            leftbase.append(lastValue);
                        }
                        rightbase.append('=');
                        rightbase.append(this.getNextValue(strings, i));
                        continue;
                    }
                    lastValue = Integer.decode(tok.substring(equalLoc + 1));
                }
                ArrayList<String> descr = new ArrayList<String>();
                ArrayList<String> choice = new ArrayList<String>();
                this.processChoices(tpe, num, descr, choice, onebase.toString(), SET_ANY);
                this.processChoices(tpe, num, descr, choice, rightbase.toString(), "Set unspecified values to next identified value (items queue until set/equals sign flows left)");
                this.processChoices(tpe, num, descr, choice, leftbase.toString(), "Set unspecified values to previous identified value (equals sign holds on unspecified items until redefined)");
                String result = null;
                boolean match = true;
                for (String c : choice) {
                    if (result == null) {
                        result = c;
                        continue;
                    }
                    if (result.equals(c)) continue;
                    match = false;
                    break;
                }
                if (match) {
                    tpe.append(result);
                } else {
                    String decision = tpe.getDecider().getConversionDecision("Resolve ambiguity for " + this.getProcessedToken() + ":" + formula, descr, choice, 0);
                    tpe.append((CharSequence)decision);
                }
            } else if (withEquals > 0) {
                this.processZero(formula, tpe, num, strings);
            } else if (withoutEquals) {
                tpe.append((CharSequence)this.getPrefix(tpe, num));
                tpe.append((CharSequence)StringUtil.join(list, (String)"=ANY,"));
                tpe.append((CharSequence)"=ANY");
            }
        }
        tpe.consume();
        return null;
    }

    private void processChoices(TokenProcessEvent tpe, String num, List<String> descr, List<String> choice, String leftbaseResult, String d) {
        List<String> leftChoices = this.createZeroChoices(tpe, num, leftbaseResult.split(","));
        if (leftChoices.get(0).equals(leftChoices.get(1))) {
            descr.add(leftbaseResult + " ... " + d);
            choice.add(leftbaseResult);
        } else {
            descr.add(leftChoices.get(0) + " ... " + d + " and " + SET_ZERO_ONE);
            choice.add(leftChoices.get(0));
            descr.add(leftChoices.get(1) + " ... " + d + " and " + SET_ZERO_ANY);
            choice.add(leftChoices.get(1));
        }
    }

    private void processZero(String formula, TokenProcessEvent tpe, String num, String ... base) {
        String zeroChoice;
        List<String> choice = this.createZeroChoices(tpe, num, base);
        String oneChoice = choice.get(0);
        if (oneChoice.equals(zeroChoice = choice.get(1))) {
            tpe.append((CharSequence)oneChoice);
        } else {
            ArrayList<String> descr = new ArrayList<String>();
            descr.add(oneChoice + " ... " + SET_ZERO_ONE);
            descr.add(zeroChoice + " ... " + SET_ZERO_ANY);
            String decision = tpe.getDecider().getConversionDecision("Resolve ambiguity for " + this.getProcessedToken() + ":" + formula, descr, choice, 0);
            tpe.append((CharSequence)decision);
        }
    }

    private List<String> createZeroChoices(TokenProcessEvent tpe, String num, String ... base) {
        StringBuilder one = this.getPrefix(tpe, num);
        StringBuilder any = this.getPrefix(tpe, num);
        boolean needComma = false;
        for (int i = 0; i < base.length; ++i) {
            String tok = base[i];
            int equalLoc = tok.indexOf(61);
            String target = tok.substring(equalLoc + 1);
            if (needComma) {
                one.append(',');
                any.append(',');
            }
            needComma = true;
            if (!"ANY".equals(target) && Integer.parseInt(target) == 0) {
                String start = tok.substring(0, equalLoc);
                one.append(start);
                any.append(start);
                one.append("=1");
                any.append("=ANY");
                continue;
            }
            one.append(tok);
            any.append(tok);
        }
        String oneResult = one.toString();
        String anyResult = any.toString();
        ArrayList<String> choice = new ArrayList<String>();
        choice.add(oneResult);
        choice.add(anyResult);
        return choice;
    }

    private StringBuilder getPrefix(TokenProcessEvent tpe, String num) {
        StringBuilder sb = new StringBuilder();
        sb.append(tpe.getKey());
        sb.append(':');
        sb.append(num);
        sb.append(',');
        return sb;
    }

    private String getNextValue(String[] strings, int i) {
        for (int j = i + 1; j < strings.length; ++j) {
            String tok = strings[j];
            int equalLoc = tok.indexOf(61);
            if (equalLoc == -1) continue;
            return tok.substring(equalLoc + 1);
        }
        return "ANY";
    }

    public Class<? extends CDOMObject> getProcessedClass() {
        return CDOMObject.class;
    }

    public String getProcessedToken() {
        return "!PREVISION";
    }
}

