/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;

public class ConditionalSelectionActor<T>
extends ConcretePrereqObject
implements ChooseSelectionActor<T> {
    private final ChooseSelectionActor<T> actor;

    public ConditionalSelectionActor(ChooseSelectionActor<T> csa) {
        if (csa == null) {
            throw new IllegalArgumentException("Cannot have null ChoiceActor");
        }
        this.actor = csa;
    }

    @Override
    public void applyChoice(ChooseDriver cdo, T choice, PlayerCharacter pc) {
        if (this.qualifies(pc, cdo)) {
            this.actor.applyChoice(cdo, choice, pc);
        }
    }

    @Override
    public void removeChoice(ChooseDriver cdo, T choice, PlayerCharacter pc) {
        this.actor.removeChoice(cdo, choice, pc);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConditionalSelectionActor) {
            ConditionalSelectionActor other = (ConditionalSelectionActor)obj;
            return this.actor.equals(other.actor) && this.equalsPrereqObject(other);
        }
        return false;
    }

    public int hashCode() {
        return this.actor.hashCode();
    }

    @Override
    public String getSource() {
        return this.actor.getSource();
    }

    @Override
    public String getLstFormat() throws PersistenceLayerException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.actor.getLstFormat());
        if (this.hasPrerequisites()) {
            sb.append('|');
            sb.append(new PrerequisiteWriter().getPrerequisiteString(this.getPrerequisiteList()));
        }
        return sb.toString();
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.actor.getChoiceClass();
    }

    public static <GT> ConditionalSelectionActor<GT> getCSA(ChooseSelectionActor<GT> csa) {
        return new ConditionalSelectionActor<GT>(csa);
    }
}

