/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.helper;

import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.QualifyingObject;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;

public class AbilityTargetSelector<T>
extends ConcretePrereqObject
implements QualifyingObject,
ChooseSelectionActor<T> {
    private final String source;
    private final CDOMSingleRef<AbilityCategory> category;
    private final CDOMSingleRef<Ability> ability;
    private final Nature nature;

    public AbilityTargetSelector(String token, CDOMSingleRef<AbilityCategory> cat, CDOMSingleRef<Ability> abil, Nature nat) {
        this.category = cat;
        this.ability = abil;
        this.nature = nat;
        this.source = token;
    }

    public String getAbilityKey() {
        return this.ability.resolvesTo().getKeyName();
    }

    public CDOMSingleRef<AbilityCategory> getAbilityCategory() {
        return this.category;
    }

    public String getFullAbilityKey() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getAbilityKey());
        sb.append('(');
        sb.append("%LIST");
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.ability.resolvesTo().getDisplayName());
        sb.append('(');
        sb.append("%LIST");
        sb.append(')');
        return sb.toString();
    }

    public Nature getNature() {
        return this.nature;
    }

    public Ability getAbility() {
        return this.ability.resolvesTo();
    }

    @Override
    public void applyChoice(ChooseDriver obj, T choice, PlayerCharacter pc) {
        Ability ab = this.ability.resolvesTo();
        ChooseInformation<?> ci = ab.get(ObjectKey.CHOOSE_INFO);
        this.detailedApply(obj, ci, choice, pc);
    }

    private void detailedApply(ChooseDriver obj, ChooseInformation<T> ci, T choice, PlayerCharacter pc) {
        String string = ci.encodeChoice(choice);
        CNAbilitySelection appliedSelection = new CNAbilitySelection(CNAbilityFactory.getCNAbility(this.category.resolvesTo(), this.nature, this.ability.resolvesTo()), string);
        appliedSelection.addAllPrerequisites(this.getPrerequisiteList());
        pc.addAbility(appliedSelection, obj, this);
    }

    @Override
    public String getLstFormat() throws PersistenceLayerException {
        return this.ability.getLSTformat(false);
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void removeChoice(ChooseDriver obj, T choice, PlayerCharacter pc) {
        Ability ab = this.ability.resolvesTo();
        ChooseInformation<?> ci = ab.get(ObjectKey.CHOOSE_INFO);
        this.detailedRemove(obj, ci, choice, pc);
    }

    private void detailedRemove(ChooseDriver obj, ChooseInformation<T> ci, T choice, PlayerCharacter pc) {
        String string = ci.encodeChoice(choice);
        CNAbilitySelection appliedSelection = new CNAbilitySelection(CNAbilityFactory.getCNAbility(this.category.resolvesTo(), this.nature, this.ability.resolvesTo()), string);
        pc.removeAbility(appliedSelection, obj, this);
    }

    public int hashCode() {
        return this.ability.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof AbilityTargetSelector) {
            AbilityTargetSelector other = (AbilityTargetSelector)o;
            return this.source.equals(other.source) && this.category.equals(other.category) && this.ability.equals(other.ability) && this.nature.equals((Object)other.nature);
        }
        return false;
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.ability.resolvesTo().get(ObjectKey.CHOOSE_INFO).getClassIdentity().getChoiceClass();
    }
}

