/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.utils;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;

public class ParsingSeparator
implements Iterator<String> {
    private final String startingString;
    private final StringTokenizer base;
    private final String sep;
    private boolean hasABlank = false;

    public ParsingSeparator(String baseString, char separator) {
        if (baseString == null) {
            throw new IllegalArgumentException("Choose Separator cannot take null initialization String");
        }
        this.sep = Character.toString(separator);
        this.startingString = baseString;
        this.base = new StringTokenizer(baseString, "[]()" + this.sep, true);
    }

    @Override
    public boolean hasNext() {
        return this.hasABlank || this.base.hasMoreTokens();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.hasABlank) {
            this.hasABlank = false;
            return "";
        }
        StringBuilder temp = new StringBuilder(this.startingString.length());
        Stack<String> expected = new Stack<String>();
        while (this.base.hasMoreTokens()) {
            String working = this.base.nextToken();
            if (this.sep.equals(working) && expected.isEmpty()) {
                this.hasABlank = !this.base.hasMoreTokens();
                return temp.toString();
            }
            temp.append(working);
            if ("(".equals(working)) {
                expected.push(")");
                continue;
            }
            if ("[".equals(working)) {
                expected.push("]");
                continue;
            }
            if (")".equals(working)) {
                if (expected.isEmpty()) {
                    throw new GroupingMismatchException(this.startingString + " did not have an open parenthesis " + "before close: " + temp.toString());
                }
                if (")".equals(expected.pop())) continue;
                throw new GroupingMismatchException(this.startingString + " did not have matching parenthesis " + "inside of brackets: " + temp.toString());
            }
            if (!"]".equals(working)) continue;
            if (expected.isEmpty()) {
                throw new GroupingMismatchException(this.startingString + " did not have an open bracket " + "before close: " + temp.toString());
            }
            if ("]".equals(expected.pop())) continue;
            throw new GroupingMismatchException(this.startingString + " did not have matching brackets " + "inside of parenthesis: " + temp.toString());
        }
        if (expected.isEmpty()) {
            return temp.toString();
        }
        throw new GroupingMismatchException(this.startingString + " reached end of String while attempting to match: " + (String)expected.pop());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static class GroupingMismatchException
    extends IllegalStateException {
        public GroupingMismatchException(String base) {
            super(base);
        }
    }
}

