/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.core.bonus.BonusObj;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.DeprecatedToken;
import pcgen.persistence.lst.LstToken;
import pcgen.rules.context.LoadContext;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class LstUtils {
    public static final String PIPE = "|";
    public static final String COMMA = ",";

    public static void deprecationCheck(LstToken token, CDOMObject obj, String value) {
        if (token instanceof DeprecatedToken) {
            String msg = LanguageBundle.getFormattedString("Warnings.LstTokens.Deprecated", token.getTokenName(), value, obj.getDisplayName(), obj.getSourceURI(), ((DeprecatedToken)((Object)token)).getMessage(obj, value));
            LstUtils.deprecationWarning(msg);
        }
    }

    public static void deprecationCheck(LstToken token, String name, URI source, String value) {
        if (token instanceof DeprecatedToken) {
            LstUtils.deprecationWarning(token.getTokenName(), name, source, value, ((DeprecatedToken)((Object)token)).getMessage(null, value));
        }
    }

    public static void deprecationCheck(BonusObj token, String name, String value) {
        if (token instanceof DeprecatedToken) {
            String msg = LanguageBundle.getFormattedString("Warnings.Bonus.Deprecated", name, value, ((DeprecatedToken)((Object)token)).getMessage(null, value));
            LstUtils.deprecationWarning(msg);
        }
    }

    public static void deprecationWarning(String tokenName, String name, URI source, String value, String message) {
        String msg = LanguageBundle.getFormattedString("Warnings.LstTokens.Deprecated", tokenName, value, name, source, message);
        LstUtils.deprecationWarning(msg);
    }

    public static void deprecationWarning(String warning) {
        Logging.deprecationPrint(warning);
    }

    static void processToken(LoadContext context, Loadable po, Object source, String tok) throws PersistenceLayerException {
        String value;
        String token = tok.trim();
        int colonLoc = token.indexOf(58);
        if (colonLoc == -1) {
            Logging.errorPrint("Invalid Token - does not contain a colon: '" + token + "' in " + po.getClass().getSimpleName() + " " + po.getDisplayName() + " of " + source);
            return;
        }
        if (colonLoc == 0) {
            Logging.errorPrint("Invalid Token - starts with a colon: '" + token + "' in " + po.getClass().getSimpleName() + " " + po.getDisplayName() + " of " + source);
            return;
        }
        String key = token.substring(0, colonLoc).intern();
        String string = value = colonLoc == token.length() - 1 ? null : token.substring(colonLoc + 1).intern();
        if (context.processToken(po, key, value)) {
            context.commit();
        } else {
            context.rollback();
            Logging.replayParsedMessages();
        }
        Logging.clearParseMessages();
    }
}

