/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcreteTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.NonInteractive;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.choiceset.QualifiedDecorator;
import pcgen.cdom.choiceset.ReferenceChoiceSet;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class KitLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
ChoiceActor<Kit> {
    private static final Class<Kit> KIT_CLASS = Kit.class;

    @Override
    public String getTokenName() {
        return "KIT";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (obj instanceof NonInteractive) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Non-Interactive object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        Formula count = FormulaFactory.getFormulaFor(tok.nextToken());
        if (!count.isValid()) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
        }
        if (!count.isStatic()) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " must be a number", context);
        }
        if (count.resolveStatic().intValue() <= 0) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " must be > 0", context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " must have a | separating " + "count from the list of possible values: " + value, context);
        }
        ArrayList<CDOMGroupRef<Kit>> refs = new ArrayList<CDOMGroupRef<Kit>>();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            CDOMReference ref = "ALL".equals(token) ? context.getReferenceContext().getCDOMAllReference(KIT_CLASS) : context.getReferenceContext().getCDOMReference(KIT_CLASS, token);
            refs.add((CDOMGroupRef<Kit>)ref);
        }
        ReferenceChoiceSet rcs = new ReferenceChoiceSet(refs);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), new QualifiedDecorator(rcs));
        cs.setTitle("Kit Selection");
        ConcreteTransitionChoice<Kit> tc = new ConcreteTransitionChoice<Kit>(cs, count);
        context.getObjectContext().addToList(obj, ListKey.KIT_CHOICE, tc);
        tc.setRequired(false);
        tc.setChoiceActor(this);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject pcc) {
        Changes<TransitionChoice<Kit>> changes = context.getObjectContext().getListChanges(pcc, ListKey.KIT_CHOICE);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection<TransitionChoice<Kit>> added = changes.getAdded();
        TreeSet<String> set = new TreeSet<String>();
        for (TransitionChoice<Kit> tc : added) {
            StringBuilder sb = new StringBuilder();
            sb.append(tc.getCount());
            sb.append("|");
            sb.append(tc.getChoices().getLSTformat().replaceAll(",", "|"));
            set.add(sb.toString());
        }
        return set.toArray(new String[set.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(CDOMObject owner, Kit choice, PlayerCharacter pc) {
        Kit.applyKit(choice, pc);
    }

    @Override
    public boolean allow(Kit choice, PlayerCharacter pc, boolean allowStack) {
        for (Kit k : pc.getKitInfo()) {
            if (!k.getKeyName().equalsIgnoreCase(choice.getKeyName())) continue;
            return false;
        }
        return true;
    }
}

