/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipmentmodifier.choose;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.EquipmentModifier;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class EqBuilderEqTypeToken
implements CDOMSecondaryToken<EquipmentModifier> {
    @Override
    public String getTokenName() {
        return "EQBUILDER.EQTYPE";
    }

    @Override
    public String getParentToken() {
        return "CHOOSE";
    }

    @Override
    public ParseResult parseToken(LoadContext context, EquipmentModifier obj, String value) {
        if (value == null) {
            context.getObjectContext().put((CDOMObject)obj, StringKey.CHOICE_STRING, this.getTokenName());
            return ParseResult.SUCCESS;
        }
        if (value.indexOf(44) != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not contain , : " + value, context);
        }
        if (value.indexOf(91) != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not contain [] : " + value, context);
        }
        if (value.charAt(0) == '|') {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not start with | : " + value, context);
        }
        if (value.charAt(value.length() - 1) == '|') {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments may not end with | : " + value, context);
        }
        if (value.indexOf("||") != -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " arguments uses double separator || : " + value, context);
        }
        int pipeLoc = value.indexOf("|");
        if (pipeLoc == -1) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " must have two or more | delimited arguments : " + value, context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        if (tok.countTokens() != 2) {
            return new ParseResult.Fail("COUNT:" + this.getTokenName() + " requires two arguments: " + value, context);
        }
        String first = tok.nextToken();
        if (!first.startsWith("COUNT=")) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " must have COUNT= as its first argument : " + value, context);
        }
        String second = tok.nextToken();
        if (!second.startsWith("TITLE=")) {
            return new ParseResult.Fail("CHOOSE:" + this.getTokenName() + " must have TITLE= as its second argument : " + value, context);
        }
        StringBuilder sb = new StringBuilder(value.length() + 20);
        sb.append(first).append('|').append(second.substring(6));
        sb.append("|TYPE=EQTYPES");
        context.getObjectContext().put((CDOMObject)obj, StringKey.CHOICE_STRING, sb.toString());
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, EquipmentModifier eqMod) {
        String returnString;
        String chooseString = context.getObjectContext().getString(eqMod, StringKey.CHOICE_STRING);
        if (chooseString == null) {
            return null;
        }
        if (this.getTokenName().equals(chooseString)) {
            returnString = "";
        } else {
            if (chooseString.indexOf(this.getTokenName() + '|') == -1) {
                return null;
            }
            returnString = chooseString.substring(this.getTokenName().length() + 1);
        }
        return new String[]{returnString};
    }

    @Override
    public Class<EquipmentModifier> getTokenClass() {
        return EquipmentModifier.class;
    }
}

