/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.campaign;

import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class TypeToken
extends AbstractTokenWithSeparator<Campaign>
implements CDOMPrimaryToken<Campaign> {
    public String getTokenName() {
        return "TYPE";
    }

    protected char separator() {
        return '.';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Campaign campaign, String value) {
        StringTokenizer aTok = new StringTokenizer(value, ".");
        String dataProducer = aTok.nextToken();
        context.getObjectContext().put((CDOMObject)campaign, StringKey.DATA_PRODUCER, dataProducer);
        if (aTok.hasMoreTokens()) {
            String dataFormat = aTok.nextToken();
            context.getObjectContext().put((CDOMObject)campaign, StringKey.DATA_FORMAT, dataFormat);
        } else {
            context.getObjectContext().put((CDOMObject)campaign, StringKey.DATA_FORMAT, null);
        }
        if (aTok.hasMoreTokens()) {
            String campaignSetting = aTok.nextToken();
            context.getObjectContext().put((CDOMObject)campaign, StringKey.CAMPAIGN_SETTING, campaignSetting);
        } else {
            context.getObjectContext().put((CDOMObject)campaign, StringKey.CAMPAIGN_SETTING, null);
        }
        if (aTok.hasMoreTokens()) {
            return new ParseResult.Fail(this.getTokenName() + " in Campaign may have a" + " maximum of 3 items, value is invalid: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Campaign campaign) {
        String setting;
        String producer = context.getObjectContext().getString((CDOMObject)campaign, StringKey.DATA_PRODUCER);
        if (producer == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(producer);
        String format = context.getObjectContext().getString((CDOMObject)campaign, StringKey.DATA_FORMAT);
        if (format != null) {
            sb.append(".");
            sb.append(format);
        }
        if ((setting = context.getObjectContext().getString((CDOMObject)campaign, StringKey.CAMPAIGN_SETTING)) != null) {
            sb.append(".");
            sb.append(setting);
        }
        return new String[]{sb.toString()};
    }

    public Class<Campaign> getTokenClass() {
        return Campaign.class;
    }
}

