/*******************************************************************************
* File:   		md5_digest.c
* Date:   		2004-05-21
* Author: 		Fernando Tarín
* Last Modified:	2004-5-23
*
* Description: Generate md5 and some other operations
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU Library General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <openssl/md5.h>

#include "md5_digest.h"

int make_md5_digest(char * path, char * filename, unsigned char * digest){
	int fd, rd;
	char file[50];
	unsigned char data[100], md[16];
	MD5_CTX c;

#ifndef __CYGWIN__
	sprintf(file,"%s%s",path, filename);
#else
	sprintf(file, "%s", filename);
#endif
	
	if ((fd=open(file,O_RDONLY)) == -1){
		return 0;
	}
	
	MD5_Init(&c);
	
	while ((rd = read(fd, data, 100)) > 0){		
		MD5_Update(&c, data, rd);
	}

	MD5_Final(md, &c);
	
	memcpy(digest,md,16);
	close(fd);
	
	return 1;
}

void copy_md5_digest(unsigned char *d1, const unsigned char * d2){
	memcpy(d1,d2,16);
}

int compare_md5_digests(const unsigned char * d1, const unsigned char * d2){
	return memcmp(d1, d2, 16);
}
