/*
 * This file is part of libdcadec.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

//
// Table A3
//
static const uint8_t A3_len[] = {
     1,  2,  2
};

static const uint16_t A3_code[] = {
    0x0000, 0x0002, 0x0003
};

//
// Table A4
//
static const uint8_t A4_len[] = {
     1,  2,  3,  3
};

static const uint16_t A4_code[] = {
    0x0000, 0x0002, 0x0006, 0x0007
};

//
// Table B4
//
static const uint8_t B4_len[] = {
     2,  3,  3,  1
};

static const uint16_t B4_code[] = {
    0x0002, 0x0006, 0x0007, 0x0000
};

//
// Table C4
//
static const uint8_t C4_len[] = {
     3,  3,  1,  2
};

static const uint16_t C4_code[] = {
    0x0006, 0x0007, 0x0000, 0x0002
};

//
// Table D4
//
static const uint8_t D4_len[] = {
     2,  2,  2,  2
};

static const uint16_t D4_code[] = {
    0x0000, 0x0001, 0x0002, 0x0003
};

//
// Table A5
//
static const uint8_t A5_len[] = {
     1,  2,  3,  4,  4
};

static const uint16_t A5_code[] = {
    0x0000, 0x0002, 0x0006, 0x000e, 0x000f
};

//
// Table B5
//
static const uint8_t B5_len[] = {
     2,  2,  2,  3,  3
};

static const uint16_t B5_code[] = {
    0x0002, 0x0000, 0x0001, 0x0006, 0x0007
};

//
// Table C5
//
static const uint8_t C5_len[] = {
     1,  3,  3,  3,  3
};

static const uint16_t C5_code[] = {
    0x0000, 0x0004, 0x0005, 0x0006, 0x0007
};

//
// Table A7
//
static const uint8_t A7_len[] = {
     1,  3,  3,  3,  4,  5,  5
};

static const uint16_t A7_code[] = {
    0x0000, 0x0006, 0x0005, 0x0004, 0x000e, 0x001f, 0x001e
};

//
// Table B7
//
static const uint8_t B7_len[] = {
     2,  2,  2,  3,  4,  5,  5
};

static const uint16_t B7_code[] = {
    0x0003, 0x0001, 0x0000, 0x0004, 0x000b, 0x0015, 0x0014
};

//
// Table C7
//
static const uint8_t C7_len[] = {
     2,  2,  2,  4,  4,  4,  4
};

static const uint16_t C7_code[] = {
    0x0003, 0x0002, 0x0001, 0x0003, 0x0002, 0x0001, 0x0000
};

//
// Table A9
//
static const uint8_t A9_len[] = {
     1,  3,  3,  4,  4,  4,  5,  6,  6
};

static const uint16_t A9_code[] = {
    0x0000, 0x0007, 0x0005, 0x000d, 0x0009, 0x0008, 0x0019, 0x0031, 0x0030
};

//
// Table B9
//
static const uint8_t B9_len[] = {
     2,  2,  3,  3,  3,  5,  5,  5,  5
};

static const uint16_t B9_code[] = {
    0x0002, 0x0000, 0x0007, 0x0003, 0x0002, 0x001b, 0x001a, 0x0019, 0x0018
};

//
// Table C9
//
static const uint8_t C9_len[] = {
     2,  2,  3,  3,  3,  4,  5,  6,  6
};

static const uint16_t C9_code[] = {
    0x0002, 0x0000, 0x0007, 0x0006, 0x0002, 0x0006, 0x000f, 0x001d, 0x001c
};

//
// Table A12
//
static const uint8_t A12_len[] = {
     1,  2,  3,  4,  5,  6,  8,  8,  9,
     9,  9,  9
};

static const uint16_t A12_code[] = {
    0x0000, 0x0002, 0x0006, 0x000e, 0x001e, 0x003e, 0x00ff, 0x00fe, 0x01fb,
    0x01fa, 0x01f9, 0x01f8
};

//
// Table B12
//
static const uint8_t B12_len[] = {
     1,  2,  3,  5,  5,  6,  7,  7,  7,
     7,  7,  7
};

static const uint16_t B12_code[] = {
    0x0001, 0x0000, 0x0002, 0x000f, 0x000c, 0x001d, 0x0039, 0x0038, 0x0037,
    0x0036, 0x0035, 0x0034
};

//
// Table C12
//
static const uint8_t C12_len[] = {
     2,  3,  3,  3,  3,  4,  4,  4,  5,
     6,  7,  7
};

static const uint16_t C12_code[] = {
    0x0000, 0x0007, 0x0005, 0x0004, 0x0002, 0x000d, 0x000c, 0x0006, 0x000f,
    0x001d, 0x0039, 0x0038
};

//
// Table D12
//
static const uint8_t D12_len[] = {
     2,  2,  2,  3,  4,  5,  6,  7,  8,
     9, 10, 10
};

static const uint16_t D12_code[] = {
    0x0003, 0x0002, 0x0000, 0x0002, 0x0006, 0x000e, 0x001e, 0x003e, 0x007e,
    0x00fe, 0x01ff, 0x01fe
};

//
// Table E12
//
static const uint8_t E12_len[] = {
     1,  2,  3,  4,  5,  7,  7,  8,  8,
     8,  9,  9
};

static const uint16_t E12_code[] = {
    0x0001, 0x0000, 0x0002, 0x0006, 0x000e, 0x003f, 0x003d, 0x007c, 0x0079,
    0x0078, 0x00fb, 0x00fa
};

//
// Table A13
//
static const uint8_t A13_len[] = {
     1,  3,  4,  4,  4,  4,  5,  5,  6,
     6,  6,  7,  7
};

static const uint16_t A13_code[] = {
    0x0000, 0x0004, 0x000f, 0x000d, 0x000c, 0x000a, 0x001d, 0x0016, 0x0039,
    0x002f, 0x002e, 0x0071, 0x0070
};

//
// Table B13
//
static const uint8_t B13_len[] = {
     2,  3,  3,  3,  4,  4,  4,  4,  5,
     5,  5,  6,  6
};

static const uint16_t B13_code[] = {
    0x0000, 0x0006, 0x0005, 0x0002, 0x000f, 0x0009, 0x0007, 0x0006, 0x001d,
    0x0011, 0x0010, 0x0039, 0x0038
};

//
// Table C13
//
static const uint8_t C13_len[] = {
     3,  3,  3,  3,  3,  4,  4,  4,  4,
     5,  5,  5,  5
};

static const uint16_t C13_code[] = {
    0x0005, 0x0004, 0x0003, 0x0002, 0x0000, 0x000f, 0x000e, 0x000c, 0x0003,
    0x001b, 0x001a, 0x0005, 0x0004
};

//
// Table A17
//
static const uint8_t A17_len[] = {
     2,  3,  3,  3,  3,  4,  4,  4,  5,
     6,  7,  8,  9, 10, 11, 12, 12
};

static const uint16_t A17_code[] = {
    0x0001, 0x0007, 0x0006, 0x0004, 0x0001, 0x000b, 0x000a, 0x0000, 0x0003,
    0x0004, 0x000b, 0x0014, 0x002b, 0x0054, 0x00ab, 0x0155, 0x0154
};

//
// Table B17
//
static const uint8_t B17_len[] = {
     2,  3,  3,  3,  4,  4,  4,  5,  5,
     5,  5,  6,  6,  6,  7,  8,  8
};

static const uint16_t B17_code[] = {
    0x0000, 0x0006, 0x0005, 0x0002, 0x000f, 0x0009, 0x0008, 0x001d, 0x001c,
    0x000e, 0x000d, 0x001e, 0x0019, 0x0018, 0x003f, 0x007d, 0x007c
};

//
// Table C17
//
static const uint8_t C17_len[] = {
     3,  3,  3,  3,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  5,  6,  7,  7
};

static const uint16_t C17_code[] = {
    0x0006, 0x0004, 0x0003, 0x0000, 0x000f, 0x000b, 0x000a, 0x0004, 0x0003,
    0x001d, 0x001c, 0x000a, 0x0005, 0x0004, 0x0017, 0x002d, 0x002c
};

//
// Table D17
//
static const uint8_t D17_len[] = {
     1,  3,  3,  4,  4,  5,  5,  6,  6,
     7,  7,  8,  8,  9,  9,  9,  9
};

static const uint16_t D17_code[] = {
    0x0000, 0x0007, 0x0006, 0x000b, 0x000a, 0x0013, 0x0012, 0x0023, 0x0022,
    0x0043, 0x0042, 0x0083, 0x0082, 0x0103, 0x0102, 0x0101, 0x0100
};

//
// Table E17
//
static const uint8_t E17_len[] = {
     1,  3,  3,  4,  5,  5,  5,  6,  6,
     6,  6,  7,  7,  8,  8,  8,  8
};

static const uint16_t E17_code[] = {
    0x0000, 0x0005, 0x0004, 0x000c, 0x001f, 0x001c, 0x001b, 0x003c, 0x003b,
    0x0035, 0x0034, 0x007a, 0x0075, 0x00f7, 0x00f6, 0x00e9, 0x00e8
};

//
// Table F17
//
static const uint8_t F17_len[] = {
     3,  3,  3,  3,  3,  4,  4,  4,  4,
     5,  5,  6,  6,  6,  7,  8,  8
};

static const uint16_t F17_code[] = {
    0x0006, 0x0005, 0x0004, 0x0002, 0x0001, 0x000f, 0x000e, 0x0006, 0x0001,
    0x000e, 0x0001, 0x001f, 0x001e, 0x0000, 0x0003, 0x0005, 0x0004
};

//
// Table G17
//
static const uint8_t G17_len[] = {
     2,  3,  3,  3,  3,  4,  4,  5,  5,
     6,  6,  7,  7,  8,  8,  8,  8
};

static const uint16_t G17_code[] = {
    0x0002, 0x0007, 0x0006, 0x0001, 0x0000, 0x0005, 0x0004, 0x000e, 0x000d,
    0x001e, 0x0019, 0x003e, 0x0031, 0x007f, 0x007e, 0x0061, 0x0060
};

//
// Table A25
//
static const uint8_t A25_len[] = {
     3,  3,  3,  3,  3,  4,  4,  4,  4,
     5,  5,  6,  6,  7,  7,  8,  8,  8,
     9, 10, 11, 12, 13, 14, 14
};

static const uint16_t A25_code[] = {
    0x0006, 0x0004, 0x0003, 0x0001, 0x0000, 0x000f, 0x000e, 0x0005, 0x0004,
    0x0016, 0x0015, 0x002f, 0x002e, 0x0053, 0x0052, 0x00a3, 0x00a2, 0x00a0,
    0x0143, 0x0284, 0x050b, 0x0a14, 0x142b, 0x2855, 0x2854
};

//
// Table B25
//
static const uint8_t B25_len[] = {
     3,  3,  3,  4,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  6,  6,  6,  6,  6,
     6,  7,  7,  7,  8,  9,  9
};

static const uint16_t B25_code[] = {
    0x0005, 0x0002, 0x0001, 0x000f, 0x000e, 0x0009, 0x0008, 0x0006, 0x0001,
    0x001a, 0x0019, 0x000f, 0x000e, 0x0037, 0x0036, 0x0031, 0x0030, 0x0001,
    0x0000, 0x0006, 0x0005, 0x0004, 0x000f, 0x001d, 0x001c
};

//
// Table C25
//
static const uint8_t C25_len[] = {
     3,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  5,  5,  5,  5,  5,  6,  6,
     6,  6,  7,  7,  7,  8,  8
};

static const uint16_t C25_code[] = {
    0x0001, 0x000f, 0x000e, 0x000c, 0x000b, 0x0009, 0x0008, 0x0006, 0x0005,
    0x0001, 0x0000, 0x001a, 0x0015, 0x000f, 0x000e, 0x0008, 0x0037, 0x0029,
    0x0028, 0x0012, 0x006d, 0x006c, 0x0027, 0x004d, 0x004c
};

//
// Table D25
//
static const uint8_t D25_len[] = {
     2,  3,  3,  3,  3,  4,  4,  5,  5,
     6,  6,  7,  7,  8,  8,  9,  9, 10,
    10, 11, 11, 12, 12, 12, 12
};

static const uint16_t D25_code[] = {
    0x0002, 0x0007, 0x0006, 0x0001, 0x0000, 0x0005, 0x0004, 0x000d, 0x000c,
    0x001d, 0x001c, 0x003e, 0x003d, 0x007e, 0x0079, 0x00ff, 0x00fe, 0x01e3,
    0x01e2, 0x03c3, 0x03c2, 0x0783, 0x0782, 0x0781, 0x0780
};

//
// Table E25
//
static const uint8_t E25_len[] = {
     2,  3,  3,  4,  4,  4,  4,  5,  5,
     5,  5,  6,  6,  6,  6,  7,  7,  7,
     7,  7,  7,  8,  8,  8,  8
};

static const uint16_t E25_code[] = {
    0x0003, 0x0003, 0x0002, 0x000b, 0x000a, 0x0001, 0x0000, 0x0011, 0x0010,
    0x0005, 0x0004, 0x0026, 0x0025, 0x000e, 0x000d, 0x004f, 0x004e, 0x0048,
    0x001f, 0x0019, 0x0018, 0x0093, 0x0092, 0x003d, 0x003c
};

//
// Table F25
//
static const uint8_t F25_len[] = {
     3,  3,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  5,  5,  5,  5,  6,  6,  7,
     7,  8,  8,  8,  9, 10, 10
};

static const uint16_t F25_code[] = {
    0x0001, 0x0000, 0x000f, 0x000e, 0x000d, 0x000b, 0x000a, 0x0008, 0x0007,
    0x0005, 0x0004, 0x0018, 0x0013, 0x000d, 0x000c, 0x0025, 0x0024, 0x0066,
    0x0065, 0x00cf, 0x00ce, 0x00c8, 0x0193, 0x0325, 0x0324
};

//
// Table G25
//
static const uint8_t G25_len[] = {
     2,  3,  3,  3,  4,  4,  4,  5,  5,
     5,  6,  6,  6,  7,  7,  7,  7,  8,
     8,  9,  9, 10, 10, 10, 10
};

static const uint16_t G25_code[] = {
    0x0001, 0x0006, 0x0005, 0x0000, 0x000f, 0x0008, 0x0003, 0x001c, 0x0013,
    0x0004, 0x003b, 0x0024, 0x000b, 0x0074, 0x004b, 0x0015, 0x0014, 0x0095,
    0x0094, 0x01d6, 0x01d5, 0x03af, 0x03ae, 0x03a9, 0x03a8
};

//
// Table A33
//
static const uint8_t A33_len[] = {
     3,  3,  3,  4,  4,  4,  4,  4,  4,
     4,  5,  5,  5,  6,  6,  6,  6,  7,
     7,  8,  8,  9,  9, 10, 10, 11, 11,
    12, 12, 13, 13, 13, 13
};

static const uint16_t A33_code[] = {
    0x0002, 0x0001, 0x0000, 0x000e, 0x000d, 0x000c, 0x000b, 0x0009, 0x0008,
    0x0006, 0x001f, 0x0014, 0x000f, 0x003d, 0x003c, 0x001d, 0x001c, 0x0055,
    0x0054, 0x00ae, 0x00ad, 0x015f, 0x015e, 0x02b3, 0x02b2, 0x0563, 0x0562,
    0x0ac3, 0x0ac2, 0x1583, 0x1582, 0x1581, 0x1580
};

//
// Table B33
//
static const uint8_t B33_len[] = {
     3,  4,  4,  4,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  5,  5,  5,  5,  6,
     6,  6,  6,  7,  7,  7,  7,  7,  7,
     8,  8,  8,  9, 10, 10
};

static const uint16_t B33_code[] = {
    0x0001, 0x000f, 0x000e, 0x000b, 0x000a, 0x0008, 0x0007, 0x0004, 0x0001,
    0x001b, 0x001a, 0x0013, 0x0012, 0x000c, 0x000b, 0x0001, 0x0000, 0x0032,
    0x0031, 0x001a, 0x0015, 0x0067, 0x0066, 0x0060, 0x0037, 0x0029, 0x0028,
    0x00c2, 0x006d, 0x006c, 0x0187, 0x030d, 0x030c
};

//
// Table C33
//
static const uint8_t C33_len[] = {
     4,  4,  4,  4,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  5,  5,  5,  5,  5,
     6,  6,  6,  6,  6,  6,  6,  7,  7,
     7,  7,  7,  8,  9,  9
};

static const uint16_t C33_code[] = {
    0x000d, 0x000b, 0x000a, 0x0008, 0x0007, 0x0004, 0x0003, 0x0002, 0x0001,
    0x001e, 0x001d, 0x0019, 0x0018, 0x0013, 0x0012, 0x000b, 0x000a, 0x0000,
    0x003f, 0x003e, 0x0039, 0x001b, 0x001a, 0x0018, 0x0003, 0x0071, 0x0070,
    0x0032, 0x0005, 0x0004, 0x0067, 0x00cd, 0x00cc
};

//
// Table D33
//
static const uint8_t D33_len[] = {
     2,  3,  3,  3,  4,  4,  4,  5,  5,
     5,  6,  6,  6,  7,  7,  7,  7,  8,
     8,  9,  9, 10, 10, 11, 11, 12, 12,
    13, 13, 14, 14, 14, 14
};

static const uint16_t D33_code[] = {
    0x0001, 0x0006, 0x0005, 0x0000, 0x000f, 0x0008, 0x0003, 0x001c, 0x0013,
    0x0004, 0x003b, 0x0024, 0x000b, 0x0074, 0x004b, 0x0015, 0x0014, 0x0095,
    0x0094, 0x01d5, 0x01d4, 0x03ad, 0x03ac, 0x075d, 0x075c, 0x0ebd, 0x0ebc,
    0x1d7f, 0x1d7e, 0x3afb, 0x3afa, 0x3af9, 0x3af8
};

//
// Table E33
//
static const uint8_t E33_len[] = {
     2,  3,  3,  4,  4,  4,  5,  5,  5,
     5,  5,  6,  6,  6,  6,  7,  7,  7,
     7,  7,  7,  7,  7,  8,  8,  8,  8,
     8,  8,  9,  9,  9,  9
};

static const uint16_t E33_code[] = {
    0x0002, 0x0002, 0x0001, 0x000c, 0x0007, 0x0000, 0x001f, 0x001b, 0x001a,
    0x0003, 0x0002, 0x003b, 0x003a, 0x001b, 0x001a, 0x007b, 0x007a, 0x0078,
    0x0073, 0x0070, 0x0033, 0x0031, 0x0030, 0x00f2, 0x00e5, 0x00e3, 0x00e2,
    0x0065, 0x0064, 0x01e7, 0x01e6, 0x01c9, 0x01c8
};

//
// Table F33
//
static const uint8_t F33_len[] = {
     4,  4,  4,  4,  4,  4,  4,  4,  4,
     4,  4,  5,  5,  5,  5,  5,  5,  6,
     6,  6,  6,  6,  6,  7,  7,  8,  8,
     9,  9,  9, 10, 11, 11
};

static const uint16_t F33_code[] = {
    0x000d, 0x000c, 0x000b, 0x0009, 0x0008, 0x0007, 0x0006, 0x0004, 0x0003,
    0x0001, 0x0000, 0x001e, 0x001d, 0x0015, 0x0014, 0x000a, 0x0005, 0x003f,
    0x003e, 0x0038, 0x0017, 0x0009, 0x0008, 0x002d, 0x002c, 0x00e6, 0x00e5,
    0x01cf, 0x01ce, 0x01c8, 0x0393, 0x0725, 0x0724
};

//
// Table G33
//
static const uint8_t G33_len[] = {
     3,  3,  3,  4,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  6,  6,  6,  6,  7,
     7,  7,  7,  8,  8,  8,  8,  8,  9,
     9,  9,  9,  9, 10, 10
};

static const uint16_t G33_code[] = {
    0x0006, 0x0003, 0x0002, 0x000f, 0x000e, 0x0009, 0x0008, 0x0001, 0x0000,
    0x0016, 0x0015, 0x0006, 0x0005, 0x002e, 0x0029, 0x000e, 0x0009, 0x005e,
    0x0051, 0x001e, 0x0011, 0x00bf, 0x00be, 0x003f, 0x003e, 0x0020, 0x0143,
    0x0141, 0x0140, 0x0043, 0x0042, 0x0285, 0x0284
};

//
// Table A65
//
static const uint8_t A65_len[] = {
     4,  4,  4,  4,  4,  4,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  6,  6,  6,  6,  6,  6,  6,
     7,  7,  7,  7,  7,  7,  8,  8,  8,
     8,  9,  9,  9,  9, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 12, 12, 12, 13,
    13, 13, 13, 14, 14, 15, 15, 16, 16,
    16, 16
};

static const uint16_t A65_code[] = {
    0x0006, 0x0005, 0x0004, 0x0002, 0x0001, 0x0000, 0x001f, 0x001d, 0x001c,
    0x001b, 0x001a, 0x0018, 0x0017, 0x0015, 0x0014, 0x0012, 0x0011, 0x000e,
    0x0007, 0x0006, 0x003d, 0x0032, 0x002d, 0x0026, 0x0021, 0x001f, 0x001e,
    0x0078, 0x0067, 0x0059, 0x0058, 0x0041, 0x0040, 0x00cd, 0x00cc, 0x009d,
    0x009c, 0x01e6, 0x01e5, 0x013e, 0x013d, 0x03cf, 0x03ce, 0x027f, 0x027e,
    0x0793, 0x0792, 0x0790, 0x04f3, 0x04f0, 0x0f23, 0x09e4, 0x09e3, 0x1e45,
    0x1e44, 0x13c5, 0x13c4, 0x2795, 0x2794, 0x4f2d, 0x4f2c, 0x9e5f, 0x9e5e,
    0x9e5d, 0x9e5c
};

//
// Table B65
//
static const uint8_t B65_len[] = {
     4,  4,  4,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  9,
     9,  9,  9,  9,  9, 10, 10, 10, 11,
    12, 12
};

static const uint16_t B65_code[] = {
    0x0004, 0x0002, 0x0001, 0x001e, 0x001d, 0x001a, 0x0019, 0x0017, 0x0016,
    0x0013, 0x0012, 0x0010, 0x000f, 0x000c, 0x000b, 0x0007, 0x0006, 0x003f,
    0x003e, 0x0038, 0x0037, 0x0031, 0x0030, 0x0029, 0x0028, 0x0022, 0x001d,
    0x001a, 0x0015, 0x0014, 0x0003, 0x0000, 0x0073, 0x006d, 0x006c, 0x0056,
    0x0055, 0x0046, 0x0039, 0x0038, 0x0037, 0x0004, 0x0003, 0x00e5, 0x00e4,
    0x00af, 0x00ae, 0x008f, 0x008e, 0x006c, 0x000b, 0x000a, 0x0005, 0x0153,
    0x0152, 0x0150, 0x00db, 0x0009, 0x0008, 0x02a2, 0x01b5, 0x01b4, 0x0547,
    0x0a8d, 0x0a8c
};

//
// Table C65
//
static const uint8_t C65_len[] = {
     5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  8,  8,  8,  8,  8,
     8,  8,  9,  9,  9,  9, 10, 10, 10,
    11, 11
};

static const uint16_t C65_code[] = {
    0x001c, 0x0019, 0x0018, 0x0017, 0x0016, 0x0013, 0x0012, 0x0010, 0x000f,
    0x000d, 0x000c, 0x000a, 0x0009, 0x0007, 0x0006, 0x0004, 0x0003, 0x0001,
    0x0000, 0x003e, 0x003d, 0x003b, 0x003a, 0x0036, 0x0035, 0x002b, 0x002a,
    0x0028, 0x0023, 0x001d, 0x001c, 0x0011, 0x0010, 0x000b, 0x000a, 0x0004,
    0x007f, 0x0079, 0x0078, 0x006e, 0x0069, 0x0053, 0x0052, 0x0044, 0x002f,
    0x002e, 0x002d, 0x000b, 0x000a, 0x00fc, 0x00df, 0x00d1, 0x00d0, 0x008a,
    0x0059, 0x0058, 0x01fb, 0x01bd, 0x01bc, 0x0116, 0x03f5, 0x03f4, 0x022f,
    0x045d, 0x045c
};

//
// Table D65
//
static const uint8_t D65_len[] = {
     3,  3,  3,  4,  4,  4,  4,  5,  5,
     5,  5,  5,  5,  6,  6,  6,  6,  6,
     6,  7,  7,  7,  7,  7,  7,  8,  8,
     8,  8,  8,  8,  8,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 11, 11,
    11, 11, 12, 12, 12, 12, 13, 13, 13,
    13, 13, 14, 14, 14, 15, 15, 15, 15,
    15, 15
};

static const uint16_t D65_code[] = {
    0x0004, 0x0001, 0x0000, 0x000d, 0x000c, 0x0007, 0x0006, 0x001f, 0x001e,
    0x0017, 0x0016, 0x000b, 0x000a, 0x003b, 0x003a, 0x002b, 0x002a, 0x0013,
    0x0012, 0x0073, 0x0072, 0x0053, 0x0052, 0x0023, 0x0022, 0x00e3, 0x00e2,
    0x00a3, 0x00a2, 0x00a0, 0x0043, 0x0040, 0x01c3, 0x01c0, 0x0143, 0x0084,
    0x0083, 0x0384, 0x0383, 0x0284, 0x010b, 0x0105, 0x0104, 0x0705, 0x0704,
    0x0215, 0x0214, 0x0e15, 0x0e14, 0x0a16, 0x0a15, 0x1c2f, 0x1c2e, 0x142f,
    0x142e, 0x1428, 0x385b, 0x2853, 0x2852, 0x70b5, 0x70b4, 0x70b3, 0x70b2,
    0x70b1, 0x70b0
};

//
// Table E65
//
static const uint8_t E65_len[] = {
     3,  3,  4,  4,  4,  5,  5,  5,  5,
     5,  5,  5,  5,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9, 10, 10, 10, 10, 10, 10,
    10, 10
};

static const uint16_t E65_code[] = {
    0x0004, 0x0000, 0x000f, 0x0007, 0x0006, 0x001d, 0x001c, 0x0017, 0x0016,
    0x000a, 0x0009, 0x0006, 0x0005, 0x0036, 0x0035, 0x0030, 0x002b, 0x0028,
    0x0017, 0x0010, 0x000f, 0x0009, 0x0008, 0x0069, 0x0068, 0x0064, 0x0063,
    0x0054, 0x0053, 0x002d, 0x002c, 0x001d, 0x001c, 0x00dd, 0x00dc, 0x00ce,
    0x00cd, 0x00ca, 0x00c5, 0x00ab, 0x00aa, 0x00a4, 0x0047, 0x0045, 0x0044,
    0x01be, 0x01bd, 0x019f, 0x019e, 0x0198, 0x0197, 0x0189, 0x0188, 0x014b,
    0x014a, 0x008d, 0x008c, 0x037f, 0x037e, 0x0379, 0x0378, 0x0333, 0x0332,
    0x032d, 0x032c
};

//
// Table F65
//
static const uint8_t F65_len[] = {
     3,  3,  3,  4,  4,  4,  4,  4,  4,
     5,  5,  5,  5,  6,  6,  6,  6,  7,
     7,  7,  7,  8,  8,  8,  8,  9,  9,
     9,  9, 10, 10, 10, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 13, 13, 13, 13,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14
};

static const uint16_t F65_code[] = {
    0x0006, 0x0003, 0x0002, 0x000f, 0x000e, 0x0009, 0x0008, 0x0001, 0x0000,
    0x0015, 0x0014, 0x0005, 0x0004, 0x002d, 0x002c, 0x000d, 0x000c, 0x005d,
    0x005c, 0x001d, 0x001c, 0x00bd, 0x00bc, 0x003d, 0x003c, 0x017d, 0x017c,
    0x007d, 0x007c, 0x02fd, 0x02fc, 0x00fc, 0x05ff, 0x05fc, 0x01ff, 0x01fa,
    0x0bfd, 0x0bfb, 0x0bfa, 0x03f7, 0x03f6, 0x17f8, 0x07fb, 0x07f3, 0x07f2,
    0x2ff3, 0x2ff2, 0x0ff5, 0x0ff4, 0x0ff3, 0x0ff2, 0x0ff1, 0x0ff0, 0x0fef,
    0x0fee, 0x0fed, 0x0fec, 0x0feb, 0x0fea, 0x0fe9, 0x0fe8, 0x0fe3, 0x0fe2,
    0x0fe1, 0x0fe0
};

//
// Table G65
//
static const uint8_t G65_len[] = {
     4,  4,  4,  4,  4,  4,  4,  4,  5,
     5,  5,  5,  5,  5,  5,  5,  6,  6,
     6,  6,  6,  6,  6,  6,  7,  7,  7,
     7,  7,  7,  7,  7,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  9,  9,  9,  9,
     9,  9,  9,  9, 10, 10, 10, 10, 10,
    10, 10, 10, 11, 11, 11, 11, 11, 11,
    11, 11
};

static const uint16_t G65_code[] = {
    0x000e, 0x000b, 0x000a, 0x0008, 0x0006, 0x0004, 0x0003, 0x0000, 0x001f,
    0x001a, 0x0019, 0x0012, 0x000f, 0x000a, 0x0005, 0x0002, 0x003d, 0x0036,
    0x0031, 0x0026, 0x001d, 0x0016, 0x0009, 0x0006, 0x0079, 0x006e, 0x0061,
    0x004e, 0x0039, 0x002e, 0x0011, 0x000e, 0x00f1, 0x00df, 0x00de, 0x009f,
    0x009e, 0x005f, 0x005e, 0x001f, 0x001e, 0x01e0, 0x0183, 0x0180, 0x00e3,
    0x00e1, 0x00e0, 0x0041, 0x0040, 0x03c2, 0x0305, 0x0303, 0x0302, 0x01c4,
    0x0087, 0x0085, 0x0084, 0x0787, 0x0786, 0x0609, 0x0608, 0x038b, 0x038a,
    0x010d, 0x010c
};

//
// Table SA129
//
static const uint8_t SA129_len[] = {
     2,  3,  3,  3,  4,  4,  4,  5,  5,
     5,  6,  6,  6,  7,  7,  8,  8,  8,
     8,  9,  9, 10, 10, 11, 11, 11, 11,
    12, 12, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 13, 13, 13, 13, 13,
    13, 13, 13, 13, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14
};

static const uint16_t SA129_code[] = {
    0x0001, 0x0006, 0x0005, 0x0000, 0x000f, 0x0008, 0x0003, 0x001c, 0x0013,
    0x0004, 0x003b, 0x0024, 0x000b, 0x004b, 0x004a, 0x00e9, 0x00e8, 0x0029,
    0x0028, 0x0057, 0x0056, 0x03a9, 0x03a8, 0x0755, 0x0754, 0x0155, 0x0154,
    0x02ae, 0x02ad, 0x055f, 0x055e, 0x0559, 0x0558, 0x054f, 0x054e, 0x054d,
    0x054c, 0x054b, 0x054a, 0x0549, 0x0548, 0x0547, 0x0546, 0x0545, 0x0544,
    0x0543, 0x0542, 0x0541, 0x0540, 0x3aff, 0x3afe, 0x3afd, 0x3afc, 0x3afb,
    0x3afa, 0x3af9, 0x3af8, 0x3af7, 0x3af6, 0x3af5, 0x3af4, 0x3af3, 0x3af2,
    0x3af1, 0x3af0, 0x3aef, 0x3aee, 0x3aed, 0x3aec, 0x3aeb, 0x3aea, 0x3ae9,
    0x3ae8, 0x3ae7, 0x3ae6, 0x3ae5, 0x3ae4, 0x3ae3, 0x3ae2, 0x3ae1, 0x3ae0,
    0x3adf, 0x3ade, 0x3add, 0x3adc, 0x3adb, 0x3ada, 0x3ad9, 0x3ad8, 0x3ad7,
    0x3ad6, 0x3ad5, 0x3ad4, 0x3ad3, 0x3ad2, 0x3ad1, 0x3ad0, 0x3acf, 0x3ace,
    0x3acd, 0x3acc, 0x3acb, 0x3aca, 0x3ac9, 0x3ac8, 0x3ac7, 0x3ac6, 0x3ac5,
    0x3ac4, 0x3ac3, 0x3ac2, 0x3ac1, 0x3ac0, 0x3abf, 0x3abe, 0x3abd, 0x3abc,
    0x3abb, 0x3aba, 0x3ab9, 0x3ab8, 0x3ab7, 0x3ab6, 0x3ab5, 0x3ab4, 0x3ab3,
    0x3ab2, 0x3ab1, 0x3ab0
};

//
// Table SB129
//
static const uint8_t SB129_len[] = {
     3,  3,  3,  4,  4,  4,  4,  4,  4,
     4,  5,  5,  5,  6,  6,  6,  6,  7,
     7,  8,  8,  9, 10, 11, 11, 12, 12,
    13, 13, 14, 14, 14, 14, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15
};

static const uint16_t SB129_code[] = {
    0x0003, 0x0002, 0x0001, 0x000f, 0x000e, 0x000c, 0x000b, 0x000a, 0x0009,
    0x0000, 0x001b, 0x0011, 0x0010, 0x0035, 0x0034, 0x0005, 0x0004, 0x000d,
    0x000c, 0x001d, 0x001c, 0x003c, 0x007f, 0x00fd, 0x00fc, 0x01eb, 0x01ea,
    0x03d3, 0x03d2, 0x07a3, 0x07a2, 0x07a1, 0x07a0, 0x0fbf, 0x0fbe, 0x0fbd,
    0x0fbc, 0x0fbb, 0x0fba, 0x0fb9, 0x0fb8, 0x0fb7, 0x0fb6, 0x0fb5, 0x0fb4,
    0x0fb3, 0x0fb2, 0x0fb1, 0x0fb0, 0x0faf, 0x0fae, 0x0fad, 0x0fac, 0x0fab,
    0x0faa, 0x0fa9, 0x0fa8, 0x0fa7, 0x0fa6, 0x0fa5, 0x0fa4, 0x0fa3, 0x0fa2,
    0x0fa1, 0x0fa0, 0x0f9f, 0x0f9e, 0x0f9d, 0x0f9c, 0x0f9b, 0x0f9a, 0x0f99,
    0x0f98, 0x0f97, 0x0f96, 0x0f95, 0x0f94, 0x0f93, 0x0f92, 0x0f91, 0x0f90,
    0x0f8f, 0x0f8e, 0x0f8d, 0x0f8c, 0x0f8b, 0x0f8a, 0x0f89, 0x0f88, 0x0f87,
    0x0f86, 0x0f85, 0x0f84, 0x0f83, 0x0f82, 0x0f81, 0x0f80, 0x0f7f, 0x0f7e,
    0x0f7d, 0x0f7c, 0x0f7b, 0x0f7a, 0x0f79, 0x0f78, 0x0f77, 0x0f76, 0x0f75,
    0x0f74, 0x0f73, 0x0f72, 0x0f71, 0x0f70, 0x0f6f, 0x0f6e, 0x0f6d, 0x0f6c,
    0x0f6b, 0x0f6a, 0x0f69, 0x0f68, 0x0f67, 0x0f66, 0x0f65, 0x0f64, 0x0f63,
    0x0f62, 0x0f61, 0x0f60
};

//
// Table SC129
//
static const uint8_t SC129_len[] = {
     3,  3,  3,  4,  4,  4,  4,  5,  5,
     5,  5,  5,  5,  6,  6,  6,  6,  6,
     6,  7,  7,  7,  7,  7,  7,  8,  8,
     8,  8,  8,  8,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 11, 11, 11,
    11, 11, 12, 12, 12, 12, 12, 12, 13,
    13, 13, 13, 13, 14, 14, 14, 14, 14,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15
};

static const uint16_t SC129_code[] = {
    0x0004, 0x0001, 0x0000, 0x000d, 0x000c, 0x0007, 0x0006, 0x001f, 0x001e,
    0x0017, 0x0016, 0x000b, 0x000a, 0x003b, 0x003a, 0x002b, 0x002a, 0x0013,
    0x0012, 0x0073, 0x0072, 0x0053, 0x0052, 0x0023, 0x0022, 0x00e3, 0x00e2,
    0x00a2, 0x00a1, 0x0042, 0x0041, 0x01c2, 0x01c1, 0x0141, 0x0140, 0x0081,
    0x0080, 0x0381, 0x0380, 0x028c, 0x010f, 0x010c, 0x070f, 0x051c, 0x051b,
    0x021c, 0x021b, 0x0e1c, 0x0e1b, 0x0a35, 0x0a34, 0x0435, 0x0434, 0x1c3a,
    0x1c35, 0x0877, 0x0876, 0x0874, 0x3877, 0x3869, 0x3868, 0x10eb, 0x10ea,
    0x70ed, 0x70ec, 0x70cf, 0x70ce, 0x70cd, 0x70cc, 0x70cb, 0x70ca, 0x70c9,
    0x70c8, 0x70c7, 0x70c6, 0x70c5, 0x70c4, 0x70c3, 0x70c2, 0x70c1, 0x70c0,
    0x51ff, 0x51fe, 0x51fd, 0x51fc, 0x51fb, 0x51fa, 0x51f9, 0x51f8, 0x51f7,
    0x51f6, 0x51f5, 0x51f4, 0x51f3, 0x51f2, 0x51f1, 0x51f0, 0x51ef, 0x51ee,
    0x51ed, 0x51ec, 0x51eb, 0x51ea, 0x51e9, 0x51e8, 0x51e7, 0x51e6, 0x51e5,
    0x51e4, 0x51e3, 0x51e2, 0x51e1, 0x51e0, 0x51df, 0x51de, 0x51dd, 0x51dc,
    0x51db, 0x51da, 0x51d9, 0x51d8, 0x51d7, 0x51d6, 0x51d5, 0x51d4, 0x51d3,
    0x51d2, 0x51d1, 0x51d0
};

//
// Table SD129
//
static const uint8_t SD129_len[] = {
     2,  3,  3,  4,  4,  4,  4,  5,  5,
     5,  5,  6,  6,  6,  6,  7,  7,  7,
     7,  8,  8,  8,  8,  9,  9,  9, 10,
    10, 10, 10, 11, 11, 11, 12, 12, 12,
    12, 12, 13, 13, 13, 14, 14, 14, 14,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15, 15, 15, 15, 15, 15, 15,
    15, 15, 15
};

static const uint16_t SD129_code[] = {
    0x0000, 0x0005, 0x0004, 0x000f, 0x000e, 0x0007, 0x0006, 0x001a, 0x0019,
    0x000a, 0x0009, 0x0036, 0x0031, 0x0016, 0x0011, 0x006e, 0x0061, 0x002e,
    0x0021, 0x00c1, 0x00c0, 0x0041, 0x0040, 0x01bc, 0x00bf, 0x00bc, 0x037f,
    0x037a, 0x017d, 0x017a, 0x06fd, 0x02f9, 0x02f8, 0x0df9, 0x0df8, 0x05ef,
    0x05ee, 0x05ec, 0x1bef, 0x1bd8, 0x0bdb, 0x37dd, 0x37dc, 0x17b5, 0x17b4,
    0x6fb7, 0x6fb6, 0x6fb5, 0x6fb4, 0x6fb3, 0x6fb2, 0x6fb1, 0x6fb0, 0x6faf,
    0x6fae, 0x6fad, 0x6fac, 0x6fab, 0x6faa, 0x6fa9, 0x6fa8, 0x6fa7, 0x6fa6,
    0x6fa5, 0x6fa4, 0x6fa3, 0x6fa2, 0x6fa1, 0x6fa0, 0x6f9f, 0x6f9e, 0x6f9d,
    0x6f9c, 0x6f9b, 0x6f9a, 0x6f99, 0x6f98, 0x6f97, 0x6f96, 0x6f95, 0x6f94,
    0x6f93, 0x6f92, 0x6f91, 0x6f90, 0x6f8f, 0x6f8e, 0x6f8d, 0x6f8c, 0x6f8b,
    0x6f8a, 0x6f89, 0x6f88, 0x6f87, 0x6f86, 0x6f85, 0x6f84, 0x6f83, 0x6f82,
    0x6f81, 0x6f80, 0x6f7f, 0x6f7e, 0x6f7d, 0x6f7c, 0x6f7b, 0x6f7a, 0x6f79,
    0x6f78, 0x6f77, 0x6f76, 0x6f75, 0x6f74, 0x6f73, 0x6f72, 0x6f71, 0x6f70,
    0x6f6f, 0x6f6e, 0x6f6d, 0x6f6c, 0x6f6b, 0x6f6a, 0x6f69, 0x6f68, 0x6f67,
    0x6f66, 0x6f65, 0x6f64
};

//
// Table SE129
//
static const uint8_t SE129_len[] = {
     4,  4,  4,  4,  4,  4,  4,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  5,  6,
     6,  6,  6,  6,  6,  6,  6,  7,  7,
     7,  7,  7,  7,  7,  7,  8,  8,  8,
     8,  8,  8,  8,  8,  9,  9,  9,  9,
     9,  9,  9,  9, 10, 10, 10, 10, 10,
    10, 10, 10, 11, 11, 11, 11, 11, 11,
    11, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 13, 13, 13, 13, 13, 13, 13, 13,
    14, 14, 14, 14, 14, 14, 14, 14, 15,
    15, 15, 15, 15, 15, 15, 15, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16
};

static const uint16_t SE129_code[] = {
    0x000e, 0x000b, 0x000a, 0x0007, 0x0006, 0x0003, 0x0002, 0x001f, 0x001e,
    0x0019, 0x0018, 0x0011, 0x0010, 0x0009, 0x0008, 0x0001, 0x0000, 0x0035,
    0x0034, 0x0025, 0x0024, 0x0015, 0x0014, 0x0005, 0x0004, 0x006d, 0x006c,
    0x004d, 0x004c, 0x002d, 0x002c, 0x000d, 0x000c, 0x00dd, 0x00dc, 0x009d,
    0x009c, 0x005d, 0x005c, 0x001d, 0x001c, 0x01bd, 0x01bc, 0x013d, 0x013c,
    0x00bd, 0x00bc, 0x003d, 0x003c, 0x037c, 0x027f, 0x027d, 0x027c, 0x017d,
    0x017c, 0x007d, 0x007c, 0x06fc, 0x06fb, 0x04fc, 0x02ff, 0x02fc, 0x00ff,
    0x00fc, 0x0dff, 0x0dfb, 0x0dfa, 0x09fb, 0x09fa, 0x05fb, 0x05fa, 0x01fb,
    0x01fa, 0x1bf8, 0x1beb, 0x1be8, 0x0bfb, 0x0bf9, 0x0bf8, 0x03f9, 0x03f8,
    0x37fa, 0x37f9, 0x37d3, 0x37d2, 0x17f4, 0x07f7, 0x07f6, 0x07f5, 0x6ff7,
    0x6ff6, 0x6fa9, 0x6fa8, 0x2feb, 0x2fea, 0x0fe9, 0x0fe8, 0xdfe3, 0xdfe2,
    0xdfe1, 0xdfe0, 0xdfdf, 0xdfde, 0xdfdd, 0xdfdc, 0xdfdb, 0xdfda, 0xdfd9,
    0xdfd8, 0xdfd7, 0xdfd6, 0xdfd5, 0xdfd4, 0xdfd3, 0xdfd2, 0xdfd1, 0xdfd0,
    0xdfcf, 0xdfce, 0xdfcd, 0xdfcc, 0xdfcb, 0xdfca, 0xdfc9, 0xdfc8, 0xdf57,
    0xdf56, 0xdf55, 0xdf54
};

//
// Table A129
//
static const uint8_t A129_len[] = {
     4,  4,  4,  4,  5,  5,  5,  5,  5,
     5,  5,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10,
    11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11
};

static const uint16_t A129_code[] = {
    0x0008, 0x000a, 0x0009, 0x0000, 0x001f, 0x0018, 0x0017, 0x000c, 0x000b,
    0x0005, 0x0004, 0x003c, 0x003a, 0x0036, 0x0035, 0x002d, 0x002c, 0x001c,
    0x001b, 0x0013, 0x0012, 0x000e, 0x000d, 0x0006, 0x0005, 0x007a, 0x0077,
    0x0071, 0x0070, 0x0068, 0x0067, 0x0064, 0x003f, 0x003c, 0x003b, 0x0034,
    0x002b, 0x0028, 0x0023, 0x0020, 0x001f, 0x000f, 0x000e, 0x00f7, 0x00f6,
    0x00e7, 0x00e6, 0x00df, 0x00de, 0x00d3, 0x00d2, 0x00cb, 0x00ca, 0x007b,
    0x007a, 0x0074, 0x006b, 0x0054, 0x0053, 0x0044, 0x0043, 0x003c, 0x0033,
    0x0031, 0x0030, 0x0011, 0x0010, 0x01da, 0x01d9, 0x01ca, 0x01c9, 0x01ba,
    0x01b9, 0x019b, 0x019a, 0x00fb, 0x00fa, 0x00f8, 0x00eb, 0x00d5, 0x00d4,
    0x00aa, 0x00a5, 0x008b, 0x008a, 0x0084, 0x007b, 0x0065, 0x0064, 0x0025,
    0x0024, 0x03b6, 0x03b1, 0x0397, 0x0396, 0x0390, 0x0377, 0x0371, 0x0370,
    0x0332, 0x0331, 0x01f3, 0x01f2, 0x01d5, 0x01d4, 0x0157, 0x0156, 0x0149,
    0x0148, 0x010b, 0x010a, 0x00f5, 0x00f4, 0x004f, 0x004e, 0x004d, 0x004c,
    0x076f, 0x076e, 0x0761, 0x0760, 0x0723, 0x0722, 0x06ed, 0x06ec, 0x0667,
    0x0666, 0x0661, 0x0660
};

//
// Table B129
//
static const uint8_t B129_len[] = {
     5,  5,  5,  5,  5,  5,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 10, 11, 11, 11,
    11, 11, 11, 11, 12, 12, 12, 12, 12,
    13, 14, 14
};

static const uint16_t B129_code[] = {
    0x000a, 0x0007, 0x0006, 0x0004, 0x0003, 0x0000, 0x003f, 0x003c, 0x003b,
    0x0039, 0x0038, 0x0035, 0x0034, 0x0032, 0x0031, 0x002e, 0x002d, 0x002b,
    0x002a, 0x0027, 0x0026, 0x0023, 0x0022, 0x0020, 0x001f, 0x001c, 0x001b,
    0x0019, 0x0018, 0x0016, 0x0013, 0x0010, 0x000b, 0x0005, 0x0004, 0x007d,
    0x007c, 0x007a, 0x0075, 0x006e, 0x006d, 0x0067, 0x0066, 0x0060, 0x005f,
    0x0059, 0x0058, 0x0051, 0x0050, 0x004a, 0x0049, 0x0042, 0x003d, 0x003b,
    0x003a, 0x0034, 0x002f, 0x0025, 0x0024, 0x0015, 0x0014, 0x0006, 0x0005,
    0x00f7, 0x00f6, 0x00df, 0x00de, 0x00d9, 0x00d8, 0x00bd, 0x00bc, 0x00a6,
    0x00a5, 0x0097, 0x0096, 0x0090, 0x0087, 0x0079, 0x0078, 0x006a, 0x005d,
    0x0047, 0x0046, 0x0044, 0x000f, 0x0009, 0x0008, 0x01d2, 0x01d1, 0x0187,
    0x0186, 0x0184, 0x014f, 0x0149, 0x0148, 0x010d, 0x010c, 0x00d7, 0x00d6,
    0x00b8, 0x008b, 0x001d, 0x001c, 0x03a6, 0x03a1, 0x030b, 0x030a, 0x029c,
    0x0247, 0x0246, 0x0245, 0x0173, 0x0172, 0x0114, 0x074f, 0x0741, 0x0740,
    0x053a, 0x0489, 0x0488, 0x022b, 0x0e9d, 0x0e9c, 0x0a76, 0x0455, 0x0454,
    0x14ef, 0x29dd, 0x29dc
};

//
// Table C129
//
static const uint8_t C129_len[] = {
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 11, 11, 11, 11, 11,
    12, 13, 13
};

static const uint16_t C129_code[] = {
    0x003a, 0x0037, 0x0036, 0x0034, 0x0033, 0x0031, 0x0030, 0x002e, 0x002d,
    0x002b, 0x002a, 0x0028, 0x0027, 0x0025, 0x0024, 0x0022, 0x0021, 0x001e,
    0x001d, 0x001b, 0x001a, 0x0018, 0x0017, 0x0015, 0x0014, 0x0012, 0x0011,
    0x000e, 0x000d, 0x000c, 0x000b, 0x0008, 0x0007, 0x0006, 0x0005, 0x0003,
    0x0002, 0x007f, 0x007e, 0x007c, 0x007b, 0x0079, 0x0078, 0x0076, 0x0073,
    0x0071, 0x0070, 0x006a, 0x0065, 0x005f, 0x005e, 0x0058, 0x0053, 0x004d,
    0x004c, 0x0046, 0x0041, 0x0040, 0x003f, 0x0038, 0x0033, 0x002d, 0x002c,
    0x0027, 0x0026, 0x001f, 0x001e, 0x0014, 0x0013, 0x0012, 0x0009, 0x0003,
    0x0002, 0x0000, 0x00fb, 0x00f5, 0x00f4, 0x00ee, 0x00e5, 0x00d7, 0x00d6,
    0x00c8, 0x00b3, 0x00a5, 0x00a4, 0x008f, 0x008e, 0x007c, 0x0073, 0x0065,
    0x0064, 0x0042, 0x0041, 0x002b, 0x002a, 0x0011, 0x0010, 0x0002, 0x01f5,
    0x01df, 0x01de, 0x01c8, 0x0193, 0x0165, 0x0164, 0x00fb, 0x00fa, 0x00e4,
    0x0087, 0x0081, 0x0080, 0x0006, 0x03e9, 0x03e8, 0x0393, 0x0325, 0x0324,
    0x01ca, 0x010d, 0x010c, 0x000f, 0x0725, 0x0724, 0x0396, 0x001d, 0x001c,
    0x072f, 0x0e5d, 0x0e5c
};

//
// Table D129
//
static const uint8_t D129_len[] = {
     4,  4,  4,  4,  4,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  5,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 13, 13, 13, 13, 13, 13,
    13, 13, 14, 14, 14, 14, 14, 14, 14,
    14, 14, 14, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16
};

static const uint16_t D129_code[] = {
    0x0009, 0x0006, 0x0005, 0x0002, 0x0001, 0x001e, 0x001d, 0x001a, 0x0019,
    0x0016, 0x0015, 0x0010, 0x000f, 0x0008, 0x0007, 0x0000, 0x003f, 0x0038,
    0x0037, 0x0030, 0x002f, 0x0028, 0x0023, 0x001c, 0x0013, 0x000c, 0x0003,
    0x007c, 0x0073, 0x006c, 0x0063, 0x005c, 0x0053, 0x0044, 0x003b, 0x0024,
    0x001b, 0x0004, 0x00fb, 0x00e4, 0x00db, 0x00c4, 0x00bb, 0x00a4, 0x008b,
    0x0074, 0x004b, 0x0034, 0x000b, 0x01f5, 0x01f4, 0x01b5, 0x01b4, 0x0175,
    0x0174, 0x0115, 0x0114, 0x0095, 0x0094, 0x0015, 0x0014, 0x0395, 0x0394,
    0x0315, 0x0314, 0x0295, 0x0294, 0x01d5, 0x01d4, 0x00d6, 0x00d5, 0x072e,
    0x072d, 0x062e, 0x062d, 0x052e, 0x052d, 0x03ae, 0x03ad, 0x01af, 0x01ae,
    0x0e5f, 0x0e5e, 0x0c5f, 0x0c5e, 0x0c58, 0x0a5f, 0x0a58, 0x075f, 0x0758,
    0x0353, 0x0351, 0x0350, 0x1cb2, 0x1cb1, 0x18b2, 0x14bd, 0x0ebd, 0x0ebc,
    0x0eb2, 0x06a5, 0x3967, 0x3966, 0x3960, 0x3167, 0x2979, 0x2978, 0x2964,
    0x1d67, 0x0d49, 0x0d48, 0x72c2, 0x62cd, 0x52cb, 0x52ca, 0x3acd, 0x3acc,
    0xe587, 0xe586, 0xc599, 0xc598, 0xa59f, 0xa59e, 0xa59d, 0xa59c, 0xa59b,
    0xa59a, 0xa599, 0xa598
};

//
// Table E129
//
static const uint8_t E129_len[] = {
     5,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 11, 11, 11, 11, 11,
    11, 11, 11, 12, 12, 12, 12, 12, 12,
    13, 13, 13, 13, 13, 13, 14, 14, 14,
    14, 14, 14, 15, 15, 15, 15, 15, 15,
    16, 16, 16, 16, 16, 16, 16, 16, 16,
    16, 16, 16
};

static const uint16_t E129_code[] = {
    0x000c, 0x000b, 0x000a, 0x0009, 0x0008, 0x0007, 0x0006, 0x0004, 0x0003,
    0x0002, 0x0001, 0x0000, 0x003f, 0x003d, 0x003c, 0x003b, 0x003a, 0x0038,
    0x0037, 0x0035, 0x0034, 0x0033, 0x0032, 0x002f, 0x002e, 0x002d, 0x002c,
    0x002a, 0x0029, 0x0026, 0x0025, 0x0024, 0x0023, 0x0020, 0x001f, 0x001d,
    0x001c, 0x001a, 0x000b, 0x007d, 0x007c, 0x006d, 0x006c, 0x0062, 0x0061,
    0x0057, 0x0056, 0x004f, 0x004e, 0x0044, 0x0043, 0x003c, 0x0037, 0x0015,
    0x0014, 0x00e6, 0x00e5, 0x00c6, 0x00c1, 0x00a3, 0x00a2, 0x008b, 0x008a,
    0x007b, 0x007a, 0x006c, 0x01cf, 0x01c9, 0x01c8, 0x0181, 0x0180, 0x0141,
    0x0140, 0x010a, 0x0109, 0x00da, 0x039d, 0x031e, 0x031d, 0x0286, 0x0285,
    0x0217, 0x0216, 0x0210, 0x01b7, 0x0738, 0x063f, 0x0638, 0x050f, 0x0508,
    0x0423, 0x036d, 0x036c, 0x0c7d, 0x0c7c, 0x0a1d, 0x0a1c, 0x0845, 0x0844,
    0x1ce6, 0x1ce5, 0x18e6, 0x18e5, 0x1426, 0x1425, 0x39cf, 0x39ce, 0x31cf,
    0x31ce, 0x284e, 0x2849, 0x7393, 0x7392, 0x7390, 0x6393, 0x5091, 0x5090,
    0xe723, 0xe722, 0xc724, 0xa13d, 0xc725, 0xa13e, 0xc722, 0xa13f, 0xc723,
    0xc720, 0xc721, 0xa13c
};

//
// Table F129
//
static const uint8_t F129_len[] = {
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 11, 11, 11, 11, 11, 11,
    12, 12, 12, 12, 12, 12, 13, 13, 13,
    14, 15, 15
};

static const uint16_t F129_code[] = {
    0x0038, 0x0037, 0x0036, 0x0034, 0x0033, 0x0032, 0x0031, 0x0030, 0x002f,
    0x002e, 0x002d, 0x002c, 0x002b, 0x0029, 0x0028, 0x0027, 0x0026, 0x0024,
    0x0023, 0x0022, 0x0021, 0x001f, 0x001e, 0x001d, 0x001c, 0x001a, 0x0019,
    0x0017, 0x0016, 0x0015, 0x0014, 0x0012, 0x0011, 0x000f, 0x000e, 0x000c,
    0x000b, 0x0009, 0x0008, 0x0007, 0x0006, 0x0003, 0x0002, 0x0001, 0x0000,
    0x007d, 0x007c, 0x007b, 0x007a, 0x0078, 0x0077, 0x0074, 0x0073, 0x0072,
    0x006b, 0x0054, 0x004b, 0x0041, 0x0040, 0x0036, 0x0031, 0x0027, 0x0026,
    0x001b, 0x001a, 0x0014, 0x000b, 0x000a, 0x0009, 0x00fe, 0x00fd, 0x00f3,
    0x00f2, 0x00eb, 0x00ea, 0x00d5, 0x00d4, 0x0095, 0x0094, 0x006e, 0x0061,
    0x0042, 0x0041, 0x002b, 0x002a, 0x0010, 0x01ff, 0x01f9, 0x01f8, 0x01da,
    0x01d9, 0x0157, 0x0156, 0x0154, 0x00df, 0x00c0, 0x0087, 0x0081, 0x0080,
    0x0022, 0x03fd, 0x03b7, 0x03b6, 0x03b0, 0x02ab, 0x01bd, 0x01bc, 0x010d,
    0x010c, 0x0047, 0x0046, 0x07f8, 0x0763, 0x0554, 0x0307, 0x0306, 0x0305,
    0x0ff3, 0x0ff2, 0x0ec4, 0x0aab, 0x0609, 0x0608, 0x1d8a, 0x1555, 0x1554,
    0x3b17, 0x762d, 0x762c
};

//
// Table G129
//
static const uint8_t G129_len[] = {
     4,  5,  5,  5,  5,  5,  5,  5,  5,
     5,  5,  5,  5,  5,  5,  6,  6,  6,
     6,  6,  6,  6,  6,  6,  6,  6,  6,
     6,  6,  6,  6,  7,  7,  7,  7,  7,
     7,  7,  7,  7,  7,  7,  7,  7,  7,
     7,  7,  7,  8,  8,  8,  8,  8,  8,
     8,  8,  8,  8,  8,  8,  8,  8,  8,
     9,  9,  9,  9,  9,  9,  9,  9,  9,
     9,  9,  9,  9,  9,  9,  9, 10, 10,
    10, 10, 10, 10, 10, 10, 10, 10, 10,
    10, 10, 10, 10, 10, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 12, 12, 12, 12, 12, 12,
    12, 12, 12, 12, 12, 12, 12, 12, 13,
    13, 13, 13
};

static const uint16_t G129_code[] = {
    0x0000, 0x001d, 0x001c, 0x0019, 0x0018, 0x0015, 0x0014, 0x0011, 0x0010,
    0x000d, 0x000c, 0x0009, 0x0008, 0x0005, 0x0004, 0x003f, 0x003e, 0x0037,
    0x0036, 0x002f, 0x002e, 0x0027, 0x0026, 0x001f, 0x001e, 0x0017, 0x0016,
    0x000f, 0x000e, 0x0007, 0x0006, 0x007b, 0x007a, 0x006b, 0x006a, 0x005b,
    0x005a, 0x004b, 0x004a, 0x003b, 0x003a, 0x002b, 0x002a, 0x001b, 0x001a,
    0x000b, 0x000a, 0x0008, 0x00f3, 0x00f0, 0x00d3, 0x00d0, 0x00b3, 0x00b0,
    0x0093, 0x0090, 0x0073, 0x0070, 0x0053, 0x0050, 0x0033, 0x0030, 0x0013,
    0x01e4, 0x01e3, 0x01a5, 0x01a4, 0x0165, 0x0164, 0x0125, 0x0124, 0x00e5,
    0x00e4, 0x00e2, 0x00a5, 0x00a2, 0x0065, 0x0062, 0x0025, 0x03ca, 0x03c5,
    0x0347, 0x0346, 0x02c7, 0x02c6, 0x02c4, 0x0247, 0x0244, 0x01c7, 0x0149,
    0x0148, 0x00c9, 0x00c8, 0x00c6, 0x0049, 0x0796, 0x0789, 0x068b, 0x068a,
    0x0688, 0x058b, 0x048d, 0x048c, 0x048a, 0x038d, 0x028f, 0x028e, 0x028c,
    0x018f, 0x0091, 0x0090, 0x0f2e, 0x0f11, 0x0d13, 0x0d12, 0x0b15, 0x0b14,
    0x0917, 0x0916, 0x0719, 0x0718, 0x051b, 0x051a, 0x031d, 0x031c, 0x1e5f,
    0x1e5e, 0x1e21, 0x1e20
};

//
// Code books
//
static const struct huffman transition_mode_huff[] = {
    { A4_len, A4_code, 4 },
    { B4_len, B4_code, 4 },
    { C4_len, C4_code, 4 },
    { D4_len, D4_code, 4 }
};

static const struct huffman scale_factor_huff[] = {
    { SA129_len, SA129_code, 129 },
    { SB129_len, SB129_code, 129 },
    { SC129_len, SC129_code, 129 },
    { SD129_len, SD129_code, 129 },
    { SE129_len, SE129_code, 129 }
};

static const struct huffman bit_allocation_huff[] = {
    { A12_len, A12_code, 12 },
    { B12_len, B12_code, 12 },
    { C12_len, C12_code, 12 },
    { D12_len, D12_code, 12 },
    { E12_len, E12_code, 12 }
};

static const struct huffman quant_index_huff_0[] = {
    { A3_len, A3_code, 3 }
};

static const struct huffman quant_index_huff_1[] = {
    { A5_len, A5_code, 5 },
    { B5_len, B5_code, 5 },
    { C5_len, C5_code, 5 }
};

static const struct huffman quant_index_huff_2[] = {
    { A7_len, A7_code, 7 },
    { B7_len, B7_code, 7 },
    { C7_len, C7_code, 7 }
};

static const struct huffman quant_index_huff_3[] = {
    { A9_len, A9_code, 9 },
    { B9_len, B9_code, 9 },
    { C9_len, C9_code, 9 }
};

static const struct huffman quant_index_huff_4[] = {
    { A13_len, A13_code, 13 },
    { B13_len, B13_code, 13 },
    { C13_len, C13_code, 13 }
};

static const struct huffman quant_index_huff_5[] = {
    { A17_len, A17_code, 17 },
    { B17_len, B17_code, 17 },
    { C17_len, C17_code, 17 },
    { D17_len, D17_code, 17 },
    { E17_len, E17_code, 17 },
    { F17_len, F17_code, 17 },
    { G17_len, G17_code, 17 }
};

static const struct huffman quant_index_huff_6[] = {
    { A25_len, A25_code, 25 },
    { B25_len, B25_code, 25 },
    { C25_len, C25_code, 25 },
    { D25_len, D25_code, 25 },
    { E25_len, E25_code, 25 },
    { F25_len, F25_code, 25 },
    { G25_len, G25_code, 25 }
};

static const struct huffman quant_index_huff_7[] = {
    { A33_len, A33_code, 33 },
    { B33_len, B33_code, 33 },
    { C33_len, C33_code, 33 },
    { D33_len, D33_code, 33 },
    { E33_len, E33_code, 33 },
    { F33_len, F33_code, 33 },
    { G33_len, G33_code, 33 }
};

static const struct huffman quant_index_huff_8[] = {
    { A65_len, A65_code, 65 },
    { B65_len, B65_code, 65 },
    { C65_len, C65_code, 65 },
    { D65_len, D65_code, 65 },
    { E65_len, E65_code, 65 },
    { F65_len, F65_code, 65 },
    { G65_len, G65_code, 65 }
};

static const struct huffman quant_index_huff_9[] = {
    { A129_len, A129_code, 129 },
    { B129_len, B129_code, 129 },
    { C129_len, C129_code, 129 },
    { D129_len, D129_code, 129 },
    { E129_len, E129_code, 129 },
    { F129_len, F129_code, 129 },
    { G129_len, G129_code, 129 }
};

static const struct huffman * const quant_index_group_huff[] = {
    quant_index_huff_0,
    quant_index_huff_1,
    quant_index_huff_2,
    quant_index_huff_3,
    quant_index_huff_4,
    quant_index_huff_5,
    quant_index_huff_6,
    quant_index_huff_7,
    quant_index_huff_8,
    quant_index_huff_9
};

static const uint8_t quant_index_group_size[] = {
    1, 3, 3, 3, 3, 7, 7, 7, 7, 7
};
